/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.message.service.impl;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.SysUtil;
import com.els.modules.logic.service.AccountRpcService;
import com.els.modules.message.entity.ElsMsgConfigHead;
import com.els.modules.message.entity.ElsMsgConfigItem;
import com.els.modules.message.handle.ISendMsgService;
import com.els.modules.message.handle.enums.ReceiveTypeEnum;
import com.els.modules.message.handle.enums.SendMsgTypeEnum;
import com.els.modules.message.service.ElsMsgConfigHeadService;
import com.els.modules.message.service.ElsMsgConfigItemService;
import com.els.modules.message.service.MsgService;
import com.els.modules.message.util.MessageHandleFactory;
import com.els.modules.message.vo.MsgParamsVO;
import com.els.modules.message.vo.MsgVO;
import com.els.modules.system.entity.ElsSubAccount;
import com.els.modules.system.entity.PersonalSetting;
import com.els.modules.system.service.PersonalSettingService;
import com.els.modules.system.util.I18nUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.shiro.SecurityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
public class MsgServiceImpl
implements MsgService {
    private static final Logger log = LoggerFactory.getLogger(MsgServiceImpl.class);
    @Autowired
    private ElsMsgConfigHeadService elsMsgConfigHeadService;
    @Autowired
    private ElsMsgConfigItemService elsMsgConfigItemService;
    @Autowired
    private PersonalSettingService personalSettingService;
    @Resource
    private AccountRpcService accountRpcService;

    @Async
    @Deprecated
    public void sendMsg(List<ElsMsgConfigItem> configItemList, String businessType, String operateType, MsgParamsVO paramsVO) {
        try {
            LoginUser loginUser;
            Map<String, List<ElsSubAccount>> receiverMap = paramsVO.getReceiverMap();
            Map<String, JSONObject> receiveParamMap = paramsVO.getReceiveParamMap();
            if (receiverMap == null) {
                return;
            }
            try {
                loginUser = (LoginUser)SecurityUtils.getSubject().getPrincipal();
            }
            catch (Exception e) {
                loginUser = new LoginUser();
                loginUser.setElsAccount("system");
                loginUser.setSubAccount("system");
                loginUser.setRealname("system");
            }
            for (String elsAccount : receiverMap.keySet()) {
                List<ElsSubAccount> accountList = receiverMap.get(elsAccount);
                if (CollectionUtils.isEmpty(accountList)) continue;
                for (ElsSubAccount account : accountList) {
                    LambdaQueryWrapper query = new LambdaQueryWrapper();
                    query.eq(PersonalSetting::getElsAccount, (Object)elsAccount);
                    query.eq(PersonalSetting::getSubAccount, (Object)account.getSubAccount());
                    query.eq(PersonalSetting::getIsReceive, (Object)"0");
                    List personalSettings = this.personalSettingService.list((Wrapper)query);
                    List<String> list = this.processData(personalSettings);
                    for (ElsMsgConfigItem item : configItemList) {
                        if (!list.contains(item.getMsgType())) continue;
                        ISendMsgService sendMsgHandle = MessageHandleFactory.getMsgHandle(item.getMsgType());
                        MsgVO msgVO = new MsgVO();
                        msgVO.setElsMsgConfigItem(item);
                        msgVO.setAccount(account);
                        msgVO.setLoginUser(loginUser);
                        msgVO.setParams(paramsVO.getParams());
                        if (receiveParamMap != null && receiveParamMap.containsKey(elsAccount)) {
                            msgVO.setUrlParam(SysUtil.getUrlParamByJson(receiveParamMap.get(elsAccount)));
                        } else {
                            msgVO.setUrlParam(paramsVO.getUrlParam());
                        }
                        msgVO.setBusinessType(businessType);
                        msgVO.setOperateType(operateType);
                        sendMsgHandle.sendMsg(msgVO);
                    }
                }
            }
        }
        catch (Exception e) {
            log.error("sendMsg failed:", (Throwable)e);
        }
    }

    @Async
    @Deprecated
    public void sendMsg(String purchaseElsAccount, String businessType, String operateType, MsgParamsVO paramsVO) {
        try {
            List<ElsMsgConfigItem> configItemList = this.getMsgConfigItemList(purchaseElsAccount, businessType, operateType);
            if (configItemList.isEmpty()) {
                return;
            }
            this.sendMsg(configItemList, businessType, operateType, paramsVO);
        }
        catch (Exception e) {
            log.error("sendMsg failed:", (Throwable)e);
        }
    }

    @Deprecated
    private List<ElsMsgConfigItem> getMsgConfigItemList(String purchaseElsAccount, String businessType, String operateType) {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((QueryWrapper)((QueryWrapper)queryWrapper.eq((Object)"business_type", (Object)businessType)).eq((Object)"operate_type", (Object)operateType)).eq((Object)"els_account", (Object)purchaseElsAccount);
        List configHeadList = this.elsMsgConfigHeadService.list((Wrapper)queryWrapper);
        if (configHeadList.isEmpty()) {
            queryWrapper.clear();
            ((QueryWrapper)((QueryWrapper)queryWrapper.eq((Object)"business_type", (Object)businessType)).eq((Object)"operate_type", (Object)operateType)).eq((Object)"els_account", (Object)"100000");
            configHeadList = this.elsMsgConfigHeadService.list((Wrapper)queryWrapper);
        }
        Assert.notEmpty((Collection)configHeadList, (String)I18nUtil.translate("i18n_alert_LYuXHERW_44d10b7d", "\u672a\u627e\u5230\u6d88\u606f\u914d\u7f6e\uff01"));
        List<ElsMsgConfigItem> configItemList = this.elsMsgConfigItemService.selectByMainId(((ElsMsgConfigHead)configHeadList.get(0)).getId());
        HashMap<String, String> distinctMap = new HashMap<String, String>();
        ArrayList<ElsMsgConfigItem> resultList = new ArrayList<ElsMsgConfigItem>();
        for (ElsMsgConfigItem item : configItemList) {
            if (distinctMap.containsKey(item.getMsgType())) continue;
            resultList.add(item);
            distinctMap.put(item.getMsgType(), item.getMsgType());
        }
        return resultList;
    }

    private List<String> processData(List<PersonalSetting> personalSettings) {
        ArrayList<String> list = new ArrayList<String>();
        list.add(SendMsgTypeEnum.IN_MSG.getType());
        for (PersonalSetting personalSetting : personalSettings) {
            if (ReceiveTypeEnum.EMAIL.getValue().equals(personalSetting.getReceiveType())) {
                list.add(SendMsgTypeEnum.EMAIL.getType());
                continue;
            }
            if (ReceiveTypeEnum.MSG.getValue().equals(personalSetting.getReceiveType())) {
                list.add(SendMsgTypeEnum.SMS.getType());
                continue;
            }
            if (ReceiveTypeEnum.NEWS.getValue().equals(personalSetting.getReceiveType())) {
                list.add(SendMsgTypeEnum.IN_MSG.getType());
                continue;
            }
            if (ReceiveTypeEnum.WECHAT.getValue().equals(personalSetting.getReceiveType())) {
                list.add(SendMsgTypeEnum.WX.getType());
                continue;
            }
            if (ReceiveTypeEnum.WECHAT_EP.getValue().equals(personalSetting.getReceiveType())) {
                list.add(SendMsgTypeEnum.WX_EP.getType());
                continue;
            }
            if (ReceiveTypeEnum.DINGTALK.getValue().equals(personalSetting.getReceiveType())) {
                list.add(SendMsgTypeEnum.DINGTALK.getType());
                continue;
            }
            if (!ReceiveTypeEnum.FEISHU.getValue().equals(personalSetting.getReceiveType())) continue;
            list.add(SendMsgTypeEnum.FEISHU.getType());
        }
        return list;
    }

    @Override
    public void sendMsg(JSONObject msg1) {
        JSONObject msg = JSONObject.parseObject((String)msg1.toJSONString());
        String busAccount = msg.getString("busAccount");
        String businessType = msg.getString("businessType");
        String operateType = msg.getString("operateType");
        String msgConfigHeadId = msg.getString("msgConfigHeadId");
        List<ElsMsgConfigItem> configItemList = this.getMsgConfigItemList(msgConfigHeadId, busAccount, businessType, operateType);
        if (configItemList.isEmpty()) {
            return;
        }
        JSONObject businessObj = msg.getJSONObject("businessObj");
        ElsSubAccount sendAccount = (ElsSubAccount)msg.getObject("sendObj", ElsSubAccount.class);
        JSONArray receiveArray = msg.getJSONArray("receiveList");
        for (Object obj : receiveArray) {
            JSONObject receiveObj = (JSONObject)obj;
            String toElsAccount = receiveObj.getString("toElsAccount");
            String urlParam = receiveObj.getString("urlParam");
            JSONArray toSubAccountArray = receiveObj.getJSONArray("toSubAccountList");
            for (Object subObj : toSubAccountArray) {
                ElsSubAccount receive = (ElsSubAccount)JSONObject.parseObject((String)((JSONObject)subObj).toJSONString(), ElsSubAccount.class);
                List<PersonalSetting> personalSettings = this.accountRpcService.getPersonalSetting(toElsAccount, receive.getSubAccount());
                List<String> list = this.processData(personalSettings);
                for (ElsMsgConfigItem item : configItemList) {
                    if (!list.contains(item.getMsgType())) continue;
                    try {
                        ISendMsgService sendMsgHandle = MessageHandleFactory.getMsgHandle(item.getMsgType());
                        MsgVO msgVO = new MsgVO();
                        msgVO.setElsMsgConfigItem(item);
                        msgVO.setReceiveAccount(receive);
                        msgVO.setSendAccount(sendAccount);
                        msgVO.setParams(businessObj);
                        msgVO.setUrlParam(urlParam);
                        msgVO.setBusinessType(businessType);
                        msgVO.setOperateType(operateType);
                        msgVO.setBusAccount(busAccount);
                        sendMsgHandle.sendMsg(msgVO);
                    }
                    catch (Exception e) {
                        log.error(String.valueOf(msg.toJSONString()) + ",send_msg_fialed:" + item.getMsgType(), (Throwable)e);
                    }
                }
            }
        }
    }

    private List<ElsMsgConfigItem> getMsgConfigItemList(String headId, String busAccount, String businessType, String operateType) {
        List<Object> resultList = new ArrayList();
        if (StrUtil.isNotBlank((CharSequence)headId) && !(resultList = this.elsMsgConfigItemService.selectByMainId(headId)).isEmpty()) {
            return resultList;
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        ((QueryWrapper)((QueryWrapper)queryWrapper.eq((Object)"business_type", (Object)businessType)).eq((Object)"operate_type", (Object)operateType)).eq((Object)"els_account", (Object)busAccount);
        List configHeadList = this.elsMsgConfigHeadService.list((Wrapper)queryWrapper);
        if (configHeadList.isEmpty()) {
            queryWrapper.clear();
            ((QueryWrapper)((QueryWrapper)queryWrapper.eq((Object)"business_type", (Object)businessType)).eq((Object)"operate_type", (Object)operateType)).eq((Object)"els_account", (Object)"100000");
            configHeadList = this.elsMsgConfigHeadService.list((Wrapper)queryWrapper);
        }
        Assert.notEmpty((Collection)configHeadList, (String)(String.valueOf(busAccount) + "_" + businessType + "_" + operateType + ":" + I18nUtil.translate("i18n_alert_LYuXHERW_44d10b7d", "\u672a\u627e\u5230\u6d88\u606f\u914d\u7f6e\uff01")));
        List<ElsMsgConfigItem> configItemList = this.elsMsgConfigItemService.selectByMainId(((ElsMsgConfigHead)configHeadList.get(0)).getId());
        HashMap<String, String> distinctMap = new HashMap<String, String>();
        for (ElsMsgConfigItem item : configItemList) {
            if (distinctMap.containsKey(item.getMsgType())) continue;
            resultList.add(item);
            distinctMap.put(item.getMsgType(), item.getMsgType());
        }
        return resultList;
    }
}

