/*
 * Decompiled with CFR 0.152.
 */
package com.els.common.util;

import com.els.modules.system.util.I18nUtil;
import java.math.BigDecimal;
import java.text.DecimalFormat;

public class BigDecimalUtils {
    public static final String DEFAULT_FORMAT = "###0.00#";
    public static final String UNIT_FORMAT = "###,##0.00####";
    public static final String EMPTY_FLAG = "--";

    private BigDecimalUtils() {
    }

    public static boolean lessThan(BigDecimal num1, BigDecimal num2) {
        return num1.compareTo(num2) == -1;
    }

    public static boolean lessEqual(BigDecimal num1, BigDecimal num2) {
        return num1.compareTo(num2) == -1 || num1.compareTo(num2) == 0;
    }

    public static boolean greaterThan(BigDecimal num1, BigDecimal num2) {
        return num1.compareTo(num2) == 1;
    }

    public static boolean greaterEqual(BigDecimal num1, BigDecimal num2) {
        return num1.compareTo(num2) == 1 || num1.compareTo(num2) == 0;
    }

    public static boolean equal(BigDecimal num1, BigDecimal num2) {
        return num1.compareTo(num2) == 0;
    }

    public static String format(BigDecimal num1, String str) {
        if (null == num1) {
            return null;
        }
        if (null == str) {
            str = DEFAULT_FORMAT;
        }
        DecimalFormat decimalFormat = new DecimalFormat(str);
        return decimalFormat.format(num1);
    }

    public static BigDecimal div10000(BigDecimal num1) {
        if (null == num1) {
            return null;
        }
        return num1.divide(new BigDecimal(10000));
    }

    public static BigDecimal multiply10000(BigDecimal num1) {
        if (null == num1) {
            return null;
        }
        return num1.multiply(new BigDecimal(10000));
    }

    public static String format(BigDecimal num1, String str, String empty) {
        if (null == num1) {
            return empty;
        }
        if (null == str) {
            str = DEFAULT_FORMAT;
        }
        DecimalFormat decimalFormat = new DecimalFormat(str);
        return decimalFormat.format(num1);
    }

    public static BigDecimal add(BigDecimal num1, BigDecimal num2) {
        if (num1 == null) {
            num1 = BigDecimal.ZERO;
        }
        if (num2 == null) {
            num2 = BigDecimal.ZERO;
        }
        return num1.add(num2);
    }

    public static BigDecimal subtract(BigDecimal num1, BigDecimal num2) {
        if (num1 == null) {
            num1 = BigDecimal.ZERO;
        }
        if (num2 == null) {
            num2 = BigDecimal.ZERO;
        }
        return num1.subtract(num2);
    }

    public static BigDecimal multiply(BigDecimal num1, BigDecimal num2) {
        if (num1 == null) {
            num1 = BigDecimal.ZERO;
        }
        if (num2 == null) {
            num2 = BigDecimal.ZERO;
        }
        return num1.multiply(num2);
    }

    public static BigDecimal divide(BigDecimal num1, BigDecimal num2, int scale) {
        if (num1 == null) {
            return BigDecimal.ZERO;
        }
        if (num2 == null) {
            throw new NullPointerException(I18nUtil.translate("", "num2 is null"));
        }
        return num1.divide(num2, scale, 5);
    }
}

