/*
 * Decompiled with CFR 0.152.
 */
package com.els.framework.poi.excel.imports.sax.parse;

import com.els.framework.poi.excel.annotation.ExcelTarget;
import com.els.framework.poi.excel.entity.ImportParams;
import com.els.framework.poi.excel.entity.params.ExcelCollectionParams;
import com.els.framework.poi.excel.entity.params.ExcelImportEntity;
import com.els.framework.poi.excel.entity.sax.SaxReadCellEntity;
import com.els.framework.poi.excel.imports.CellValueServer;
import com.els.framework.poi.excel.imports.base.ImportBaseService;
import com.els.framework.poi.excel.imports.sax.parse.ISaxRowRead;
import com.els.framework.poi.exception.excel.ExcelImportException;
import com.els.framework.poi.handler.inter.IExcelReadRowHanlder;
import com.els.framework.poi.util.PoiPublicUtil;
import com.google.common.collect.Lists;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SaxRowRead
extends ImportBaseService
implements ISaxRowRead {
    private static final Logger LOGGER = LoggerFactory.getLogger(SaxRowRead.class);
    private List list;
    private Class<?> pojoClass;
    private ImportParams params;
    private Map<Integer, String> titlemap = new HashMap<Integer, String>();
    private Object object = null;
    private Map<String, ExcelImportEntity> excelParams = new HashMap<String, ExcelImportEntity>();
    private List<ExcelCollectionParams> excelCollection = new ArrayList<ExcelCollectionParams>();
    private String targetId;
    private CellValueServer cellValueServer;
    private IExcelReadRowHanlder hanlder;

    public SaxRowRead(Class<?> pojoClass, ImportParams params, IExcelReadRowHanlder hanlder) {
        this.list = Lists.newArrayList();
        this.params = params;
        this.pojoClass = pojoClass;
        this.cellValueServer = new CellValueServer();
        this.hanlder = hanlder;
        this.initParams(pojoClass, params);
    }

    private void initParams(Class<?> pojoClass, ImportParams params) {
        try {
            Field[] fileds = PoiPublicUtil.getClassFields(pojoClass);
            ExcelTarget etarget = pojoClass.getAnnotation(ExcelTarget.class);
            if (etarget != null) {
                this.targetId = etarget.value();
            }
            this.getAllExcelField(this.targetId, fileds, this.excelParams, this.excelCollection, pojoClass, null);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new ExcelImportException(e.getMessage());
        }
    }

    @Override
    public <T> List<T> getList() {
        return this.list;
    }

    @Override
    public void parse(int index, List<SaxReadCellEntity> datas) {
        try {
            if (datas == null || datas.size() == 0) {
                return;
            }
            if (index < this.params.getTitleRows()) {
                return;
            }
            if (index < this.params.getTitleRows() + this.params.getHeadRows()) {
                this.addHeadData(datas);
            } else {
                this.addListData(datas);
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new ExcelImportException(e.getMessage());
        }
    }

    private void addListData(List<SaxReadCellEntity> datas) throws Exception {
        if ((datas.get(this.params.getKeyIndex()) == null || StringUtils.isEmpty((String)String.valueOf(datas.get(this.params.getKeyIndex()).getValue()))) && this.object != null) {
            for (ExcelCollectionParams param : this.excelCollection) {
                this.addListContinue(this.object, param, datas, this.titlemap, this.targetId, this.params);
            }
        } else {
            if (this.object != null && this.hanlder != null) {
                this.hanlder.hanlder(this.object);
            }
            this.object = PoiPublicUtil.createObject(this.pojoClass, this.targetId);
            int le = datas.size();
            for (int i = 0; i < le; ++i) {
                SaxReadCellEntity entity = datas.get(i);
                String titleString = this.titlemap.get(i);
                if (!this.excelParams.containsKey(titleString)) continue;
                this.saveFieldValue(this.params, this.object, entity, this.excelParams, titleString);
            }
            for (ExcelCollectionParams param : this.excelCollection) {
                this.addListContinue(this.object, param, datas, this.titlemap, this.targetId, this.params);
            }
            if (this.hanlder == null) {
                this.list.add(this.object);
            }
        }
    }

    private void addListContinue(Object object, ExcelCollectionParams param, List<SaxReadCellEntity> datas, Map<Integer, String> titlemap, String targetId, ImportParams params) throws Exception {
        Collection collection = (Collection)PoiPublicUtil.getMethod(param.getName(), object.getClass()).invoke(object, new Object[0]);
        Object entity = PoiPublicUtil.createObject(param.getType(), targetId);
        boolean isUsed = false;
        for (int i = 0; i < datas.size(); ++i) {
            String titleString = titlemap.get(i);
            if (!param.getExcelParams().containsKey(titleString)) continue;
            this.saveFieldValue(params, entity, datas.get(i), param.getExcelParams(), titleString);
            isUsed = true;
        }
        if (isUsed) {
            collection.add(entity);
        }
    }

    private void saveFieldValue(ImportParams params, Object object, SaxReadCellEntity entity, Map<String, ExcelImportEntity> excelParams, String titleString) throws Exception {
        Object value = this.cellValueServer.getValue(params.getDataHanlder(), object, entity, excelParams, titleString);
        this.setValues(excelParams.get(titleString), object, value);
    }

    private void addHeadData(List<SaxReadCellEntity> datas) {
        for (int i = 0; i < datas.size(); ++i) {
            if (!StringUtils.isNotEmpty((String)String.valueOf(datas.get(i).getValue()))) continue;
            this.titlemap.put(i, String.valueOf(datas.get(i).getValue()));
        }
    }
}

