/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.oss.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.system.query.QueryGenerator;
import com.els.modules.oss.entity.OSSFile;
import com.els.modules.oss.service.IOSSFileService;
import java.io.Serializable;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

@Controller
@RequestMapping(value={"/oss/file"})
public class OSSFileController {
    private static final Logger log = LoggerFactory.getLogger(OSSFileController.class);
    @Autowired
    private IOSSFileService ossFileService;

    @AutoLog(value="\u6587\u4ef6\u7ba1\u7406-\u5206\u9875\u5217\u8868\u67e5\u8be2", logType=2, operateType=1)
    @ResponseBody
    @GetMapping(value={"/list"})
    public Result<IPage<OSSFile>> queryPageList(OSSFile file, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        Result<IPage<OSSFile>> result = new Result<IPage<OSSFile>>();
        QueryWrapper<OSSFile> queryWrapper = QueryGenerator.initQueryWrapper(file, req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.ossFileService.page((IPage)page, (Wrapper)queryWrapper);
        result.setSuccess(true);
        result.setResult(pageList);
        return result;
    }

    @AutoLog(value="\u6587\u4ef6\u7ba1\u7406-\u6587\u4ef6\u4e0a\u4f20", logType=2, operateType=2)
    @ResponseBody
    @PostMapping(value={"/upload"})
    public Result upload(@RequestParam(value="file") MultipartFile multipartFile) {
        Result result = new Result();
        try {
            this.ossFileService.upload(multipartFile);
            result.success("\u4e0a\u4f20\u6210\u529f\uff01");
        }
        catch (Exception ex) {
            log.info(ex.getMessage(), (Throwable)ex);
            result.error500("\u4e0a\u4f20\u5931\u8d25");
        }
        return result;
    }

    @AutoLog(value="\u6587\u4ef6\u7ba1\u7406-\u6587\u4ef6\u5220\u9664", logType=2, operateType=4)
    @ResponseBody
    @GetMapping(value={"/delete"})
    public Result delete(@RequestParam(name="id") String id) {
        Result result = new Result();
        OSSFile file = (OSSFile)this.ossFileService.getById((Serializable)((Object)id));
        if (file == null) {
            result.error500("\u672a\u627e\u5230\u5bf9\u5e94\u5b9e\u4f53");
        } else {
            boolean ok = this.ossFileService.delete(file);
            if (ok) {
                result.success("\u5220\u9664\u6210\u529f!");
            }
        }
        return result;
    }

    @AutoLog(value="\u6587\u4ef6\u7ba1\u7406-\u901a\u8fc7id\u67e5\u8be2", logType=2, operateType=1)
    @ResponseBody
    @GetMapping(value={"/queryById"})
    public Result<OSSFile> queryById(@RequestParam(name="id") String id) {
        Result<OSSFile> result = new Result<OSSFile>();
        OSSFile file = (OSSFile)this.ossFileService.getById((Serializable)((Object)id));
        if (file == null) {
            result.error500("\u672a\u627e\u5230\u5bf9\u5e94\u5b9e\u4f53");
        } else {
            result.setResult(file);
            result.setSuccess(true);
        }
        return result;
    }
}

