/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.aspect;

import cn.hutool.json.JSONUtil;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.FormCommit;
import com.els.common.util.RedisUtil;
import java.io.Serializable;
import java.lang.reflect.Method;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;

@Aspect
@Component
public class DoubleSubmitAspect {
    @Autowired
    private RedisUtil redisUtil;
    private final long DOUBLE_SUBMIT_TIME = 2L;
    private final String DOUBLE_SUBMIT_PREFIX = "DOUBLE_SUBMIT_";

    @Around(value="execution(public * com.els.modules..*.*Controller.*(..)) && @annotation(fct)")
    public Object doAround(ProceedingJoinPoint pjp, FormCommit fct) throws Throwable {
        MethodSignature signature = (MethodSignature)pjp.getSignature();
        Method method = signature.getMethod();
        String sessionId = RequestContextHolder.getRequestAttributes().getSessionId();
        String key = this.getCacheKey(sessionId, method, pjp.getArgs());
        if (this.redisUtil.get(key) != null) {
            return Result.error("\u8bf7\u52ff\u91cd\u590d\u63d0\u4ea4");
        }
        this.redisUtil.set(key, sessionId, 2L);
        return pjp.proceed();
    }

    private String getCacheKey(String sessionId, Method method, Object[] args) {
        String key = "DOUBLE_SUBMIT_" + sessionId + method.getName();
        for (Object arg : args) {
            if (arg instanceof String) {
                key = key + arg;
                continue;
            }
            if (!(arg instanceof Serializable)) continue;
            key = key + JSONUtil.parse((Object)arg).toString();
        }
        return key;
    }
}

