/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.controller;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.query.QueryGenerator;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.ConvertUtils;
import com.els.common.util.DateUtils;
import com.els.config.mybatis.TenantContext;
import com.els.framework.poi.excel.entity.ExportParams;
import com.els.framework.poi.excel.view.ELSEntityExcelView;
import com.els.modules.system.entity.CompanyI18n;
import com.els.modules.system.entity.I18n;
import com.els.modules.system.service.CheckService;
import com.els.modules.system.service.CompanyI18nService;
import com.els.modules.system.service.I18nService;
import com.els.modules.system.vo.I18nVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.shiro.SecurityUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;

@Api(tags={"\u56fd\u9645\u5316"})
@RestController
@RequestMapping(value={"/i18n"})
public class I18nController
extends BaseController<I18n, I18nService> {
    @Autowired
    private I18nService i18nService;
    @Autowired
    private CompanyI18nService companyI18nService;
    @Autowired
    private CheckService checkService;

    @ApiOperation(value="\u56fd\u9645\u5316-\u524d\u7aef\u83b7\u53d6\u7cfb\u7edf\u7ea7\u6570\u636e", notes="\u56fd\u9645\u5316-\u524d\u7aef\u83b7\u53d6\u7cfb\u7edf\u7ea7\u6570\u636e")
    @GetMapping(value={"/getSysList/{language}"})
    public String getI18nJson(@PathVariable(value="language") String language) {
        I18n param = new I18n();
        param.setLanguage(language);
        param.setElsAccount("100000");
        JSONObject json = this.i18nService.findAllList(param);
        return json.toString();
    }

    @ApiOperation(value="\u56fd\u9645\u5316-\u524d\u7aef\u83b7\u53d6\u5f53\u524d\u767b\u5f55\u4f01\u4e1a\u7ea7\u6570\u636e", notes="\u56fd\u9645\u5316-\u524d\u7aef\u83b7\u53d6\u5f53\u524d\u767b\u5f55\u4f01\u4e1a\u7ea7\u6570\u636e")
    @GetMapping(value={"/getCompanyList/{language}"})
    public String getI18nJsonByCompany(@PathVariable(value="language") String language) {
        I18n param = new I18n();
        param.setLanguage(language);
        param.setElsAccount(TenantContext.getTenant());
        JSONObject json = this.i18nService.findAllList(param);
        return json.toString();
    }

    @ApiOperation(value="\u56fd\u9645\u5316-\u524d\u7aef\u83b7\u53d6\u6307\u5b9a\u4f01\u4e1a\u7ea7\u6570\u636e", notes="\u56fd\u9645\u5316-\u524d\u7aef\u83b7\u53d6\u4f01\u4e1a\u7ea7js")
    @GetMapping(value={"/getI18nByBusAccount/{language}/{busAccount}"})
    public String getI18nByBusAccount(@PathVariable(value="language") String language, @PathVariable(value="busAccount") String busAccount) {
        I18n param = new I18n();
        param.setLanguage(language);
        param.setElsAccount(busAccount);
        JSONObject json = this.i18nService.findAllList(param);
        return json.toString();
    }

    @ApiOperation(value="\u56fd\u9645\u5316-\u6e05\u9664\u7f13\u5b58", notes="\u56fd\u9645\u5316-\u6e05\u9664\u7f13\u5b58")
    @GetMapping(value={"/delRedisData"})
    public Result<?> delRedisData() {
        this.i18nService.delRedisData();
        return Result.ok("\u64cd\u4f5c\u6210\u529f\uff01");
    }

    @ApiOperation(value="\u56fd\u9645\u5316-\u7cfb\u7edf\u7ea7\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u56fd\u9645\u5316-\u7cfb\u7edf\u7ea7\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/syslist"})
    public Result<?> querySysPageList(I18n i18n, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper<I18n> queryWrapper = QueryGenerator.initQueryWrapper(i18n, req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        queryWrapper.eq((Object)"els_account", (Object)"100000");
        IPage pageList = this.i18nService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok(pageList);
    }

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    public Result<?> queryPageList(I18n i18n, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        i18n.setFromIndex(pageNo - 1 >= 0 ? (pageNo - 1) * pageSize : 0);
        i18n.setPageSize(pageSize);
        i18n.setElsAccount(TenantContext.getTenant());
        IPage<I18n> pageList = this.i18nService.finPagelist(i18n);
        return Result.ok(pageList);
    }

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/listAll"})
    public Result<?> queryPageListAll(I18nVO i18n, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        i18n.setFromIndex(pageNo - 1 >= 0 ? (pageNo - 1) * pageSize : 0);
        i18n.setPageSize(pageSize);
        i18n.setElsAccount(TenantContext.getTenant());
        IPage<I18nVO> pageList = this.i18nService.finPagelistAll(i18n);
        return Result.ok(pageList);
    }

    @AutoLog(value="\u56fd\u9645\u5316-\u6dfb\u52a0", operateType=2)
    @ApiOperation(value="\u56fd\u9645\u5316-\u6dfb\u52a0", notes="\u56fd\u9645\u5316-\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    public Result<?> add(@RequestBody I18n i18n) {
        String msg;
        String i18nKey = this.i18nService.createI18nKey(i18n.getI18nValue(), i18n.getTranslateType());
        i18n.setI18nKey(i18nKey);
        if (StringUtils.isEmpty((Object)i18n.getLanguage())) {
            i18n.setLanguage("zh");
        }
        if (!"success".equals(msg = this.checkExist(i18n.getId(), i18n.getLanguage() + "-" + i18n.getI18nKey()))) {
            return Result.error(msg);
        }
        this.i18nService.save(i18n);
        return Result.ok(i18n);
    }

    @AutoLog(value="\u56fd\u9645\u5316-\u7f16\u8f91", operateType=3)
    @ApiOperation(value="\u56fd\u9645\u5316-\u7f16\u8f91", notes="\u56fd\u9645\u5316-\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    public Result<?> edit(@RequestBody I18n i18n) {
        String msg = this.checkExist(i18n.getId(), i18n.getLanguage() + "-" + i18n.getI18nKey());
        if (!"success".equals(msg)) {
            return Result.error(msg);
        }
        String elsAccount = TenantContext.getTenant();
        if (!elsAccount.equals(i18n.getElsAccount())) {
            String i18nId = i18n.getI18nId();
            CompanyI18n companyI18n = new CompanyI18n();
            companyI18n.setElsAccount(elsAccount);
            companyI18n.setI18nValue(i18n.getI18nValue());
            companyI18n.setI18nId(i18n.getId());
            if (StrUtil.isBlank((CharSequence)i18nId)) {
                this.companyI18nService.save(companyI18n);
            } else {
                companyI18n.setId(i18n.getI18nId());
                this.companyI18nService.updateById(companyI18n);
            }
        } else {
            this.i18nService.updateById(i18n);
        }
        return Result.ok("\u7f16\u8f91\u6210\u529f!");
    }

    @AutoLog(value="\u56fd\u9645\u5316-\u7f16\u8f91", operateType=3)
    @ApiOperation(value="\u56fd\u9645\u5316-\u7f16\u8f91", notes="\u56fd\u9645\u5316-\u7f16\u8f91")
    @PostMapping(value={"/editNew"})
    public Result<?> editNew(@RequestBody I18nVO i18n) {
        String elsAccount = TenantContext.getTenant();
        LoginUser loginUser = (LoginUser)SecurityUtils.getSubject().getPrincipal();
        String user = loginUser.getSubAccount() + "_" + loginUser.getRealname();
        if (!elsAccount.equals("100000")) {
            List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.i18nService.lambdaQuery().eq(I18n::getI18nKey, (Object)i18n.getI18nKey())).eq(BaseEntity::getElsAccount, (Object)"100000")).eq(I18n::getLanguage, (Object)"en")).list();
            I18n i18n1 = new I18n();
            i18n1.setId(IdWorker.getIdStr());
            i18n1.setI18nKey(i18n.getI18nKey());
            i18n1.setElsAccount("100000");
            i18n1.setLanguage("en");
            i18n1.setI18nValue(i18n.getEnglish());
            i18n1.setCreateBy(user);
            i18n1.setCreateTime(DateUtils.getDate());
            i18n1.setUpdateBy(user);
            i18n1.setUpdateTime(DateUtils.getDate());
            CompanyI18n companyI18n = new CompanyI18n();
            companyI18n.setElsAccount(elsAccount);
            companyI18n.setI18nValue(i18n.getEnglish());
            companyI18n.setI18nId(i18n1.getId());
            companyI18n.setI18nKey(i18n.getI18nKey());
            companyI18n.setLanguage("en");
            if (list.isEmpty()) {
                this.i18nService.save(i18n1);
                this.companyI18nService.save(companyI18n);
            } else {
                boolean update = ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.companyI18nService.lambdaUpdate().eq(CompanyI18n::getI18nId, (Object)((I18n)list.get(0)).getId())).eq(CompanyI18n::getI18nKey, (Object)((I18n)list.get(0)).getI18nKey())).eq(CompanyI18n::getLanguage, (Object)"en")).eq(CompanyI18n::getI18nId, (Object)((I18n)list.get(0)).getId())).eq(BaseEntity::getElsAccount, (Object)elsAccount)).set(BaseEntity::getUpdateBy, (Object)user)).set(BaseEntity::getUpdateTime, (Object)DateUtils.getDate())).set(CompanyI18n::getI18nValue, (Object)i18n.getEnglish())).update();
                if (!update) {
                    this.companyI18nService.save(companyI18n);
                }
            }
        } else {
            boolean update = ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.i18nService.lambdaUpdate().set(I18n::getI18nValue, (Object)i18n.getEnglish())).set(BaseEntity::getUpdateBy, (Object)user)).set(BaseEntity::getUpdateTime, (Object)DateUtils.getDate())).eq(I18n::getI18nKey, (Object)i18n.getI18nKey())).eq(I18n::getLanguage, (Object)"en")).update();
            if (!update) {
                I18n i18n1 = new I18n();
                i18n1.setId(IdWorker.getIdStr());
                i18n1.setI18nKey(i18n.getI18nKey());
                i18n1.setElsAccount("100000");
                i18n1.setLanguage("en");
                i18n1.setI18nValue(i18n.getEnglish());
                i18n1.setCreateBy(user);
                i18n1.setCreateTime(DateUtils.getDate());
                i18n1.setUpdateBy(user);
                i18n1.setUpdateTime(DateUtils.getDate());
                this.i18nService.save(i18n1);
            }
        }
        return Result.ok("\u7f16\u8f91\u6210\u529f!");
    }

    @AutoLog(value="\u56fd\u9645\u5316-\u7ffb\u8bd1", logType=2, operateType=3)
    @ApiOperation(value="\u56fd\u9645\u5316-\u7ffb\u8bd1", notes="\u56fd\u9645\u5316-\u7ffb\u8bd1")
    @GetMapping(value={"/translateData"})
    public Result<?> translate(@RequestParam(name="to", required=true) String to) {
        this.i18nService.translateZh(to);
        return Result.ok("\u7f16\u8f91\u6210\u529f!");
    }

    @AutoLog(value="\u56fd\u9645\u5316-\u901a\u8fc7id\u5220\u9664", logType=2, operateType=4)
    @ApiOperation(value="\u56fd\u9645\u5316-\u901a\u8fc7id\u5220\u9664", notes="\u56fd\u9645\u5316-\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    public Result<?> delete(@RequestParam(name="id", required=true) String id) {
        this.i18nService.removeById((Serializable)((Object)id));
        return Result.ok("\u5220\u9664\u6210\u529f!");
    }

    @AutoLog(value="\u56fd\u9645\u5316-\u901a\u8fc7key\u5220\u9664", logType=2, operateType=4)
    @ApiOperation(value="\u56fd\u9645\u5316-\u901a\u8fc7key\u5220\u9664", notes="\u56fd\u9645\u5316-\u901a\u8fc7key\u5220\u9664")
    @GetMapping(value={"/deleteWord"})
    public Result<?> deleteWord(@RequestParam(name="i18nKey", required=true) String i18nKey) {
        List list = ((LambdaQueryChainWrapper)this.i18nService.lambdaQuery().eq(I18n::getI18nKey, (Object)i18nKey)).list();
        list.forEach(item -> this.i18nService.removeById((Serializable)((Object)item.getId())));
        return Result.ok("\u5220\u9664\u6210\u529f!");
    }

    @AutoLog(value="\u56fd\u9645\u5316-\u6279\u91cf\u5220\u9664", logType=2, operateType=4)
    @ApiOperation(value="\u56fd\u9645\u5316-\u6279\u91cf\u5220\u9664", notes="\u56fd\u9645\u5316-\u6279\u91cf\u5220\u9664")
    @GetMapping(value={"/deleteBatch"})
    public Result<?> deleteBatch(@RequestParam(name="ids", required=true) String ids) {
        List<String> idList = Arrays.asList(ids.split(","));
        this.i18nService.removeByIds(idList);
        return Result.ok("\u6279\u91cf\u5220\u9664\u6210\u529f\uff01");
    }

    @AutoLog(value="\u56fd\u9645\u5316-\u901a\u8fc7id\u67e5\u8be2", logType=2, operateType=1)
    @ApiOperation(value="\u56fd\u9645\u5316-\u901a\u8fc7id\u67e5\u8be2", notes="\u56fd\u9645\u5316-\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    public Result<?> queryById(@RequestParam(name="id", required=true) String id) {
        I18n i18n = (I18n)this.i18nService.getById((Serializable)((Object)id));
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.i18nService.lambdaQuery().eq(I18n::getI18nKey, (Object)i18n.getI18nKey())).eq(I18n::getLanguage, (Object)"zh")).list();
        if (!CollectionUtils.isEmpty((Collection)list)) {
            i18n.setTranslateZhValue(((I18n)list.get(0)).getI18nValue());
        }
        i18n.setTranslateType(i18n.getI18nKey().split("_")[1]);
        return Result.ok(i18n);
    }

    @AutoLog(value="\u56fd\u9645\u5316-\u5bfc\u51faExcel", logType=2, operateType=6)
    @RequestMapping(value={"/exportXls"}, method={RequestMethod.GET})
    public ModelAndView exportXls(HttpServletRequest request, I18nVO i18n) {
        i18n.setFromIndex(0);
        i18n.setPageSize(Integer.MAX_VALUE);
        i18n.setElsAccount(TenantContext.getTenant());
        IPage<I18nVO> pageList = this.i18nService.finPagelistAll(i18n);
        LoginUser sysUser = (LoginUser)SecurityUtils.getSubject().getPrincipal();
        List exportList = null;
        String selections = request.getParameter("selections");
        if (!ConvertUtils.isNotEmpty(selections)) {
            exportList = pageList.getRecords();
        }
        String defineColumn = request.getParameter("defineColumnCode");
        ModelAndView mv = new ModelAndView((View)new ELSEntityExcelView());
        mv.addObject("fileName", (Object)"\u56fd\u9645\u5316");
        mv.addObject("entity", I18nVO.class);
        mv.addObject("params", (Object)new ExportParams("\u56fd\u9645\u5316\u62a5\u8868", "\u5bfc\u51fa\u4eba:" + sysUser.getRealname(), "\u56fd\u9645\u5316", defineColumn));
        mv.addObject("data", (Object)exportList);
        return mv;
    }

    @AutoLog(value="\u56fd\u9645\u5316-\u5bfc\u5165Excel", logType=2, operateType=5)
    @RequestMapping(value={"/importExcel"}, method={RequestMethod.POST})
    @CacheEvict(value={"i18nJson"}, allEntries=true)
    public Result<?> importExcel(HttpServletRequest request, HttpServletResponse response) {
        return super.importExcel(request, response, I18n.class);
    }

    private String checkExist(String dataId, String value) {
        return this.checkService.checkExist(dataId, "els_i18n", "concat(language,'-',i18n_key)", value);
    }
}

