/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.controller;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.constant.CommonConstant;
import com.els.common.exception.ELSBootException;
import com.els.common.system.util.JwtUtil;
import com.els.common.util.ConvertUtils;
import com.els.common.util.MD5Util;
import com.els.config.mybatis.TenantContext;
import com.els.modules.attachment.entity.PurchaseAttachment;
import com.els.modules.attachment.service.PurchaseAttachmentService;
import com.els.modules.system.entity.CompanyPermission;
import com.els.modules.system.entity.Permission;
import com.els.modules.system.entity.RolePermission;
import com.els.modules.system.model.PermissionTree;
import com.els.modules.system.model.TreeModel;
import com.els.modules.system.service.CompanyPermissionService;
import com.els.modules.system.service.PermissionService;
import com.els.modules.system.service.RolePermissionService;
import com.els.modules.system.util.I18nUtil;
import com.els.modules.system.util.PermissionDataUtil;
import com.els.modules.system.vo.PermissionVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.authz.annotation.RequiresRoles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/permission"})
@Api(tags={"\u83dc\u5355\u7ba1\u7406"})
public class PermissionController {
    private static final Logger log = LoggerFactory.getLogger(PermissionController.class);
    @Autowired
    private PermissionService permissionService;
    @Autowired
    private RolePermissionService rolePermissionService;
    @Autowired
    private PurchaseAttachmentService purchaseAttachmentService;
    @Autowired
    private CompanyPermissionService companyPermissionService;
    @Value(value="${els.path.upload}")
    private String uploadpath;
    @Value(value="${els.service.address}")
    private String serviceAddress;

    @RequestMapping(value={"/list"}, method={RequestMethod.GET})
    public Result<List<PermissionTree>> list() {
        long start = System.currentTimeMillis();
        Result<List<PermissionTree>> result = new Result<List<PermissionTree>>();
        try {
            LambdaQueryWrapper query = new LambdaQueryWrapper();
            query.eq(Permission::getDeleted, (Object)CommonConstant.DEL_FLAG_0);
            query.eq(Permission::getElsAccount, (Object)TenantContext.getTenant());
            query.orderByAsc(Permission::getSortNo);
            List list = this.permissionService.list((Wrapper)query);
            ArrayList<PermissionVO> resultList = new ArrayList<PermissionVO>();
            for (Permission permission : list) {
                PermissionVO vo = new PermissionVO();
                BeanUtils.copyProperties((Object)permission, (Object)vo);
                resultList.add(vo);
            }
            ArrayList<PermissionTree> treeList = new ArrayList<PermissionTree>();
            this.getTreeList(treeList, resultList, null);
            result.setResult(treeList);
            result.setSuccess(true);
            log.info("======\u83b7\u53d6\u5168\u90e8\u83dc\u5355\u6570\u636e=====\u8017\u65f6:" + (System.currentTimeMillis() - start) + "\u6beb\u79d2");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    @RequestMapping(value={"/getCompanyMenuList"}, method={RequestMethod.GET})
    public Result<List<PermissionTree>> getCompanyMenuList() {
        long start = System.currentTimeMillis();
        Result<List<PermissionTree>> result = new Result<List<PermissionTree>>();
        try {
            List<PermissionVO> list = this.permissionService.getCompanyMenuList(TenantContext.getTenant());
            ArrayList<PermissionTree> treeList = new ArrayList<PermissionTree>();
            this.getTreeList(treeList, list, null);
            result.setResult(treeList);
            result.setSuccess(true);
            log.info("======\u83b7\u53d6\u5168\u90e8\u83dc\u5355\u6570\u636e=====\u8017\u65f6:" + (System.currentTimeMillis() - start) + "\u6beb\u79d2");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    @RequestMapping(value={"/getSystemMenuList"}, method={RequestMethod.GET})
    public Result<List<PermissionTree>> getSystemMenuList() {
        long start = System.currentTimeMillis();
        Result<List<PermissionTree>> result = new Result<List<PermissionTree>>();
        try {
            LambdaQueryWrapper query = new LambdaQueryWrapper();
            query.eq(Permission::getMenuType, (Object)CommonConstant.MENU_TYPE_0);
            query.eq(Permission::getDeleted, (Object)CommonConstant.DEL_FLAG_0);
            query.orderByAsc(Permission::getSortNo);
            List list = this.permissionService.list((Wrapper)query);
            ArrayList<PermissionTree> sysPermissionTreeList = new ArrayList<PermissionTree>();
            for (Permission sysPermission : list) {
                PermissionVO permissionVO = new PermissionVO();
                BeanUtils.copyProperties((Object)sysPermission, (Object)permissionVO);
                PermissionTree sysPermissionTree = new PermissionTree(permissionVO);
                sysPermissionTreeList.add(sysPermissionTree);
            }
            result.setResult(sysPermissionTreeList);
            result.setSuccess(true);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        log.info("======\u83b7\u53d6\u4e00\u7ea7\u83dc\u5355\u6570\u636e=====\u8017\u65f6:" + (System.currentTimeMillis() - start) + "\u6beb\u79d2");
        return result;
    }

    @RequestMapping(value={"/getButtonPermission"}, method={RequestMethod.GET})
    public Result<List<PermissionTree>> getButtonPermission(@RequestParam(value="url") String url) {
        Result<List<PermissionTree>> result = new Result<List<PermissionTree>>();
        try {
            LambdaQueryWrapper query = new LambdaQueryWrapper();
            query.eq(Permission::getUrl, (Object)url);
            Permission permission = (Permission)this.permissionService.getOne((Wrapper)query);
            ArrayList<PermissionTree> sysPermissionTreeList = new ArrayList<PermissionTree>();
            if (permission != null) {
                String parentId = permission.getId();
                query = new LambdaQueryWrapper();
                query.eq(Permission::getParentId, (Object)parentId);
                query.eq(Permission::getDeleted, (Object)CommonConstant.DEL_FLAG_0);
                query.orderByAsc(Permission::getSortNo);
                List list = this.permissionService.list((Wrapper)query);
                for (Permission sysPermission : list) {
                    PermissionVO permissionVO = new PermissionVO();
                    BeanUtils.copyProperties((Object)sysPermission, (Object)permissionVO);
                    PermissionTree sysPermissionTree = new PermissionTree(permissionVO);
                    sysPermissionTreeList.add(sysPermissionTree);
                }
            }
            result.setResult(sysPermissionTreeList);
            result.setSuccess(true);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    @RequestMapping(value={"/getSystemSubmenu"}, method={RequestMethod.GET})
    public Result<List<PermissionTree>> getSystemSubmenu(@RequestParam(value="parentId") String parentId) {
        Result<List<PermissionTree>> result = new Result<List<PermissionTree>>();
        try {
            LambdaQueryWrapper query = new LambdaQueryWrapper();
            query.eq(Permission::getParentId, (Object)parentId);
            query.eq(Permission::getDeleted, (Object)CommonConstant.DEL_FLAG_0);
            query.orderByAsc(Permission::getSortNo);
            List list = this.permissionService.list((Wrapper)query);
            ArrayList<PermissionTree> sysPermissionTreeList = new ArrayList<PermissionTree>();
            for (Permission sysPermission : list) {
                PermissionVO permissionVO = new PermissionVO();
                BeanUtils.copyProperties((Object)sysPermission, (Object)permissionVO);
                PermissionTree sysPermissionTree = new PermissionTree(permissionVO);
                sysPermissionTreeList.add(sysPermissionTree);
            }
            result.setResult(sysPermissionTreeList);
            result.setSuccess(true);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    @RequestMapping(value={"/getUserPermissionByToken"}, method={RequestMethod.GET})
    public Result<?> getUserPermissionByToken(@RequestParam(name="token", required=true) String token) {
        Result<JSONObject> result = new Result<JSONObject>();
        try {
            if (ConvertUtils.isEmpty(token)) {
                return Result.error("TOKEN\u4e0d\u5141\u8bb8\u4e3a\u7a7a\uff01");
            }
            log.info(" ------ \u901a\u8fc7\u4ee4\u724c\u83b7\u53d6\u7528\u6237\u62e5\u6709\u7684\u8bbf\u95ee\u83dc\u5355 ---- TOKEN ------ " + token);
            String account = JwtUtil.getAccount(token);
            List<PermissionVO> metaList = this.permissionService.queryByAccount(account.split("_")[0], account.split("_")[1], 0);
            JSONObject json = new JSONObject();
            JSONArray menujsonArray = new JSONArray();
            this.getPermissionJsonArray(menujsonArray, metaList, null);
            JSONArray authjsonArray = new JSONArray();
            this.getAuthJsonArray(authjsonArray, metaList);
            LambdaQueryWrapper query = new LambdaQueryWrapper();
            query.eq(Permission::getDeleted, (Object)CommonConstant.DEL_FLAG_0);
            query.eq(Permission::getMenuType, (Object)CommonConstant.MENU_TYPE_2);
            List allAuthList = this.permissionService.list((Wrapper)query);
            JSONArray allauthjsonArray = new JSONArray();
            this.getAllAuthJsonArray(allauthjsonArray, allAuthList);
            json.put("menu", (Object)menujsonArray);
            json.put("auth", (Object)authjsonArray);
            json.put("allAuth", (Object)allauthjsonArray);
            result.setResult(json);
            result.success("\u67e5\u8be2\u6210\u529f");
        }
        catch (Exception e) {
            result.error500("\u67e5\u8be2\u5931\u8d25:" + e.getMessage());
            log.error(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    @RequestMapping(value={"/getUserMobilePermissionByToken"}, method={RequestMethod.GET})
    public Result<?> getUserMobilePermissionByToken(@RequestParam(name="token", required=true) String token) {
        Result<JSONObject> result = new Result<JSONObject>();
        try {
            if (ConvertUtils.isEmpty(token)) {
                return Result.error("TOKEN\u4e0d\u5141\u8bb8\u4e3a\u7a7a\uff01");
            }
            log.info(" ------ \u901a\u8fc7\u4ee4\u724c\u83b7\u53d6\u7528\u6237\u62e5\u6709\u7684\u8bbf\u95ee\u83dc\u5355 ---- TOKEN ------ " + token);
            String account = JwtUtil.getAccount(token);
            List<PermissionVO> metaList = this.permissionService.queryByAccount(account.split("_")[0], account.split("_")[1], 1);
            JSONObject json = new JSONObject();
            json.put("menu", metaList);
            result.setResult(json);
            result.success("\u67e5\u8be2\u6210\u529f");
        }
        catch (Exception e) {
            result.error500("\u67e5\u8be2\u5931\u8d25:" + e.getMessage());
            log.error(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    @AutoLog(value="\u83dc\u5355\u7ba1\u7406-\u6dfb\u52a0\u83dc\u5355", logType=2, operateType=2)
    @RequiresRoles(value={"admin"})
    @RequestMapping(value={"/add"}, method={RequestMethod.POST})
    public Result<Permission> add(@RequestBody Permission permission) {
        Result<Permission> result = new Result<Permission>();
        try {
            permission = PermissionDataUtil.intelligentProcessData(permission);
            this.permissionService.addPermission(permission);
            result.success("\u6dfb\u52a0\u6210\u529f\uff01");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            result.error500("\u64cd\u4f5c\u5931\u8d25");
        }
        return result;
    }

    @AutoLog(value="\u83dc\u5355\u7ba1\u7406-\u7f16\u8f91\u83dc\u5355", logType=2, operateType=3)
    @RequiresRoles(value={"admin"})
    @RequestMapping(value={"/edit"}, method={RequestMethod.POST})
    public Result<Permission> edit(@RequestBody Permission permission) {
        Result<Permission> result = new Result<Permission>();
        try {
            permission = PermissionDataUtil.intelligentProcessData(permission);
            this.permissionService.editPermission(permission);
            result.success("\u4fee\u6539\u6210\u529f\uff01");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            result.error500("\u64cd\u4f5c\u5931\u8d25");
        }
        return result;
    }

    @AutoLog(value="\u83dc\u5355\u7ba1\u7406-\u7f16\u8f91\u83dc\u5355", logType=2, operateType=3)
    @RequestMapping(value={"/companyEdit"}, method={RequestMethod.POST})
    public Result<Permission> companyEdit(@RequestBody PermissionVO permission) {
        Result<Permission> result = new Result<Permission>();
        try {
            permission.setId(permission.getCompanyMeunId());
            this.permissionService.editCompanyPermission(permission);
            result.success("\u4fee\u6539\u6210\u529f\uff01");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            result.error500("\u64cd\u4f5c\u5931\u8d25");
        }
        return result;
    }

    @AutoLog(value="\u83dc\u5355\u7ba1\u7406-\u5220\u9664\u83dc\u5355", logType=2, operateType=4)
    @RequiresRoles(value={"admin"})
    @RequestMapping(value={"/delete"}, method={RequestMethod.GET})
    public Result<Permission> delete(@RequestParam(name="id", required=true) String id) {
        Result<Permission> result = new Result<Permission>();
        try {
            this.permissionService.deletePermission(id);
            result.success("\u5220\u9664\u6210\u529f!");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            result.error500(e.getMessage());
        }
        return result;
    }

    @AutoLog(value="\u83dc\u5355\u7ba1\u7406-\u6279\u91cf\u5220\u9664\u83dc\u5355", logType=2, operateType=4)
    @RequiresRoles(value={"admin"})
    @RequestMapping(value={"/deleteBatch"}, method={RequestMethod.GET})
    public Result<Permission> deleteBatch(@RequestParam(name="ids", required=true) String ids) {
        Result<Permission> result = new Result<Permission>();
        try {
            String[] arr;
            for (String id : arr = ids.split(",")) {
                if (!ConvertUtils.isNotEmpty(id)) continue;
                this.permissionService.deletePermission(id);
            }
            result.success("\u5220\u9664\u6210\u529f!");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            result.error500("\u5220\u9664\u6210\u529f!");
        }
        return result;
    }

    @RequestMapping(value={"/queryTreeList"}, method={RequestMethod.GET})
    public Result<Map<String, Object>> queryTreeList() {
        Result<Map<String, Object>> result = new Result<Map<String, Object>>();
        ArrayList<String> ids = new ArrayList<String>();
        try {
            LambdaQueryWrapper query = new LambdaQueryWrapper();
            query.eq(Permission::getDeleted, (Object)CommonConstant.DEL_FLAG_0);
            query.orderByAsc(Permission::getSortNo);
            List list = this.permissionService.list((Wrapper)query);
            for (Permission sysPer : list) {
                ids.add(sysPer.getId());
            }
            ArrayList<TreeModel> treeList = new ArrayList<TreeModel>();
            this.getTreeModelList(treeList, list, null);
            HashMap<String, ArrayList<Object>> resMap = new HashMap<String, ArrayList<Object>>();
            resMap.put("treeList", treeList);
            resMap.put("ids", ids);
            result.setResult(resMap);
            result.setSuccess(true);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    @RequestMapping(value={"/queryListAsync"}, method={RequestMethod.GET})
    public Result<List<TreeModel>> queryAsync(@RequestParam(name="pid", required=false) String parentId) {
        Result<List<TreeModel>> result = new Result<List<TreeModel>>();
        try {
            List<TreeModel> list = this.permissionService.queryListByParentId(parentId);
            if (list == null || list.size() <= 0) {
                result.error500("\u672a\u627e\u5230\u89d2\u8272\u4fe1\u606f");
            } else {
                result.setResult(list);
                result.setSuccess(true);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    @RequestMapping(value={"/queryRolePermission"}, method={RequestMethod.GET})
    public Result<List<String>> queryRolePermission(@RequestParam(name="roleId", required=true) String roleId) {
        Result<List<String>> result = new Result<List<String>>();
        try {
            List list = this.rolePermissionService.list((Wrapper)new QueryWrapper().lambda().eq(RolePermission::getRoleId, (Object)roleId));
            result.setResult(list.stream().map(SysRolePermission -> String.valueOf(SysRolePermission.getPermissionId())).collect(Collectors.toList()));
            result.setSuccess(true);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    @RequestMapping(value={"/queryCompanyPermission"}, method={RequestMethod.GET})
    public Result<List<String>> queryCompanyPermission(@RequestParam(name="elsAccount", required=true) String elsAccount) {
        Result<List<String>> result = new Result<List<String>>();
        try {
            List<PermissionVO> permissionList = this.permissionService.getCompanyMenuList(elsAccount);
            result.setResult(permissionList.stream().map(vo -> String.valueOf(vo.getId())).collect(Collectors.toList()));
            result.setSuccess(true);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    @AutoLog(value="\u83dc\u5355\u7ba1\u7406-\u4fdd\u5b58\u89d2\u8272\u6388\u6743", logType=2, operateType=3)
    @RequestMapping(value={"/saveRolePermission"}, method={RequestMethod.POST})
    public Result<String> saveRolePermission(@RequestBody JSONObject json) {
        long start = System.currentTimeMillis();
        Result<String> result = new Result<String>();
        try {
            String roleId = json.getString("roleId");
            String permissionIds = json.getString("permissionIds");
            String lastPermissionIds = json.getString("lastpermissionIds");
            this.rolePermissionService.saveRolePermission(roleId, permissionIds, lastPermissionIds);
            result.success("\u4fdd\u5b58\u6210\u529f\uff01");
            log.info("======\u89d2\u8272\u6388\u6743\u6210\u529f=====\u8017\u65f6:" + (System.currentTimeMillis() - start) + "\u6beb\u79d2");
        }
        catch (Exception e) {
            result.error500("\u6388\u6743\u5931\u8d25\uff01");
            log.error(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    @AutoLog(value="\u83dc\u5355\u7ba1\u7406-\u4fdd\u5b58\u4f01\u4e1a\u6388\u6743", logType=2, operateType=3)
    @RequestMapping(value={"/saveCompanyPermission"}, method={RequestMethod.POST})
    public Result<String> saveCompanyPermission(@RequestBody JSONObject json) {
        long start = System.currentTimeMillis();
        Result<String> result = new Result<String>();
        try {
            String elsAccount = json.getString("elsAccount");
            String permissionIds = json.getString("permissionIds");
            String lastPermissionIds = json.getString("lastpermissionIds");
            this.permissionService.saveCompanyPermission(elsAccount, permissionIds, lastPermissionIds);
            result.success("\u4fdd\u5b58\u6210\u529f\uff01");
            log.info("======\u4f01\u4e1a\u6388\u6743\u6210\u529f=====\u8017\u65f6:" + (System.currentTimeMillis() - start) + "\u6beb\u79d2");
        }
        catch (Exception e) {
            result.error500("\u6388\u6743\u5931\u8d25\uff01");
            log.error(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2\u7cfb\u7edf\u5e2e\u52a9\u8bf4\u660e", notes="\u901a\u8fc7id\u67e5\u8be2\u7cfb\u7edf\u5e2e\u52a9\u8bf4\u660e")
    @GetMapping(value={"/querySysById"})
    public Result<?> querySysById(@RequestParam(name="id", required=true) String id) {
        PermissionVO permissionVO = new PermissionVO();
        Permission permission = (Permission)this.permissionService.getById((Serializable)((Object)id));
        BeanUtils.copyProperties((Object)permission, (Object)permissionVO);
        List<PurchaseAttachment> attachmentList = this.purchaseAttachmentService.selectByMainId(id);
        permissionVO.setPurchaseAttachmentList(attachmentList);
        return Result.ok(permissionVO);
    }

    @AutoLog(value="\u83dc\u5355\u7ba1\u7406-\u4fdd\u5b58\u7cfb\u7edf\u7ea7\u5e2e\u52a9\u8bf4\u660e")
    @ApiOperation(value="\u4fdd\u5b58\u7cfb\u7edf\u7ea7\u5e2e\u52a9\u8bf4\u660e", notes="\u4fdd\u5b58\u7cfb\u7edf\u7ea7\u5e2e\u52a9\u8bf4\u660e")
    @RequiresRoles(value={"admin"})
    @RequestMapping(value={"/editSysHelpDesc"}, method={RequestMethod.POST})
    public Result<Permission> editSysHelpDesc(@RequestBody Permission permission) {
        Result<Permission> result = new Result<Permission>();
        try {
            Permission update = (Permission)this.permissionService.getById((Serializable)((Object)permission.getId()));
            update.setHelpDesc(permission.getHelpDesc());
            this.permissionService.updateById(update);
            result.success("\u4fee\u6539\u6210\u529f\uff01");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            result.error500("\u64cd\u4f5c\u5931\u8d25");
        }
        return result;
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2\u4f01\u4e1a\u5e2e\u52a9\u8bf4\u660e", notes="\u901a\u8fc7id\u67e5\u8be2\u4f01\u4e1a\u5e2e\u52a9\u8bf4\u660e")
    @GetMapping(value={"/queryCompanyById"})
    public Result<?> queryCompanyById(@RequestParam(name="companyMeunId", required=true) String companyMeunId) {
        PermissionVO permissionVO = new PermissionVO();
        CompanyPermission permission = (CompanyPermission)this.companyPermissionService.getById((Serializable)((Object)companyMeunId));
        BeanUtils.copyProperties((Object)permission, (Object)permissionVO);
        List<PurchaseAttachment> attachmentList = this.purchaseAttachmentService.selectByMainId(companyMeunId);
        permissionVO.setPurchaseAttachmentList(attachmentList);
        return Result.ok(permissionVO);
    }

    @AutoLog(value="\u83dc\u5355\u7ba1\u7406-\u4fdd\u5b58\u4f01\u4e1a\u7ea7\u5e2e\u52a9\u8bf4\u660e")
    @ApiOperation(value="\u4fdd\u5b58\u4f01\u4e1a\u7ea7\u5e2e\u52a9\u8bf4\u660e", notes="\u4fdd\u5b58\u4f01\u4e1a\u7ea7\u5e2e\u52a9\u8bf4\u660e")
    @RequestMapping(value={"/editCompanyHelpDesc"}, method={RequestMethod.POST})
    public Result<Permission> editCompanyHelpDesc(@RequestBody PermissionVO permission) {
        Result<Permission> result = new Result<Permission>();
        try {
            CompanyPermission update = new CompanyPermission();
            update.setId(permission.getCompanyMeunId());
            update.setHelpDesc(permission.getHelpDesc());
            this.companyPermissionService.updateById(update);
            result.success("\u4fee\u6539\u6210\u529f\uff01");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            result.error500("\u64cd\u4f5c\u5931\u8d25");
        }
        return result;
    }

    @ApiOperation(value="\u83dc\u5355\u7ba1\u7406-\u901a\u8fc7URL\u67e5\u8be2\u5e2e\u52a9\u8bf4\u660e", notes="\u83dc\u5355\u7ba1\u7406-\u901a\u8fc7URL\u67e5\u8be2\u5e2e\u52a9\u8bf4\u660e")
    @GetMapping(value={"/queryByUrl"})
    public Result<?> queryByUrl(@RequestParam(name="url", required=true) String url) {
        List permissionList = this.permissionService.list((Wrapper)new QueryWrapper().likeLeft((Object)"url", (Object)url));
        if (permissionList.isEmpty()) {
            throw new ELSBootException("url" + I18nUtil.translate("i18n_alert_WWWWIdjntxMKW_32c84775", "\u5bf9\u5e94\u7684\u83dc\u5355\u4e0d\u5b58\u5728\uff01"));
        }
        Permission permission = (Permission)permissionList.get(0);
        CompanyPermission companyPermission = (CompanyPermission)this.companyPermissionService.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"els_account", (Object)TenantContext.getTenant())).eq((Object)"permission_id", (Object)permission.getId()));
        JSONObject object = new JSONObject();
        String headId = null;
        if (companyPermission != null && StrUtil.isNotBlank((CharSequence)companyPermission.getHelpDesc())) {
            object.put("helpDesc", (Object)companyPermission.getHelpDesc());
            headId = companyPermission.getId();
        } else {
            object.put("helpDesc", (Object)permission.getHelpDesc());
            headId = permission.getId();
        }
        List<PurchaseAttachment> attachmentList = this.purchaseAttachmentService.selectByMainId(headId);
        if (!attachmentList.isEmpty()) {
            String path = attachmentList.get(0).getFilePath();
            String nginxFilePath = this.serviceAddress + "/opt/upFiles" + path;
            object.put("filePath", (Object)nginxFilePath);
        }
        return Result.ok(object);
    }

    private void getTreeList(List<PermissionTree> treeList, List<PermissionVO> metaList, PermissionTree temp) {
        for (PermissionVO permission : metaList) {
            String tempPid = permission.getParentId();
            PermissionTree tree = new PermissionTree(permission);
            if (temp == null && ConvertUtils.isEmpty(tempPid)) {
                treeList.add(tree);
                if (tree.getIsLeaf()) continue;
                this.getTreeList(treeList, metaList, tree);
                continue;
            }
            if (temp == null || tempPid == null || !tempPid.equals(temp.getId())) continue;
            temp.getChildren().add(tree);
            if (tree.getIsLeaf()) continue;
            this.getTreeList(treeList, metaList, tree);
        }
    }

    private void getTreeModelList(List<TreeModel> treeList, List<Permission> metaList, TreeModel temp) {
        for (Permission permission : metaList) {
            String tempPid = permission.getParentId();
            TreeModel tree = new TreeModel(permission);
            if (temp == null && ConvertUtils.isEmpty(tempPid)) {
                treeList.add(tree);
                if (tree.getIsLeaf()) continue;
                this.getTreeModelList(treeList, metaList, tree);
                continue;
            }
            if (temp == null || tempPid == null || !tempPid.equals(temp.getKey())) continue;
            temp.getChildren().add(tree);
            if (tree.getIsLeaf()) continue;
            this.getTreeModelList(treeList, metaList, tree);
        }
    }

    private void getAllAuthJsonArray(JSONArray jsonArray, List<Permission> allList) {
        JSONObject json = null;
        for (Permission permission : allList) {
            json = new JSONObject();
            json.put("action", (Object)permission.getPerms());
            json.put("status", (Object)permission.getStatus());
            json.put("type", (Object)permission.getPermsType());
            json.put("describe", (Object)permission.getName());
            jsonArray.add((Object)json);
        }
    }

    private void getAuthJsonArray(JSONArray jsonArray, List<PermissionVO> metaList) {
        for (Permission permission : metaList) {
            if (permission.getMenuType() == null) continue;
            JSONObject json = null;
            if (!permission.getMenuType().equals(CommonConstant.MENU_TYPE_2) || !"1".equals(permission.getStatus())) continue;
            json = new JSONObject();
            json.put("action", (Object)permission.getPerms());
            json.put("type", (Object)permission.getPermsType());
            json.put("describe", (Object)permission.getName());
            jsonArray.add((Object)json);
        }
    }

    private void getPermissionJsonArray(JSONArray jsonArray, List<PermissionVO> metaList, JSONObject parentJson) {
        long startTime = System.currentTimeMillis();
        for (Permission permission : metaList) {
            if (permission.getMenuType() == null) continue;
            String tempPid = permission.getParentId();
            permission.setName(I18nUtil.translateCache(permission.getNameI18nKey(), permission.getName()));
            JSONObject json = this.getPermissionJsonObject(permission);
            if (json == null) continue;
            if (parentJson == null && ConvertUtils.isEmpty(tempPid)) {
                jsonArray.add((Object)json);
                if (permission.isLeaf()) continue;
                this.getPermissionJsonArray(jsonArray, metaList, json);
                continue;
            }
            if (parentJson == null || !ConvertUtils.isNotEmpty(tempPid) || !tempPid.equals(parentJson.getString("id"))) continue;
            if (permission.getMenuType().equals(CommonConstant.MENU_TYPE_2)) {
                JSONObject metaJson = parentJson.getJSONObject("meta");
                if (metaJson.containsKey((Object)"permissionList")) {
                    metaJson.getJSONArray("permissionList").add((Object)json);
                    continue;
                }
                JSONArray permissionList = new JSONArray();
                permissionList.add((Object)json);
                metaJson.put("permissionList", (Object)permissionList);
                continue;
            }
            if (!permission.getMenuType().equals(CommonConstant.MENU_TYPE_1) && !permission.getMenuType().equals(CommonConstant.MENU_TYPE_0)) continue;
            if (parentJson.containsKey((Object)"children")) {
                parentJson.getJSONArray("children").add((Object)json);
            } else {
                JSONArray children = new JSONArray();
                children.add((Object)json);
                parentJson.put("children", (Object)children);
            }
            if (permission.isLeaf()) continue;
            this.getPermissionJsonArray(jsonArray, metaList, json);
        }
        log.debug("\u83b7\u53d6\u83dc\u5355\u6570\u636e\u5171\u8017\u65f6{}\u6beb\u79d2", (Object)(System.currentTimeMillis() - startTime));
    }

    private JSONObject getPermissionJsonObject(Permission permission) {
        JSONObject json = new JSONObject();
        if (permission.getMenuType().equals(CommonConstant.MENU_TYPE_2)) {
            return null;
        }
        if (permission.getMenuType().equals(CommonConstant.MENU_TYPE_0) || permission.getMenuType().equals(CommonConstant.MENU_TYPE_1)) {
            json.put("id", (Object)permission.getId());
            if (permission.isRoute()) {
                json.put("route", (Object)"1");
            } else {
                json.put("route", (Object)"0");
            }
            if (this.isWWWHttpUrl(permission.getUrl())) {
                json.put("path", (Object)MD5Util.md5Encode(permission.getUrl(), "utf-8"));
            } else {
                json.put("path", (Object)permission.getUrl());
            }
            if (ConvertUtils.isNotEmpty(permission.getComponentName())) {
                json.put("name", (Object)permission.getComponentName());
            } else {
                json.put("name", (Object)this.urlToRouteName(permission.getUrl()));
            }
            if (permission.isHidden()) {
                json.put("hidden", (Object)true);
            }
            if (permission.isAlwaysShow()) {
                json.put("alwaysShow", (Object)true);
            }
            json.put("component", (Object)permission.getComponent());
            JSONObject meta = new JSONObject();
            if (permission.isKeepAlive()) {
                meta.put("keepAlive", (Object)true);
            } else {
                meta.put("keepAlive", (Object)false);
            }
            if (permission.isInternalOrExternal()) {
                meta.put("internalOrExternal", (Object)true);
            } else {
                meta.put("internalOrExternal", (Object)false);
            }
            meta.put("title", (Object)permission.getName());
            if (ConvertUtils.isEmpty(permission.getParentId())) {
                json.put("redirect", (Object)permission.getRedirect());
                if (ConvertUtils.isNotEmpty(permission.getIcon())) {
                    meta.put("icon", (Object)permission.getIcon());
                }
                if (ConvertUtils.isNotEmpty(permission.getIconColor())) {
                    meta.put("iconColor", (Object)permission.getIconColor());
                }
            } else {
                if (ConvertUtils.isNotEmpty(permission.getIcon())) {
                    meta.put("icon", (Object)permission.getIcon());
                }
                if (ConvertUtils.isNotEmpty(permission.getIconColor())) {
                    meta.put("iconColor", (Object)permission.getIconColor());
                }
            }
            if (this.isWWWHttpUrl(permission.getUrl())) {
                meta.put("url", (Object)permission.getUrl());
            }
            if (StringUtils.isNotBlank((CharSequence)permission.getHelpDocUrl())) {
                meta.put("helpDocUrl", (Object)permission.getHelpDocUrl());
            }
            json.put("meta", (Object)meta);
        }
        return json;
    }

    private boolean isWWWHttpUrl(String url) {
        return url != null && (url.startsWith("http://") || url.startsWith("https://") || url.startsWith("{{"));
    }

    private String urlToRouteName(String url) {
        if (ConvertUtils.isNotEmpty(url)) {
            if (url.startsWith("/")) {
                url = url.substring(1);
            }
            url = url.replace("/", "-");
            url = url.replace(":", "@");
            return url;
        }
        return null;
    }
}

