/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.enums;

import com.els.modules.system.enums.i18n.I18nElsPwSecurityEnum;
import com.els.modules.system.util.I18nUtil;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum PwComplexityVerifyEnum {
    INCLUDE_NUM("includeNum", ".*\\d+.*", I18nUtil.translate(I18nElsPwSecurityEnum.I18N_INCLUDE_NUM)),
    INCLUDE_LOWER_CASE("includeLowerCase", ".*[a-z]+.*", I18nUtil.translate(I18nElsPwSecurityEnum.I18N_INCLUDE_LOWER_CASE)),
    INCLUDE_UPPER_CASE("includeUpperCase", ".*[A-Z]+.*", I18nUtil.translate(I18nElsPwSecurityEnum.I18N_INCLUDE_UPPER_CASE)),
    INCLUDE_SYMBOL("includeSymbol", ".*[~!@#$%^&*()_+|<>,.?/:;'\\[\\]{}\"]+.*", I18nUtil.translate(I18nElsPwSecurityEnum.I18N_INCLUDE_SYMBOL));

    private final String complexityName;
    private final String regularExpression;
    private final String description;
    private static final Map<String, PwComplexityVerifyEnum> enumMap;

    public String complexityName() {
        return this.complexityName;
    }

    public String rgularExpression() {
        return this.regularExpression;
    }

    public String description() {
        return this.description;
    }

    private PwComplexityVerifyEnum(String complexityName, String regularExpression, String description) {
        this.complexityName = complexityName;
        this.regularExpression = regularExpression;
        this.description = description;
    }

    public boolean verify(String pwString) {
        return Pattern.matches(this.regularExpression, pwString);
    }

    public static Map<String, PwComplexityVerifyEnum> getEnumMap() {
        return enumMap;
    }

    static {
        enumMap = Stream.of(PwComplexityVerifyEnum.values()).collect(Collectors.toMap(PwComplexityVerifyEnum::complexityName, e -> e));
    }
}

