/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.util;

import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.event.AnalysisEventListener;
import com.els.common.constant.CommonConstant;
import com.els.common.exception.ELSBootException;
import com.els.common.util.RedisUtil;
import com.els.common.util.SpringContextUtils;
import com.els.config.mybatis.TenantContext;
import com.els.modules.system.entity.ExcelDetail;
import com.els.modules.system.enums.ExcelDataTypeEnum;
import com.els.modules.system.service.AbstractExcelHandler;
import com.els.modules.system.service.DictService;
import com.els.modules.system.service.impl.DictServiceImpl;
import com.els.modules.system.util.I18nUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class ExcelDataListener
extends AnalysisEventListener<Map<Integer, String>> {
    private List<Map<String, Object>> importDataList = new ArrayList<Map<String, Object>>(16);
    private Map<String, Object> primaryMap = new HashMap<String, Object>(16);
    private List<ExcelDetail> excelDetailList;
    private AbstractExcelHandler handler;
    private DictService dictService;
    private String dataKey;

    public ExcelDataListener(AbstractExcelHandler handler, List<ExcelDetail> excelDetailList, String dataKey) {
        this.handler = handler;
        this.excelDetailList = excelDetailList;
        this.dataKey = dataKey;
        this.dictService = SpringContextUtils.getBean(DictServiceImpl.class);
    }

    public List<Map<String, Object>> getImportDataList() {
        return this.importDataList;
    }

    public void invoke(Map<Integer, String> data, AnalysisContext context) {
        HashMap<String, String> dataMap = new HashMap<String, String>(16);
        StringBuilder primaryKey = new StringBuilder();
        for (ExcelDetail detail : this.excelDetailList) {
            Integer index = detail.getColumnIndex() - 1;
            if (data.containsKey(index) && StringUtils.isNotBlank((CharSequence)data.get(index))) {
                String val = data.get(index);
                if (ExcelDataTypeEnum.DICT.getCode().equals(detail.getDataType()) && StringUtils.isBlank((CharSequence)(val = this.dictService.queryDictValueByText(detail.getDataFormat(), val)))) {
                    throw new ELSBootException(I18nUtil.translate("i18n_alert_WWWWWWWWWxMKUWFJCAoWWWWWWvLC_ef117fda", "${0} ${1}\u4e0d\u5b58\u5728\u4e8e\u6570\u636e\u5b57\u5178\u7f16\u7801[${2}]\u8303\u56f4\u5185", detail.getColumnName(), data.get(index), detail.getDataFormat()));
                }
                if (ExcelDataTypeEnum.NUMBER.getCode().equals(detail.getDataType())) {
                    try {
                        Double dVal = Double.valueOf(val);
                        BigDecimal bVal = BigDecimal.valueOf(dVal).setScale(4, 4);
                        dataMap.put(detail.getColumnCode(), bVal.stripTrailingZeros().toPlainString());
                    }
                    catch (NumberFormatException e) {
                        dataMap.put(detail.getColumnCode(), val);
                    }
                } else {
                    dataMap.put(detail.getColumnCode(), val);
                }
                if (!CommonConstant.STATUS_YES.equals(detail.getPrimaryKey())) continue;
                primaryKey.append(data.get(index)).append(",");
                continue;
            }
            if (!CommonConstant.STATUS_YES.equals(detail.getRequired())) continue;
            throw new ELSBootException(detail.getColumnName() + I18nUtil.translate("i18n_alert_WWWWWKlSJOWxOLV_7874eb85", "\u662f\u5fc5\u586b\u5b57\u6bb5\uff0c\u4e0d\u80fd\u4e3a\u7a7a"));
        }
        if (StringUtils.isNotBlank((CharSequence)primaryKey.toString())) {
            if (this.primaryMap.containsKey(primaryKey.toString())) {
                throw new ELSBootException(primaryKey + I18nUtil.translate("i18n_alert_WWWWWLIIVB_f28ec481", "\u552f\u4e00\u952e\u91cd\u590d"));
            }
            this.primaryMap.put(primaryKey.toString(), CommonConstant.STATUS_YES);
        }
        dataMap.put("els_account", TenantContext.getTenant());
        this.importDataList.add(dataMap);
    }

    public void doAfterAllAnalysed(AnalysisContext context) {
        if (StringUtils.isBlank((CharSequence)this.dataKey)) {
            this.handler.importExcel(this.importDataList);
        } else {
            RedisUtil redisUtil = SpringContextUtils.getBean(RedisUtil.class);
            redisUtil.set(this.dataKey, this.importDataList);
        }
    }
}

