/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.template.controller;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.query.QueryGenerator;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.ListColumnQueryBuilder;
import com.els.common.util.RedisUtil;
import com.els.config.mybatis.TenantContext;
import com.els.framework.poi.excel.ExcelImportUtil;
import com.els.framework.poi.excel.entity.ExportParams;
import com.els.framework.poi.excel.entity.ImportParams;
import com.els.framework.poi.excel.view.ELSEntityExcelView;
import com.els.modules.system.util.I18nUtil;
import com.els.modules.template.entity.TemplateConfigHead;
import com.els.modules.template.entity.TemplateConfigItem;
import com.els.modules.template.entity.TemplateGroup;
import com.els.modules.template.entity.TemplateHead;
import com.els.modules.template.enumerate.TemplateStatusEnum;
import com.els.modules.template.service.TemplateConfigHeadService;
import com.els.modules.template.service.TemplateConfigItemService;
import com.els.modules.template.service.TemplateGroupService;
import com.els.modules.template.service.TemplateHeadService;
import com.els.modules.template.util.ConfigPageGeneJsUtil;
import com.els.modules.template.vo.TemplateHeadVO;
import com.google.common.collect.Lists;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.SecurityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;

@RestController
@RequestMapping(value={"/template/templateHead"})
@Api(tags={"\u4e1a\u52a1\u6a21\u677f\u914d\u7f6e"})
public class TemplateHeadController
extends BaseController<TemplateHead, TemplateHeadService> {
    private static final Logger log = LoggerFactory.getLogger(TemplateHeadController.class);
    @Autowired
    private TemplateHeadService templateHeadService;
    @Autowired
    private TemplateGroupService templateGroupService;
    @Autowired
    private TemplateConfigHeadService templateConfigHeadService;
    @Autowired
    private TemplateConfigItemService templateConfigItemService;
    @Autowired
    private RedisUtil redisUtil;
    @Value(value="${els.path.upload}")
    private String uploadpath;
    private Pattern pattern = Pattern.compile("\\$\\{([^}]+)}");

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    public Result<?> queryPageList(TemplateHead templateHead, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper<TemplateHead> queryWrapper = QueryGenerator.initQueryWrapper(templateHead, req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        if (StringUtils.isNotBlank((CharSequence)templateHead.getElsAccount())) {
            queryWrapper.eq((Object)"els_account", (Object)templateHead.getElsAccount());
        } else {
            queryWrapper.eq((Object)"els_account", (Object)TenantContext.getTenant());
        }
        IPage pageList = this.templateHeadService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok(pageList);
    }

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/noToken/listByBusiness"})
    public Result<?> queryPageList(@RequestParam(name="businessType") String businessType, @RequestParam(name="elsAccount", required=false) String elsAccount, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize) {
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        QueryWrapper queryWrapper = new QueryWrapper();
        if (StringUtils.isNotBlank((CharSequence)elsAccount)) {
            queryWrapper.eq((Object)"els_account", (Object)elsAccount);
        } else {
            queryWrapper.eq((Object)"els_account", (Object)TenantContext.getTenant());
        }
        queryWrapper.eq((Object)"business_type", (Object)businessType);
        queryWrapper.eq((Object)"template_status", (Object)TemplateStatusEnum.GENERATED.getValue());
        queryWrapper.orderByDesc((Object)"update_time");
        IPage pageList = this.templateHeadService.page((IPage)page, (Wrapper)queryWrapper);
        if (pageList.getRecords().isEmpty()) {
            queryWrapper.clear();
            queryWrapper.eq((Object)"els_account", (Object)"100000");
            queryWrapper.eq((Object)"business_type", (Object)businessType);
            queryWrapper.eq((Object)"template_status", (Object)TemplateStatusEnum.GENERATED.getValue());
            queryWrapper.orderByDesc((Object)"update_time");
            pageList = this.templateHeadService.page((IPage)page, (Wrapper)queryWrapper);
        }
        return Result.ok(pageList);
    }

    @ApiOperation(value="\u6839\u636e\u4e1a\u52a1\u7c7b\u578b\u83b7\u53d6\u6a21\u677f\u5217\u8868", notes="\u6839\u636e\u4e1a\u52a1\u7c7b\u578b\u83b7\u53d6\u6a21\u677f\u5217\u8868")
    @GetMapping(value={"/getListByType"})
    public Result<?> queryList(@RequestParam(name="businessType") String businessType, @RequestParam(name="elsAccount") String elsAccount) {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (StringUtils.isNotBlank((CharSequence)elsAccount)) {
            queryWrapper.eq((Object)"els_account", (Object)elsAccount);
        } else {
            queryWrapper.eq((Object)"els_account", (Object)TenantContext.getTenant());
        }
        queryWrapper.eq((Object)"business_type", (Object)businessType);
        queryWrapper.eq((Object)"template_status", (Object)TemplateStatusEnum.GENERATED.getValue());
        queryWrapper.orderByDesc((Object)"update_time");
        List list = this.templateHeadService.list((Wrapper)queryWrapper);
        if (list.isEmpty()) {
            queryWrapper.clear();
            queryWrapper.eq((Object)"els_account", (Object)"100000");
            queryWrapper.eq((Object)"business_type", (Object)businessType);
            queryWrapper.eq((Object)"template_status", (Object)TemplateStatusEnum.GENERATED.getValue());
            queryWrapper.orderByDesc((Object)"update_time");
            list = this.templateHeadService.list((Wrapper)queryWrapper);
        }
        return Result.ok(list);
    }

    @ApiOperation(value="100000\u6570\u636e\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="100000\u6570\u636e\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/sysList"})
    public Result<?> querySysPageList(TemplateHead templateHead, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper<TemplateHead> queryWrapper = QueryGenerator.initQueryWrapper(templateHead, req.getParameterMap());
        queryWrapper.eq((Object)"els_account", (Object)"100000");
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.templateHeadService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok(pageList);
    }

    @ApiOperation(value="\u6dfb\u52a0", notes="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    public Result<?> add(@RequestBody TemplateHeadVO templateHeadPage) {
        TemplateHead templateHead = new TemplateHead();
        BeanUtils.copyProperties((Object)templateHeadPage, (Object)templateHead);
        this.templateHeadService.saveMain(templateHead, templateHeadPage.getTemplateGroupList(), templateHeadPage.getTemplateConfigHeadList(), templateHeadPage.getTemplateConfigItemList());
        return Result.ok(templateHead);
    }

    @ApiOperation(value="\u9009\u62e9100000\u6570\u636e\u6dfb\u52a0\u6a21\u677f", notes="\u9009\u62e9100000\u6570\u636e\u6dfb\u52a0\u6a21\u677f")
    @GetMapping(value={"/addBy100000"})
    public Result<?> addBy100000(@RequestParam(name="id") String id) {
        this.templateHeadService.copyById(id);
        return this.commonSuccessResult(3);
    }

    @ApiOperation(value="\u590d\u5236\u6a21\u677f", notes="\u590d\u5236\u6a21\u677f")
    @GetMapping(value={"/copyById"})
    public Result<?> copyById(@RequestParam(name="id") String id) {
        this.templateHeadService.copyById(id);
        return this.commonSuccessResult(3);
    }

    @ApiOperation(value="\u4f5c\u5e9f", notes="\u4f5c\u5e9f")
    @GetMapping(value={"/cancel"})
    public Result<?> cancel(@RequestParam(name="id") String id) {
        TemplateHead templateHead = new TemplateHead();
        templateHead.setId(id);
        templateHead.setTemplateStatus(TemplateStatusEnum.CANCEL.getValue());
        this.templateHeadService.updateById(templateHead);
        return this.commonSuccessResult(3);
    }

    @ApiOperation(value="\u6279\u91cf\u751f\u6210\u914d\u7f6e", notes="\u6279\u91cf\u751f\u6210\u914d\u7f6e")
    @PostMapping(value={"/batchGenerateConfig"})
    @Transactional(rollbackFor={RuntimeException.class})
    public Result<?> batchGenerateConfig(@RequestBody List<String> templateIds) {
        Assert.isTrue((!CollectionUtil.isEmpty(templateIds) ? 1 : 0) != 0, (String)I18nUtil.translate("i18n_alert_VRRiFImCrHcERbLW_3e9c0018", "\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u4e2a\u6a21\u7248\u8fdb\u884c\u914d\u7f6e\u751f\u6210\uff01"));
        List templateHeadList = this.templateHeadService.listByIds(templateIds);
        Map templateGroupMap = ListColumnQueryBuilder.batchQueryByColumnListToMap(templateIds, Function.identity(), TemplateGroup::getHeadId, wrapper -> this.templateGroupService.list((Wrapper)wrapper), null, Lists.newArrayList((Object[])new ListColumnQueryBuilder.SortColumn[]{ListColumnQueryBuilder.SortColumn.builder(TemplateGroup::getSortOrder, false)}));
        Map templateConfigHeadMap = ListColumnQueryBuilder.batchQueryByColumnListToMap(templateIds, Function.identity(), TemplateConfigHead::getHeadId, wrapper -> this.templateConfigHeadService.list((Wrapper)wrapper), null, Lists.newArrayList((Object[])new ListColumnQueryBuilder.SortColumn[]{ListColumnQueryBuilder.SortColumn.builder(TemplateConfigHead::getSortOrder, false)}));
        Map templateConfigItemMap = ListColumnQueryBuilder.batchQueryByColumnListToMap(templateIds, Function.identity(), TemplateConfigItem::getHeadId, wrapper -> this.templateConfigItemService.list((Wrapper)wrapper), null, Lists.newArrayList((Object[])new ListColumnQueryBuilder.SortColumn[]{ListColumnQueryBuilder.SortColumn.builder(TemplateConfigItem::getSortOrder, false)}));
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"business_type", (Object)"enterprise");
        queryWrapper.eq((Object)"els_account", (Object)"100000");
        queryWrapper.eq((Object)"is_default_type", (Object)"1");
        List headList = this.templateHeadService.list((Wrapper)queryWrapper);
        for (TemplateHead templateHead : templateHeadList) {
            TemplateHeadVO headVO = new TemplateHeadVO();
            BeanUtils.copyProperties((Object)templateHead, (Object)headVO);
            headVO.setTemplateConfigHeadList((List)ObjectUtil.defaultIfNull(templateConfigHeadMap.get(templateHead.getId()), (Object)Lists.newArrayList()));
            headVO.setTemplateConfigItemList((List)ObjectUtil.defaultIfNull(templateConfigItemMap.get(templateHead.getId()), (Object)Lists.newArrayList()));
            headVO.setTemplateGroupList((List)ObjectUtil.defaultIfNull(templateGroupMap.get(templateHead.getId()), (Object)Lists.newArrayList()));
            if (StrUtil.isBlank((CharSequence)templateHead.getId())) {
                this.templateHeadService.saveMain(templateHead, headVO.getTemplateGroupList(), headVO.getTemplateConfigHeadList(), headVO.getTemplateConfigItemList());
                headVO.setTemplateNumber(templateHead.getTemplateNumber());
                headVO.setTemplateVersion(templateHead.getTemplateVersion());
            } else {
                this.templateHeadService.updateMain(templateHead, headVO.getTemplateGroupList(), headVO.getTemplateConfigHeadList(), headVO.getTemplateConfigItemList());
            }
            templateHead.setTemplateStatus(TemplateStatusEnum.GENERATED.getValue());
            if (StrUtil.isBlank((CharSequence)templateHead.getId())) {
                this.templateHeadService.saveMain(templateHead, headVO.getTemplateGroupList(), headVO.getTemplateConfigHeadList(), headVO.getTemplateConfigItemList());
                headVO.setTemplateNumber(templateHead.getTemplateNumber());
                headVO.setTemplateVersion(templateHead.getTemplateVersion());
            } else {
                this.templateHeadService.updateMain(templateHead, headVO.getTemplateGroupList(), headVO.getTemplateConfigHeadList(), headVO.getTemplateConfigItemList());
            }
            if ("supplierMasterData".equals(headVO.getBusinessType()) && !headList.isEmpty()) {
                String id = ((TemplateHead)headList.get(0)).getId();
                List<TemplateGroup> templateGroupList = this.templateGroupService.selectByMainId(id);
                templateGroupList.addAll(headVO.getTemplateGroupList());
                headVO.setTemplateGroupList(templateGroupList);
                List<TemplateConfigHead> templateConfigHeadList = this.templateConfigHeadService.selectByMainId(id);
                for (TemplateConfigHead templateConfigHead : templateConfigHeadList) {
                    if (templateConfigHead.getFieldName().equals("elsAccount")) {
                        templateConfigHead.setFieldName("toElsAccount");
                    }
                    templateConfigHead.setPurchaseEdit("0");
                    templateConfigHead.setSaleEdit("0");
                }
                templateConfigHeadList.addAll(headVO.getTemplateConfigHeadList());
                headVO.setTemplateConfigHeadList(templateConfigHeadList);
            }
            this.setCompute(headVO.getTemplateConfigItemList());
            String savePathDir = this.uploadpath + File.separator + "js" + File.separator + TenantContext.getTenant();
            try {
                ConfigPageGeneJsUtil.generatorJs(savePathDir, headVO);
            }
            catch (Exception e) {
                log.error(e.getMessage());
            }
            StringBuilder redisKey = new StringBuilder("srm:template:").append(this.getTenantId()).append(":").append(headVO.getTemplateNumber()).append(":").append(headVO.getTemplateVersion());
            this.redisUtil.del(redisKey.toString());
        }
        return Result.ok("\u6279\u91cf\u751f\u6210\u914d\u7f6e\u6210\u529f\uff01");
    }

    @ApiOperation(value="\u751f\u6210\u914d\u7f6e", notes="\u751f\u6210\u914d\u7f6e")
    @PostMapping(value={"/generateConfig"})
    @Transactional(rollbackFor={RuntimeException.class})
    public Result<?> generateConfig(@RequestBody TemplateHeadVO headVO) {
        TemplateHead templateHead = new TemplateHead();
        BeanUtils.copyProperties((Object)headVO, (Object)templateHead);
        templateHead.setTemplateStatus(TemplateStatusEnum.GENERATED.getValue());
        if (StrUtil.isBlank((CharSequence)templateHead.getId())) {
            this.templateHeadService.saveMain(templateHead, headVO.getTemplateGroupList(), headVO.getTemplateConfigHeadList(), headVO.getTemplateConfigItemList());
            headVO.setTemplateNumber(templateHead.getTemplateNumber());
            headVO.setTemplateVersion(templateHead.getTemplateVersion());
        } else {
            this.templateHeadService.updateMain(templateHead, headVO.getTemplateGroupList(), headVO.getTemplateConfigHeadList(), headVO.getTemplateConfigItemList());
        }
        if ("supplierMasterData".equals(headVO.getBusinessType())) {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"business_type", (Object)"enterprise");
            queryWrapper.eq((Object)"els_account", (Object)"100000");
            queryWrapper.eq((Object)"is_default_type", (Object)"1");
            List headList = this.templateHeadService.list((Wrapper)queryWrapper);
            if (!headList.isEmpty()) {
                String id = ((TemplateHead)headList.get(0)).getId();
                List<TemplateGroup> templateGroupList = this.templateGroupService.selectByMainId(id);
                templateGroupList.addAll(headVO.getTemplateGroupList());
                headVO.setTemplateGroupList(templateGroupList);
                List<TemplateConfigHead> templateConfigHeadList = this.templateConfigHeadService.selectByMainId(id);
                for (TemplateConfigHead templateConfigHead : templateConfigHeadList) {
                    if (templateConfigHead.getFieldName().equals("elsAccount")) {
                        templateConfigHead.setFieldName("toElsAccount");
                    }
                    templateConfigHead.setPurchaseEdit("0");
                    templateConfigHead.setSaleEdit("0");
                }
                templateConfigHeadList.addAll(headVO.getTemplateConfigHeadList());
                headVO.setTemplateConfigHeadList(templateConfigHeadList);
            }
        }
        this.setCompute(headVO.getTemplateConfigItemList());
        String savePathDir = this.uploadpath + File.separator + "js" + File.separator + TenantContext.getTenant();
        ConfigPageGeneJsUtil.generatorJs(savePathDir, headVO);
        StringBuilder redisKey = new StringBuilder("srm:template:").append(this.getTenantId()).append(":").append(headVO.getTemplateNumber()).append(":").append(headVO.getTemplateVersion());
        this.redisUtil.del(redisKey.toString());
        return Result.ok(templateHead);
    }

    private void setCompute(List<TemplateConfigItem> itemList) {
        if (CollectionUtil.isNotEmpty(itemList)) {
            List formulaList = itemList.stream().filter(item -> StrUtil.isNotBlank((CharSequence)item.getFormula())).collect(Collectors.toList());
            HashMap<String, Boolean> computeMap = new HashMap<String, Boolean>();
            for (TemplateConfigItem item2 : formulaList) {
                Matcher matcher = this.pattern.matcher(item2.getFormula());
                while (matcher.find()) {
                    computeMap.put(matcher.group(1), true);
                }
            }
            for (TemplateConfigItem item2 : itemList) {
                if (computeMap.get(item2.getFieldName()) == null || !((Boolean)computeMap.get(item2.getFieldName())).booleanValue()) continue;
                item2.setCompute("1");
            }
        }
    }

    @ApiOperation(value="\u5347\u7ea7\u7248\u672c", notes="\u5347\u7ea7\u7248\u672c")
    @GetMapping(value={"/upgradeVersion"})
    public Result<?> upgradeVersion(@RequestParam(name="id") String id) {
        this.templateHeadService.upgradeVersion(id);
        return this.commonSuccessResult(3);
    }

    @ApiOperation(value="\u7f16\u8f91", notes="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    public Result<?> edit(@RequestBody TemplateHeadVO templateHeadPage) {
        TemplateHead templateHead = new TemplateHead();
        BeanUtils.copyProperties((Object)templateHeadPage, (Object)templateHead);
        this.templateHeadService.updateMain(templateHead, templateHeadPage.getTemplateGroupList(), templateHeadPage.getTemplateConfigHeadList(), templateHeadPage.getTemplateConfigItemList());
        return Result.ok(templateHead);
    }

    @AutoLog(value="\u901a\u8fc7id\u5220\u9664")
    @ApiOperation(value="\u901a\u8fc7id\u5220\u9664", notes="\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    public Result<?> delete(@RequestParam(name="id") String id) {
        this.templateHeadService.delMain(id);
        return this.commonSuccessResult(4);
    }

    @AutoLog(value="\u6279\u91cf\u5220\u9664")
    @ApiOperation(value="\u6279\u91cf\u5220\u9664", notes="\u6279\u91cf\u5220\u9664")
    @GetMapping(value={"/deleteBatch"})
    public Result<?> deleteBatch(@RequestParam(name="ids") String ids) {
        this.templateHeadService.delBatchMain(Arrays.asList(ids.split(",")));
        return this.commonSuccessResult(4);
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2", notes="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    public Result<?> queryById(@RequestParam(name="id") String id) {
        TemplateHead templateHead = (TemplateHead)this.templateHeadService.getById((Serializable)((Object)id));
        TemplateHeadVO templateHeadVO = new TemplateHeadVO();
        BeanUtils.copyProperties((Object)templateHead, (Object)templateHeadVO);
        List<TemplateGroup> templateGroupList = this.templateGroupService.selectByMainId(id);
        templateHeadVO.setTemplateGroupList(templateGroupList);
        List<TemplateConfigHead> templateConfigHeadList = this.templateConfigHeadService.selectByMainId(id);
        templateHeadVO.setTemplateConfigHeadList(templateConfigHeadList);
        List<TemplateConfigItem> templateConfigItemList = this.templateConfigItemService.selectByMainId(id);
        templateHeadVO.setTemplateConfigItemList(templateConfigItemList);
        return Result.ok(templateHeadVO);
    }

    @ApiOperation(value="\u901a\u8fc7\u4e1a\u52a1\u7f16\u7801\u67e5\u8be2100000\u53f7\u914d\u7f6e\u7cfb\u7edf\u7ea7\u4fe1\u606f", notes="\u901a\u8fc7\u4e1a\u52a1\u7f16\u7801\u67e5\u8be2100000\u53f7\u914d\u7f6e\u7cfb\u7edf\u7ea7\u4fe1\u606f")
    @GetMapping(value={"/querySysByBusinessType"})
    public Result<?> querySysByBusinessType(@RequestParam(name="businessType") String businessType) {
        List<TemplateConfigItem> templateConfigItemList;
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"business_type", (Object)businessType);
        queryWrapper.eq((Object)"els_account", (Object)"100000");
        queryWrapper.eq((Object)"is_default_type", (Object)"1");
        List headList = this.templateHeadService.list((Wrapper)queryWrapper);
        if (headList.isEmpty()) {
            throw new ELSBootException(I18nUtil.translate("i18n_alert_LYuWWWWWWERAcWWWWWWWWjWF_3368276c", "\u672a\u627e\u5230100000\u914d\u7f6e\u7c7b\u578b\uff1a${0} \u7684\u6570\u636e", businessType));
        }
        String id = ((TemplateHead)headList.get(0)).getId();
        TemplateHead templateHead = (TemplateHead)this.templateHeadService.getById((Serializable)((Object)id));
        TemplateHeadVO templateHeadVO = new TemplateHeadVO();
        BeanUtils.copyProperties((Object)templateHead, (Object)templateHeadVO);
        List<TemplateGroup> templateGroupList = this.templateGroupService.selectByMainId(id);
        templateHeadVO.setTemplateGroupList(templateGroupList);
        List<TemplateConfigHead> templateConfigHeadList = this.templateConfigHeadService.selectByMainId(id);
        if (!templateConfigHeadList.isEmpty()) {
            List<TemplateConfigHead> configHeadList = templateConfigHeadList.parallelStream().filter(vo -> "1".equals(vo.getSys())).collect(Collectors.toList());
            templateHeadVO.setTemplateConfigHeadList(configHeadList);
        }
        if (!(templateConfigItemList = this.templateConfigItemService.selectByMainId(id)).isEmpty()) {
            List<TemplateConfigItem> configItemList = templateConfigItemList.parallelStream().filter(vo -> "1".equals(vo.getSys())).collect(Collectors.toList());
            templateHeadVO.setTemplateConfigItemList(configItemList);
        }
        return Result.ok(templateHeadVO);
    }

    @ApiOperation(value="\u901a\u8fc7\u4e1a\u52a1\u7f16\u7801\u67e5\u8be2100000\u53f7\u914d\u7f6e\u8868\u5934\u5b57\u6bb5\uff08\u9664\u7cfb\u7edf\u7ea7\u5b57\u6bb5\u5916\uff09", notes="\u901a\u8fc7\u4e1a\u52a1\u7f16\u7801\u67e5\u8be2100000\u53f7\u914d\u7f6e\u8868\u5934\u5b57\u6bb5\uff08\u9664\u7cfb\u7edf\u7ea7\u5b57\u6bb5\u5916\uff09")
    @GetMapping(value={"/queryHeadFieldsByBusinessType"})
    public Result<?> queryHeadFieldsByBusinessType(@RequestParam(name="businessType") String businessType) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"business_type", (Object)businessType);
        queryWrapper.eq((Object)"is_default_type", (Object)"1");
        queryWrapper.eq((Object)"els_account", (Object)"100000");
        List headList = this.templateHeadService.list((Wrapper)queryWrapper);
        if (headList.isEmpty()) {
            throw new ELSBootException(I18nUtil.translate("i18n_alert_LYuWWWWWWERAcWWWWWWWWjWF_3368276c", "\u672a\u627e\u5230100000\u914d\u7f6e\u7c7b\u578b\uff1a${0}\u7684\u9ed8\u8ba4\u914d\u7f6e", businessType));
        }
        String id = ((TemplateHead)headList.get(0)).getId();
        TemplateHead templateHead = (TemplateHead)this.templateHeadService.getById((Serializable)((Object)id));
        TemplateHeadVO templateHeadVO = new TemplateHeadVO();
        BeanUtils.copyProperties((Object)templateHead, (Object)templateHeadVO);
        List<TemplateConfigHead> templateConfigHeadList = this.templateConfigHeadService.selectByMainId(id);
        if (!templateConfigHeadList.isEmpty()) {
            List<TemplateConfigHead> configHeadList = templateConfigHeadList.parallelStream().filter(vo -> !"1".equals(vo.getSys())).collect(Collectors.toList());
            templateHeadVO.setTemplateConfigHeadList(configHeadList);
        }
        return Result.ok(templateHeadVO);
    }

    @ApiOperation(value="\u901a\u8fc7\u4e1a\u52a1\u7f16\u7801\u67e5\u8be2100000\u53f7\u914d\u7f6e\u8868\u884c\u5b57\u6bb5\uff08\u9664\u7cfb\u7edf\u7ea7\u5b57\u6bb5\u5916\uff09", notes="\u901a\u8fc7\u4e1a\u52a1\u7f16\u7801\u67e5\u8be2100000\u53f7\u914d\u7f6e\u8868\u884c\u5b57\u6bb5\uff08\u9664\u7cfb\u7edf\u7ea7\u5b57\u6bb5\u5916\uff09")
    @GetMapping(value={"/queryItemFieldsByBusinessType"})
    public Result<?> queryItemFieldsByBusinessType(@RequestParam(name="businessType") String businessType) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"business_type", (Object)businessType);
        queryWrapper.eq((Object)"is_default_type", (Object)"1");
        queryWrapper.eq((Object)"els_account", (Object)"100000");
        List headList = this.templateHeadService.list((Wrapper)queryWrapper);
        if (headList.isEmpty()) {
            throw new ELSBootException(I18nUtil.translate("i18n_alert_LYuWWWWWWERAcWWWWWWWWjWF_3368276c", "\u672a\u627e\u5230100000\u914d\u7f6e\u7c7b\u578b\uff1a${0}\u7684\u9ed8\u8ba4\u914d\u7f6e", businessType));
        }
        String id = ((TemplateHead)headList.get(0)).getId();
        TemplateHead templateHead = (TemplateHead)this.templateHeadService.getById((Serializable)((Object)id));
        TemplateHeadVO templateHeadVO = new TemplateHeadVO();
        BeanUtils.copyProperties((Object)templateHead, (Object)templateHeadVO);
        List<TemplateConfigItem> templateConfigItemList = this.templateConfigItemService.selectByMainId(id);
        if (!templateConfigItemList.isEmpty()) {
            List<TemplateConfigItem> configItemList = templateConfigItemList.parallelStream().filter(vo -> !"1".equals(vo.getSys())).collect(Collectors.toList());
            templateHeadVO.setTemplateConfigItemList(configItemList);
        }
        return Result.ok(templateHeadVO);
    }

    @ApiOperation(value="\u901a\u8fc7\u4e1a\u52a1\u6a21\u677f\u914d\u7f6eid\u67e5\u8be2\u4e1a\u52a1\u6a21\u677f\u5206\u7ec4", notes="\u901a\u8fc7\u4e1a\u52a1\u6a21\u677f\u914d\u7f6eid\u67e5\u8be2\u4e1a\u52a1\u6a21\u677f\u5206\u7ec4")
    @GetMapping(value={"/queryTemplateGroupByMainId"})
    public Result<?> queryTemplateGroupListByMainId(@RequestParam(name="id") String id) {
        List<TemplateGroup> templateGroupList = this.templateGroupService.selectByMainId(id);
        return Result.ok(templateGroupList);
    }

    @ApiOperation(value="\u901a\u8fc7\u4e1a\u52a1\u6a21\u677f\u914d\u7f6eid\u67e5\u8be2\u4e1a\u52a1\u6a21\u677f\u914d\u7f6e\u4fe1\u606f\u8868", notes="\u901a\u8fc7\u4e1a\u52a1\u6a21\u677f\u914d\u7f6eid\u67e5\u8be2\u4e1a\u52a1\u6a21\u677f\u914d\u7f6e\u4fe1\u606f\u8868")
    @GetMapping(value={"/queryTemplateConfigHeadByMainId"})
    public Result<?> queryTemplateConfigHeadListByMainId(@RequestParam(name="id") String id) {
        List<TemplateConfigHead> templateConfigHeadList = this.templateConfigHeadService.selectByMainId(id);
        return Result.ok(templateConfigHeadList);
    }

    @ApiOperation(value="\u901a\u8fc7\u4e1a\u52a1\u6a21\u677f\u914d\u7f6eid\u67e5\u8be2\u4e1a\u52a1\u6a21\u677f\u914d\u7f6e\u884c\u4fe1\u606f\u8868", notes="\u901a\u8fc7\u4e1a\u52a1\u6a21\u677f\u914d\u7f6eid\u67e5\u8be2\u4e1a\u52a1\u6a21\u677f\u914d\u7f6e\u884c\u4fe1\u606f\u8868")
    @GetMapping(value={"/queryTemplateConfigItemByMainId"})
    public Result<?> queryTemplateConfigItemListByMainId(@RequestParam(name="id") String id) {
        List<TemplateConfigItem> templateConfigItemList = this.templateConfigItemService.selectByMainId(id);
        return Result.ok(templateConfigItemList);
    }

    @GetMapping(value={"/exportXls"})
    public ModelAndView exportXls(HttpServletRequest request, TemplateHead templateHead) {
        QueryWrapper<TemplateHead> queryWrapper = QueryGenerator.initQueryWrapper(templateHead, request.getParameterMap());
        LoginUser sysUser = (LoginUser)SecurityUtils.getSubject().getPrincipal();
        ArrayList<TemplateHeadVO> pageList = new ArrayList<TemplateHeadVO>();
        List templateHeadList = this.templateHeadService.list((Wrapper)queryWrapper);
        for (TemplateHead temp : templateHeadList) {
            TemplateHeadVO vo = new TemplateHeadVO();
            BeanUtils.copyProperties((Object)temp, (Object)vo);
            List<TemplateGroup> templateGroupList = this.templateGroupService.selectByMainId(temp.getId());
            vo.setTemplateGroupList(templateGroupList);
            List<TemplateConfigHead> templateConfigHeadList = this.templateConfigHeadService.selectByMainId(temp.getId());
            vo.setTemplateConfigHeadList(templateConfigHeadList);
            List<TemplateConfigItem> templateConfigItemList = this.templateConfigItemService.selectByMainId(temp.getId());
            vo.setTemplateConfigItemList(templateConfigItemList);
            pageList.add(vo);
        }
        ModelAndView mv = new ModelAndView((View)new ELSEntityExcelView());
        mv.addObject("fileName", (Object)"\u4e1a\u52a1\u6a21\u677f\u914d\u7f6e");
        mv.addObject("entity", TemplateHeadVO.class);
        mv.addObject("params", (Object)new ExportParams("\u4e1a\u52a1\u6a21\u677f\u914d\u7f6e\u6570\u636e", "\u5bfc\u51fa\u4eba:" + sysUser.getRealname(), "\u4e1a\u52a1\u6a21\u677f\u914d\u7f6e", request.getParameter("defineColumnCode")));
        mv.addObject("data", pageList);
        return mv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostMapping(value={"/importExcel"})
    public Result<?> importExcel(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        Iterator iterator = fileMap.entrySet().iterator();
        if (iterator.hasNext()) {
            Map.Entry entity = iterator.next();
            MultipartFile file = (MultipartFile)entity.getValue();
            ImportParams params = new ImportParams();
            params.setTitleRows(2);
            params.setHeadRows(1);
            params.setNeedSave(true);
            try {
                List<TemplateHeadVO> list = ExcelImportUtil.importExcel(file.getInputStream(), TemplateHeadVO.class, params);
                for (TemplateHeadVO page : list) {
                    TemplateHead po = new TemplateHead();
                    BeanUtils.copyProperties((Object)page, (Object)po);
                    this.templateHeadService.saveMain(po, page.getTemplateGroupList(), page.getTemplateConfigHeadList(), page.getTemplateConfigItemList());
                }
                Result<Object> result = Result.ok("\u6587\u4ef6\u5bfc\u5165\u6210\u529f\uff01\u6570\u636e\u884c\u6570:" + list.size());
                return result;
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                Result<Object> result = Result.error("\u6587\u4ef6\u5bfc\u5165\u5931\u8d25:" + e.getMessage());
                return result;
            }
            finally {
                try {
                    file.getInputStream().close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return Result.error("\u6587\u4ef6\u5bfc\u5165\u5931\u8d25\uff01");
    }
}

