/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.template.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.els.common.constant.CommonConstant;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.util.RedisUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.system.service.CodeGeneratorService;
import com.els.modules.system.util.I18nUtil;
import com.els.modules.template.entity.TemplateConfigHead;
import com.els.modules.template.entity.TemplateConfigHeadHis;
import com.els.modules.template.entity.TemplateConfigItem;
import com.els.modules.template.entity.TemplateConfigItemHis;
import com.els.modules.template.entity.TemplateGroup;
import com.els.modules.template.entity.TemplateGroupHis;
import com.els.modules.template.entity.TemplateHead;
import com.els.modules.template.entity.TemplateHeadHis;
import com.els.modules.template.enumerate.TemplateStatusEnum;
import com.els.modules.template.mapper.TemplateConfigHeadMapper;
import com.els.modules.template.mapper.TemplateConfigItemMapper;
import com.els.modules.template.mapper.TemplateGroupMapper;
import com.els.modules.template.mapper.TemplateHeadMapper;
import com.els.modules.template.service.TemplateHeadHisService;
import com.els.modules.template.service.TemplateHeadService;
import com.els.modules.template.vo.TemplateHeadHisVO;
import com.els.modules.template.vo.TemplateHeadVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TemplateHeadServiceImpl
extends ServiceImpl<TemplateHeadMapper, TemplateHead>
implements TemplateHeadService {
    @Resource
    private TemplateHeadMapper templateHeadMapper;
    @Resource
    private TemplateGroupMapper templateGroupMapper;
    @Resource
    private TemplateConfigHeadMapper templateConfigHeadMapper;
    @Resource
    private TemplateConfigItemMapper templateConfigItemMapper;
    @Autowired
    private CodeGeneratorService codeGeneratorService;
    @Autowired
    private TemplateHeadHisService templateHeadHisService;
    @Autowired
    private RedisUtil redisUtil;
    public static final String ADDRESS = "srm:template:";

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void saveMain(TemplateHead templateHead, List<TemplateGroup> templateGroupList, List<TemplateConfigHead> templateConfigHeadList, List<TemplateConfigItem> templateConfigItemList) {
        String templateNumber = this.codeGeneratorService.getNextCode("srmTemplateNumber", templateHead);
        templateHead.setTemplateNumber(templateNumber);
        templateHead.setTemplateVersion(1);
        templateHead.setTemplateStatus("0");
        templateHead.setDefaultType("0");
        this.templateHeadMapper.insert(templateHead);
        this.insertData(templateHead, templateGroupList, templateConfigHeadList, templateConfigItemList);
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void updateMain(TemplateHead templateHead, List<TemplateGroup> templateGroupList, List<TemplateConfigHead> templateConfigHeadList, List<TemplateConfigItem> templateConfigItemList) {
        this.templateHeadMapper.updateById(templateHead);
        this.templateGroupMapper.deleteByMainId(templateHead.getId());
        this.templateConfigHeadMapper.deleteByMainId(templateHead.getId());
        this.templateConfigItemMapper.deleteByMainId(templateHead.getId());
        this.insertData(templateHead, templateGroupList, templateConfigHeadList, templateConfigItemList);
    }

    private void insertData(TemplateHead templateHead, List<TemplateGroup> templateGroupList, List<TemplateConfigHead> templateConfigHeadList, List<TemplateConfigItem> templateConfigItemList) {
        for (TemplateGroup templateGroup : templateGroupList) {
            templateGroup.setId(null);
            templateGroup.setHeadId(templateHead.getId());
            SysUtil.setSysParam(templateGroup, templateHead);
        }
        if (!templateGroupList.isEmpty()) {
            this.templateGroupMapper.insertBatchSomeColumn(templateGroupList);
        }
        for (TemplateConfigHead templateConfigHead : templateConfigHeadList) {
            templateConfigHead.setId(null);
            templateConfigHead.setHeadId(templateHead.getId());
            templateConfigHead.setPurchaseEdit(templateConfigHead.getPurchaseEdit() == null ? "0" : templateConfigHead.getPurchaseEdit());
            templateConfigHead.setPurchaseShow(templateConfigHead.getPurchaseShow() == null ? "0" : templateConfigHead.getPurchaseShow());
            templateConfigHead.setSaleEdit(templateConfigHead.getSaleEdit() == null ? "0" : templateConfigHead.getSaleEdit());
            templateConfigHead.setSaleShow(templateConfigHead.getSaleShow() == null ? "0" : templateConfigHead.getSaleShow());
            templateConfigHead.setRequired(templateConfigHead.getRequired() == null ? "0" : templateConfigHead.getRequired());
            templateConfigHead.setSys(templateConfigHead.getSys() == null ? "0" : templateConfigHead.getSys());
            SysUtil.setSysParam(templateConfigHead, templateHead);
        }
        if (!templateConfigHeadList.isEmpty()) {
            this.templateConfigHeadMapper.insertBatchSomeColumn(templateConfigHeadList);
        }
        for (TemplateConfigItem templateConfigItem : templateConfigItemList) {
            templateConfigItem.setId(null);
            templateConfigItem.setHeadId(templateHead.getId());
            templateConfigItem.setPurchaseEdit(templateConfigItem.getPurchaseEdit() == null ? "0" : templateConfigItem.getPurchaseEdit());
            templateConfigItem.setPurchaseShow(templateConfigItem.getPurchaseShow() == null ? "0" : templateConfigItem.getPurchaseShow());
            templateConfigItem.setSaleEdit(templateConfigItem.getSaleEdit() == null ? "0" : templateConfigItem.getSaleEdit());
            templateConfigItem.setSaleShow(templateConfigItem.getSaleShow() == null ? "0" : templateConfigItem.getSaleShow());
            templateConfigItem.setRequired(templateConfigItem.getRequired() == null ? "0" : templateConfigItem.getRequired());
            templateConfigItem.setSys(templateConfigItem.getSys() == null ? "0" : templateConfigItem.getSys());
            SysUtil.setSysParam(templateConfigItem, templateHead);
        }
        if (!templateConfigItemList.isEmpty()) {
            this.templateConfigItemMapper.insertBatchSomeColumn(templateConfigItemList);
        }
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void delMain(String id) {
        this.templateGroupMapper.deleteByMainId(id);
        this.templateConfigHeadMapper.deleteByMainId(id);
        this.templateConfigItemMapper.deleteByMainId(id);
        this.templateHeadMapper.deleteById((Serializable)((Object)id));
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void delBatchMain(List<String> idList) {
        for (Serializable serializable : idList) {
            this.templateGroupMapper.deleteByMainId(serializable.toString());
            this.templateConfigHeadMapper.deleteByMainId(serializable.toString());
            this.templateConfigItemMapper.deleteByMainId(serializable.toString());
            this.templateHeadMapper.deleteById(serializable);
        }
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void copyById(String id) {
        TemplateHead templateHead = (TemplateHead)this.templateHeadMapper.selectById((Serializable)((Object)id));
        String templateNumber = this.codeGeneratorService.getNextCode("srmTemplateNumber", templateHead);
        templateHead.setId(null);
        templateHead.setElsAccount(TenantContext.getTenant());
        templateHead.setTemplateNumber(templateNumber);
        templateHead.setTemplateVersion(1);
        templateHead.setTemplateStatus("0");
        templateHead.setDefaultType("0");
        templateHead.setCreateBy(null);
        templateHead.setCreateTime(null);
        templateHead.setUpdateBy(null);
        templateHead.setUpdateTime(null);
        this.templateHeadMapper.insert(templateHead);
        List<TemplateGroup> templateGroupList = this.templateGroupMapper.selectByMainId(id);
        for (TemplateGroup templateGroup : templateGroupList) {
            templateGroup.setId(null);
            templateGroup.setElsAccount(TenantContext.getTenant());
            templateGroup.setHeadId(templateHead.getId());
        }
        if (!templateGroupList.isEmpty()) {
            this.templateGroupMapper.insertBatchSomeColumn(templateGroupList);
        }
        List<TemplateConfigHead> templateConfigHeadList = this.templateConfigHeadMapper.selectByMainId(id);
        for (TemplateConfigHead configHead : templateConfigHeadList) {
            configHead.setId(null);
            configHead.setElsAccount(TenantContext.getTenant());
            configHead.setHeadId(templateHead.getId());
        }
        if (!templateConfigHeadList.isEmpty()) {
            this.templateConfigHeadMapper.insertBatchSomeColumn(templateConfigHeadList);
        }
        List<TemplateConfigItem> list = this.templateConfigItemMapper.selectByMainId(id);
        for (TemplateConfigItem configItem : list) {
            configItem.setId(null);
            configItem.setElsAccount(TenantContext.getTenant());
            configItem.setHeadId(templateHead.getId());
        }
        if (!list.isEmpty()) {
            this.templateConfigItemMapper.insertBatchSomeColumn(list);
        }
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void upgradeVersion(String id) {
        TemplateHead templateHead = (TemplateHead)this.templateHeadMapper.selectById((Serializable)((Object)id));
        TemplateHeadHis headHis = new TemplateHeadHis();
        BeanUtils.copyProperties((Object)templateHead, (Object)headHis);
        headHis.setId(null);
        TemplateHead updateHead = new TemplateHead();
        updateHead.setId(templateHead.getId());
        updateHead.setTemplateVersion(templateHead.getTemplateVersion() + 1);
        this.templateHeadMapper.updateById(updateHead);
        ArrayList<TemplateGroupHis> templateGroupHisList = new ArrayList<TemplateGroupHis>();
        ArrayList<TemplateConfigHeadHis> templateConfigHeadHisList = new ArrayList<TemplateConfigHeadHis>();
        ArrayList<TemplateConfigItemHis> templateConfigItemHisList = new ArrayList<TemplateConfigItemHis>();
        List<TemplateGroup> templateGroupList = this.templateGroupMapper.selectByMainId(id);
        for (TemplateGroup templateGroup : templateGroupList) {
            TemplateGroupHis groupHis = new TemplateGroupHis();
            BeanUtils.copyProperties((Object)templateGroup, (Object)groupHis);
            groupHis.setId(null);
            templateGroupHisList.add(groupHis);
        }
        List<TemplateConfigHead> templateConfigHeadList = this.templateConfigHeadMapper.selectByMainId(id);
        for (TemplateConfigHead configHead : templateConfigHeadList) {
            TemplateConfigHeadHis configHeadHis = new TemplateConfigHeadHis();
            BeanUtils.copyProperties((Object)configHead, (Object)configHeadHis);
            configHeadHis.setId(null);
            templateConfigHeadHisList.add(configHeadHis);
        }
        List<TemplateConfigItem> list = this.templateConfigItemMapper.selectByMainId(id);
        for (TemplateConfigItem configItem : list) {
            TemplateConfigItemHis configItemHis = new TemplateConfigItemHis();
            BeanUtils.copyProperties((Object)configItem, (Object)configItemHis);
            configItemHis.setId(null);
            templateConfigItemHisList.add(configItemHis);
        }
        this.templateHeadHisService.saveMain(headHis, templateGroupHisList, templateConfigHeadHisList, templateConfigItemHisList);
    }

    @Override
    public TemplateHeadVO getAllConfig(String busAccount, String templateNumber, String templateVersion) {
        StringBuilder redisKey = new StringBuilder(ADDRESS).append(busAccount).append(":").append(templateNumber).append(":").append(templateVersion);
        TemplateHeadVO headVO = (TemplateHeadVO)this.redisUtil.get(redisKey.toString());
        if (headVO == null) {
            headVO = new TemplateHeadVO();
            TemplateHead head = (TemplateHead)this.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(BaseEntity::getElsAccount, (Object)busAccount)).eq(TemplateHead::getTemplateNumber, (Object)templateNumber)).eq(TemplateHead::getTemplateVersion, (Object)templateVersion));
            if (head == null) {
                TemplateHeadHisVO headHisVO = this.templateHeadHisService.getAllConfig(busAccount, templateNumber, templateVersion);
                BeanUtils.copyProperties((Object)headHisVO, (Object)headVO);
                ArrayList<TemplateConfigHead> templateConfigHeadList = new ArrayList<TemplateConfigHead>();
                for (TemplateConfigHeadHis headHis : headHisVO.getTemplateConfigHeadHisList()) {
                    TemplateConfigHead configHead = new TemplateConfigHead();
                    BeanUtils.copyProperties((Object)headHis, (Object)configHead);
                    templateConfigHeadList.add(configHead);
                }
                headVO.setTemplateConfigHeadList(templateConfigHeadList);
                ArrayList<TemplateConfigItem> templateConfigItemList = new ArrayList<TemplateConfigItem>();
                for (TemplateConfigItemHis itemHis : headHisVO.getTemplateConfigItemHisList()) {
                    TemplateConfigItem configItem = new TemplateConfigItem();
                    BeanUtils.copyProperties((Object)itemHis, (Object)configItem);
                    templateConfigItemList.add(configItem);
                }
                headVO.setTemplateConfigItemList(templateConfigItemList);
            } else {
                BeanUtils.copyProperties((Object)head, (Object)headVO);
                List<TemplateConfigHead> templateConfigHeadList = this.templateConfigHeadMapper.selectByMainId(head.getId());
                headVO.setTemplateConfigHeadList(templateConfigHeadList);
                List<TemplateConfigItem> templateConfigItemList = this.templateConfigItemMapper.selectByMainId(head.getId());
                headVO.setTemplateConfigItemList(templateConfigItemList);
            }
            this.redisUtil.set(redisKey.toString(), headVO);
        }
        return headVO;
    }

    @Override
    public List<TemplateHead> getAllByAccountAndType(String elsAccount, String businessType) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"els_account", (Object)elsAccount);
        wrapper.eq((Object)"business_type", (Object)businessType);
        wrapper.eq((Object)"is_deleted", (Object)CommonConstant.DEL_FLAG_0);
        wrapper.eq((Object)"is_default_type", (Object)1);
        wrapper.lambda().orderByDesc(BaseEntity::getCreateTime);
        List list = this.templateHeadMapper.selectList((Wrapper)wrapper);
        List<TemplateHead> result = list.stream().filter(o -> "1".equals(o.getDefaultType())).collect(Collectors.toList());
        if (result.isEmpty()) {
            return list;
        }
        return result;
    }

    @Override
    public List<TemplateHead> getDefaultTemplateByType(String businessType) {
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(TemplateHead::getBusinessType, (Object)businessType)).eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant())).eq(TemplateHead::getTemplateStatus, (Object)TemplateStatusEnum.GENERATED.getValue())).eq(TemplateHead::getDefaultType, (Object)"1")).list();
        if (list.isEmpty()) {
            list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(TemplateHead::getBusinessType, (Object)businessType)).eq(BaseEntity::getElsAccount, (Object)"100000")).eq(TemplateHead::getDefaultType, (Object)"1")).eq(TemplateHead::getTemplateStatus, (Object)TemplateStatusEnum.GENERATED.getValue())).list();
        }
        if (list.isEmpty()) {
            throw new ELSBootException(I18nUtil.translate("i18n_alert_VERWWWWUEtCLIr_5e2e80d8", "\u8bf7\u914d\u7f6e${0}\u5e73\u53f0\u7ea7\u9ed8\u8ba4\u6a21\u677f", businessType));
        }
        return list;
    }

    @Override
    public TemplateHead getDefaultOneTemplateByType(String businessType) {
        return this.getDefaultTemplateByType(businessType).get(0);
    }
}

