/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.els.common.constant.CommonConstant;
import com.els.common.exception.ELSBootException;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.ConvertUtils;
import com.els.config.mybatis.TenantContext;
import com.els.modules.system.entity.CompanyPermission;
import com.els.modules.system.entity.ElsSubAccount;
import com.els.modules.system.entity.Permission;
import com.els.modules.system.entity.Role;
import com.els.modules.system.entity.RolePermission;
import com.els.modules.system.entity.UserRole;
import com.els.modules.system.mapper.PermissionMapper;
import com.els.modules.system.model.TreeModel;
import com.els.modules.system.service.ElsSubAccountService;
import com.els.modules.system.service.PermissionService;
import com.els.modules.system.service.RolePermissionService;
import com.els.modules.system.service.RoleService;
import com.els.modules.system.service.UserRoleService;
import com.els.modules.system.util.I18nUtil;
import com.els.modules.system.vo.PermissionVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.shiro.SecurityUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PermissionServiceImpl
extends ServiceImpl<PermissionMapper, Permission>
implements PermissionService {
    @Resource
    private PermissionMapper permissionMapper;
    @Resource
    private RolePermissionService rolePermissionService;
    @Resource
    private ElsSubAccountService elsSubAccountService;
    @Resource
    private RoleService roleService;
    @Resource
    private UserRoleService userRoleService;

    @Override
    public List<TreeModel> queryListByParentId(String parentId) {
        return this.permissionMapper.queryListByParentId(parentId);
    }

    @Override
    @Transactional
    @CacheEvict(value={"sys:cache:permission:datarules"}, allEntries=true)
    public void deletePermission(String id) throws ELSBootException {
        int count;
        Permission sysPermission = (Permission)this.getById((Serializable)((Object)id));
        if (sysPermission == null) {
            throw new ELSBootException(I18nUtil.translate("i18n_alert_LYuntVH_24eb9383", "\u672a\u627e\u5230\u83dc\u5355\u4fe1\u606f"));
        }
        String pid = sysPermission.getParentId();
        if (ConvertUtils.isNotEmpty(pid) && (count = this.count((Wrapper)new QueryWrapper().lambda().eq(Permission::getParentId, (Object)pid))) == 1) {
            this.permissionMapper.setMenuLeaf(pid, 1);
        }
        this.permissionMapper.deleteById((Serializable)((Object)id));
        this.removeChildrenBy(sysPermission.getId());
    }

    public void removeChildrenBy(String parentId) {
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        query.eq(Permission::getParentId, (Object)parentId);
        List permissionList = this.list((Wrapper)query);
        if (permissionList != null && permissionList.size() > 0) {
            String id = "";
            int num = 0;
            this.remove((Wrapper)query);
            int len = permissionList.size();
            for (int i = 0; i < len; ++i) {
                id = ((Permission)permissionList.get(i)).getId();
                num = this.count((Wrapper)new LambdaQueryWrapper().eq(Permission::getParentId, (Object)id));
                if (num <= 0) continue;
                this.removeChildrenBy(id);
            }
        }
    }

    @Override
    @CacheEvict(value={"sys:cache:permission:datarules"}, allEntries=true)
    public void addPermission(Permission sysPermission) throws ELSBootException {
        String pid;
        if (CommonConstant.MENU_TYPE_0.equals(sysPermission.getMenuType())) {
            sysPermission.setParentId(null);
        }
        if (ConvertUtils.isNotEmpty(pid = sysPermission.getParentId())) {
            this.permissionMapper.setMenuLeaf(pid, 0);
        }
        sysPermission.setCreateTime(new Date());
        sysPermission.setDeleted(CommonConstant.DEL_FLAG_0);
        sysPermission.setLeaf(true);
        this.save(sysPermission);
    }

    @Override
    @CacheEvict(value={"sys:cache:permission:datarules"}, allEntries=true)
    public void editPermission(Permission sysPermission) throws ELSBootException {
        int count;
        Permission p = (Permission)this.getById((Serializable)((Object)sysPermission.getId()));
        if (p == null) {
            throw new ELSBootException(I18nUtil.translate("i18n_alert_LYuntVH_24eb9383", "\u672a\u627e\u5230\u83dc\u5355\u4fe1\u606f"));
        }
        sysPermission.setUpdateTime(new Date());
        if (CommonConstant.MENU_TYPE_0.equals(sysPermission.getMenuType())) {
            sysPermission.setParentId("");
        }
        if ((count = this.count((Wrapper)new QueryWrapper().lambda().eq(Permission::getParentId, (Object)sysPermission.getId()))) == 0) {
            sysPermission.setLeaf(true);
        }
        this.updateById(sysPermission);
        String pid = sysPermission.getParentId();
        if (ConvertUtils.isNotEmpty(pid) && !pid.equals(p.getParentId()) || ConvertUtils.isEmpty(pid) && ConvertUtils.isNotEmpty(p.getParentId())) {
            this.permissionMapper.setMenuLeaf(pid, 0);
            int cc = this.count((Wrapper)new QueryWrapper().lambda().eq(Permission::getParentId, (Object)p.getParentId()));
            if (cc == 0 && ConvertUtils.isNotEmpty(p.getParentId())) {
                this.permissionMapper.setMenuLeaf(p.getParentId(), 1);
            }
        }
    }

    @Override
    public List<PermissionVO> queryByAccount(String elsAccount, String subAccount, Integer mobile) {
        return this.permissionMapper.queryByAccount(elsAccount, subAccount, mobile);
    }

    @Override
    public List<PermissionVO> queryByUser(String username) {
        return this.permissionMapper.queryAllByUser(username);
    }

    @Override
    @Cacheable(value={"sys:cache:permission:datarules"})
    public List<String> queryPermissionUrlWithStar() {
        return ((PermissionMapper)this.baseMapper).queryPermissionUrlWithStar();
    }

    @Override
    public List<PermissionVO> getCompanyMenuList(String elsAccount) {
        return ((PermissionMapper)this.baseMapper).getCompanyMenuList(elsAccount);
    }

    @Override
    public void editCompanyPermission(Permission permission) {
        LoginUser sysUser = (LoginUser)SecurityUtils.getSubject().getPrincipal();
        permission.setUpdateBy(sysUser.getSubAccount());
        permission.setUpdateTime(new Date());
        ((PermissionMapper)this.baseMapper).updateCompanyMeun(permission);
    }

    @Override
    public void saveCompanyPermission(String elsAccount, String permissionIds, String lastPermissionIds) {
        List<String> delete;
        List<String> add = this.getDiff(lastPermissionIds, permissionIds);
        Date currentDate = new Date();
        LoginUser sysUser = (LoginUser)SecurityUtils.getSubject().getPrincipal();
        String currentUser = sysUser.getSubAccount();
        if (add != null && add.size() > 0) {
            ArrayList<CompanyPermission> list = new ArrayList<CompanyPermission>();
            ArrayList<RolePermission> rolePermissionList = new ArrayList<RolePermission>();
            TenantContext.setTenant(elsAccount);
            Role role = (Role)this.roleService.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"els_account", (Object)elsAccount)).eq((Object)"role_code", (Object)"companyAdmin"));
            for (String p : add) {
                if (!ConvertUtils.isNotEmpty(p)) continue;
                CompanyPermission permission = new CompanyPermission();
                permission.setId(IdWorker.getIdStr());
                permission.setPermissionId(p);
                permission.setElsAccount(elsAccount);
                permission.setCreateTime(currentDate);
                permission.setUpdateTime(currentDate);
                permission.setCreateBy(currentUser);
                permission.setUpdateBy(currentUser);
                permission.setDeleted(CommonConstant.DEL_FLAG_0);
                list.add(permission);
                if (role == null) continue;
                RolePermission rolePermission = new RolePermission();
                rolePermission.setId(IdWorker.getIdStr());
                rolePermission.setPermissionId(p);
                rolePermission.setRoleId(role.getId());
                rolePermissionList.add(rolePermission);
            }
            if (!list.isEmpty()) {
                this.permissionMapper.insertCompanyMeunBatch(list);
            }
            if (!rolePermissionList.isEmpty()) {
                this.rolePermissionService.saveBatch(rolePermissionList);
            }
        }
        if ((delete = this.getDiff(permissionIds, lastPermissionIds)) != null && delete.size() > 0) {
            for (String permissionId : delete) {
                this.permissionMapper.deleteCompanyMeunByAccount(permissionId, elsAccount);
                this.rolePermissionService.remove((Wrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(RolePermission::getElsAccount, (Object)elsAccount)).eq(RolePermission::getPermissionId, (Object)permissionId));
            }
        }
    }

    private List<String> getDiff(String main, String diff) {
        if (ConvertUtils.isEmpty(diff)) {
            return null;
        }
        if (ConvertUtils.isEmpty(main)) {
            return Arrays.asList(diff.split(","));
        }
        String[] mainArr = main.split(",");
        String[] diffArr = diff.split(",");
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (String string : mainArr) {
            map.put(string, 1);
        }
        ArrayList<String> res = new ArrayList<String>();
        for (String key : diffArr) {
            if (!ConvertUtils.isNotEmpty(key) || map.containsKey(key)) continue;
            res.add(key);
        }
        return res;
    }

    @Override
    @Transactional
    public void initAccountPermission(String elsAccount, String role) {
        String userId;
        List list;
        String currentElsAccount = TenantContext.getTenant();
        if (!"100000".equals(currentElsAccount)) {
            throw new ELSBootException(I18nUtil.translate("i18n_alert_APeyBjbWtkW_413583d2", "\u5f53\u524d\u8d26\u53f7\u6ca1\u6709\u6743\u9650\u64cd\u4f5c\uff01"));
        }
        List itemList = null;
        itemList = "purchase".equals(role) ? this.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"els_account", (Object)currentElsAccount)).in((Object)"menu_attribute", new Object[]{"1", "3"})) : this.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"els_account", (Object)currentElsAccount)).in((Object)"menu_attribute", new Object[]{"2", "3"}));
        if (itemList.isEmpty()) {
            throw new ELSBootException(I18nUtil.translate("i18n_alert_LERdRAcntWtkKmW_fb0e9fa1", "\u672a\u914d\u7f6e\u76f8\u5173\u7c7b\u578b\u83dc\u5355\uff0c\u64cd\u4f5c\u5931\u8d25\uff01"));
        }
        ArrayList<CompanyPermission> companyPermissionList = new ArrayList<CompanyPermission>();
        Date currentTime = new Date();
        for (Permission permission : itemList) {
            CompanyPermission companyPermission = new CompanyPermission();
            companyPermission.setId(IdWorker.getIdStr());
            companyPermission.setElsAccount(elsAccount);
            companyPermission.setPermissionId(permission.getId());
            companyPermission.setDeleted(CommonConstant.DEL_FLAG_0);
            companyPermission.setCreateTime(currentTime);
            companyPermissionList.add(companyPermission);
        }
        this.permissionMapper.deleteCompanyMeunByAccount(null, elsAccount);
        this.permissionMapper.insertCompanyMeunBatch(companyPermissionList);
        TenantContext.setTenant(elsAccount);
        List roleList = this.roleService.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"els_account", (Object)elsAccount)).eq((Object)"role_code", (Object)"companyAdmin"));
        if (roleList.isEmpty()) {
            Role saveRole = new Role();
            saveRole.setId(IdWorker.getIdStr());
            saveRole.setElsAccount(elsAccount);
            saveRole.setRoleCode("companyAdmin");
            saveRole.setRoleName("\u4f01\u4e1a\u7ba1\u7406\u5458");
            this.roleService.save(saveRole);
            roleList.add(saveRole);
        } else {
            for (Object ro : roleList) {
                this.rolePermissionService.remove((Wrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(RolePermission::getElsAccount, (Object)elsAccount)).eq(RolePermission::getRoleId, (Object)((Role)ro).getId()));
            }
        }
        ArrayList<RolePermission> rolePermissionList = new ArrayList<RolePermission>();
        for (Permission permission : itemList) {
            for (Role ro : roleList) {
                RolePermission rolePermission = new RolePermission();
                rolePermission.setId(IdWorker.getIdStr());
                rolePermission.setElsAccount(elsAccount);
                rolePermission.setRoleId(ro.getId());
                rolePermission.setPermissionId(permission.getId());
                rolePermissionList.add(rolePermission);
            }
        }
        this.rolePermissionService.saveBatch(rolePermissionList);
        ElsSubAccount subAccount = this.elsSubAccountService.getByAccount(elsAccount, "1001");
        if (subAccount != null && (list = this.userRoleService.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"user_id", (Object)(userId = subAccount.getId()))).eq((Object)"role_id", (Object)((Role)roleList.get(0)).getId()))).isEmpty()) {
            UserRole userRole = new UserRole();
            userRole.setId(IdWorker.getIdStr());
            userRole.setUserId(userId);
            userRole.setRoleId(((Role)roleList.get(0)).getId());
            this.userRoleService.save(userRole);
        }
    }

    @Override
    public void initAccountPermissionList(List<String> elsAccountList, String role) {
        String currentElsAccount = TenantContext.getTenant();
        if (!"100000".equals(currentElsAccount)) {
            throw new ELSBootException(I18nUtil.translate("", "\u5f53\u524d\u8d26\u53f7\u6ca1\u6709\u6743\u9650\u64cd\u4f5c\uff01"));
        }
        List itemList = null;
        itemList = "purchase".equals(role) ? this.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"els_account", (Object)currentElsAccount)).in((Object)"menu_attribute", new Object[]{"1", "3"})) : this.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"els_account", (Object)currentElsAccount)).in((Object)"menu_attribute", new Object[]{"2", "3"}));
        if (itemList.isEmpty()) {
            throw new ELSBootException(I18nUtil.translate("", "\u672a\u914d\u7f6e\u76f8\u5173\u7c7b\u578b\u83dc\u5355\uff0c\u64cd\u4f5c\u5931\u8d25\uff01"));
        }
        ArrayList<CompanyPermission> companyPermissionList = new ArrayList<CompanyPermission>();
        Date currentTime = new Date();
        for (String elsAccount : elsAccountList) {
            String userId;
            List list;
            Object ro2;
            companyPermissionList.clear();
            for (Permission permission : itemList) {
                CompanyPermission companyPermission = new CompanyPermission();
                companyPermission.setId(IdWorker.getIdStr());
                companyPermission.setElsAccount(elsAccount);
                companyPermission.setPermissionId(permission.getId());
                companyPermission.setDeleted(CommonConstant.DEL_FLAG_0);
                companyPermission.setCreateTime(currentTime);
                companyPermissionList.add(companyPermission);
            }
            this.permissionMapper.deleteCompanyMeunByAccount(null, elsAccount);
            this.permissionMapper.insertCompanyMeunBatch(companyPermissionList);
            TenantContext.setTenant(elsAccount);
            List roleList = this.roleService.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"els_account", (Object)elsAccount)).eq((Object)"role_code", (Object)"companyAdmin"));
            if (roleList.isEmpty()) {
                Role saveRole = new Role();
                saveRole.setId(IdWorker.getIdStr());
                saveRole.setElsAccount(elsAccount);
                saveRole.setRoleCode("companyAdmin");
                saveRole.setRoleName("\u4f01\u4e1a\u7ba1\u7406\u5458");
                this.roleService.save(saveRole);
                roleList.add(saveRole);
            } else {
                for (Object ro2 : roleList) {
                    this.rolePermissionService.remove((Wrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(RolePermission::getElsAccount, (Object)elsAccount)).eq(RolePermission::getRoleId, (Object)((Role)ro2).getId()));
                }
            }
            ArrayList<RolePermission> rolePermissionList = new ArrayList<RolePermission>();
            ro2 = itemList.iterator();
            while (ro2.hasNext()) {
                Permission permission = (Permission)ro2.next();
                for (Role ro3 : roleList) {
                    RolePermission rolePermission = new RolePermission();
                    rolePermission.setId(IdWorker.getIdStr());
                    rolePermission.setElsAccount(elsAccount);
                    rolePermission.setRoleId(ro3.getId());
                    rolePermission.setPermissionId(permission.getId());
                    rolePermissionList.add(rolePermission);
                }
            }
            this.rolePermissionService.saveBatch(rolePermissionList);
            ElsSubAccount subAccount = this.elsSubAccountService.getByAccount(elsAccount, "1001");
            if (subAccount == null || !(list = this.userRoleService.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"user_id", (Object)(userId = subAccount.getId()))).eq((Object)"role_id", (Object)((Role)roleList.get(0)).getId()))).isEmpty()) continue;
            UserRole userRole = new UserRole();
            userRole.setId(IdWorker.getIdStr());
            userRole.setUserId(userId);
            userRole.setRoleId(((Role)roleList.get(0)).getId());
            this.userRoleService.save(userRole);
        }
    }

    @Override
    public Set<String> getAllOptPermission() {
        List permissionList = ((PermissionMapper)this.baseMapper).selectList((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"els_account", (Object)"100000")).eq((Object)"menu_type", (Object)"2"));
        List list = permissionList.stream().map(Permission::getPerms).collect(Collectors.toList());
        return new HashSet<String>(list);
    }
}

