/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.AssertUtil;
import com.els.common.util.RedisUtil;
import com.els.modules.system.entity.ElsPasswordSecurity;
import com.els.modules.system.enums.i18n.I18nElsPwSecurityEnum;
import com.els.modules.system.enums.i18n.I18nRecordOperaEnum;
import com.els.modules.system.mapper.ElsPasswordPolicyMapper;
import com.els.modules.system.mapper.ElsPasswordSecurityMapper;
import com.els.modules.system.mapper.ElsSubAccountMapper;
import com.els.modules.system.service.ElsPasswordSecurityService;
import com.els.modules.system.util.I18nUtil;
import com.els.modules.system.util.PwVerifyUtil;
import com.els.modules.system.vo.ElsPasswordSecurityVo;
import com.els.modules.system.vo.ElsPwSecurityEditVo;
import com.els.modules.system.vo.ElsPwSecuritySaveVo;
import java.util.Date;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class ElsPasswordSecurityServiceImpl
extends BaseServiceImpl<ElsPasswordSecurityMapper, ElsPasswordSecurity>
implements ElsPasswordSecurityService {
    @Resource
    ElsPasswordPolicyMapper pwPolicyMapper;
    @Resource
    ElsSubAccountMapper elsSubAccountMapper;
    @Autowired
    private RedisUtil redisUtil;

    private String getLoginErrorNumKey(String elsAccount, String elsSubAccount) {
        return "CACHE_LOGIN_ERROR_LOCK_" + elsAccount + "_" + elsSubAccount;
    }

    private long getLoginErrorExpireTime() {
        return 300L;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveElsPasswordSecurity(ElsPwSecuritySaveVo elsPwSecuritySaveVo) {
        LambdaQueryWrapper lambdaQueryWrapper = Wrappers.lambdaQuery();
        lambdaQueryWrapper.eq(BaseEntity::getElsAccount, (Object)elsPwSecuritySaveVo.getElsAccount());
        Assert.isTrue((((ElsPasswordSecurityMapper)this.baseMapper).selectCount((Wrapper)lambdaQueryWrapper) <= 0 ? 1 : 0) != 0, (String)I18nUtil.translate(I18nRecordOperaEnum.I18N_RECORD_ALREADY_EXISTS));
        ElsPasswordSecurity elsPasswordSecurity = new ElsPasswordSecurity();
        BeanUtils.copyProperties((Object)elsPwSecuritySaveVo, (Object)elsPasswordSecurity);
        Date now = new Date();
        elsPasswordSecurity.setCreateTime(now).setUpdateTime(now);
        ((ElsPasswordSecurityMapper)this.baseMapper).insert(elsPasswordSecurity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateElsPasswordSecurity(ElsPwSecurityEditVo elsPwSecurityEditVo) {
        LambdaQueryWrapper lambdaQueryWrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)lambdaQueryWrapper.eq(BaseEntity::getId, (Object)elsPwSecurityEditVo.getId())).eq(BaseEntity::getElsAccount, (Object)elsPwSecurityEditVo.getElsAccount());
        Assert.isTrue((((ElsPasswordSecurityMapper)this.baseMapper).selectCount((Wrapper)lambdaQueryWrapper) > 0 ? 1 : 0) != 0, (String)I18nUtil.translate(I18nRecordOperaEnum.I18N_RECORD_NOT_EXISTS));
        ElsPasswordSecurity elsPasswordSecurity = new ElsPasswordSecurity();
        elsPasswordSecurity.setComplexity(elsPwSecurityEditVo.getComplexity()).setMinLength(elsPwSecurityEditVo.getMinLength()).setModifyInterval(elsPwSecurityEditVo.getModifyInterval()).setErrorLock(elsPwSecurityEditVo.getErrorLock()).setUpdateBy(elsPwSecurityEditVo.getUpdateBy()).setUpdateTime(new Date()).setId(elsPwSecurityEditVo.getId());
        ((ElsPasswordSecurityMapper)this.baseMapper).updateById(elsPasswordSecurity);
    }

    @Override
    @Transactional(readOnly=true, rollbackFor={Exception.class})
    public ElsPasswordSecurityVo getElsPasswordSecurity(String elsAccount) {
        return ((ElsPasswordSecurityMapper)this.baseMapper).getElsPasswordSecurity(elsAccount);
    }

    @Override
    @Transactional(readOnly=true, rollbackFor={Exception.class})
    public String verifyModifyInterval(String elsAccount, String elsSubAccount) {
        Integer modifyInterval = ((ElsPasswordSecurityMapper)this.baseMapper).getModifyInterval(elsAccount);
        if (modifyInterval == null) {
            return null;
        }
        Date lastModifyDate = this.pwPolicyMapper.getPwPolicyUpdateTime(elsAccount, elsSubAccount);
        if (lastModifyDate == null) {
            lastModifyDate = this.elsSubAccountMapper.getUserCreateDate(elsAccount, elsSubAccount);
        }
        if (lastModifyDate != null) {
            return PwVerifyUtil.pwModifyIntervalVerify(lastModifyDate, modifyInterval);
        }
        return null;
    }

    @Override
    @Transactional(readOnly=true, rollbackFor={Exception.class})
    public void verifyErrorLock(String elsAccount, String elsSubAccount) {
        Integer errorLock = ((ElsPasswordSecurityMapper)this.baseMapper).getErrorLock(elsAccount);
        if (errorLock == null || errorLock <= 0) {
            return;
        }
        String loginErrorNumKey = this.getLoginErrorNumKey(elsAccount, elsSubAccount);
        Object cacheErrorNum = this.redisUtil.get(loginErrorNumKey);
        if (cacheErrorNum == null || Integer.parseInt(cacheErrorNum.toString()) < errorLock) {
            return;
        }
        this.redisUtil.set(loginErrorNumKey, cacheErrorNum, this.getLoginErrorExpireTime());
        AssertUtil.msgThrow(I18nUtil.translate(I18nElsPwSecurityEnum.I18N_LOGIN_ERROR_LOCK, String.valueOf(cacheErrorNum), "5"));
    }

    @Override
    public void setUpLoginErrorNum(String elsAccount, String elsSubAccount) {
        String loginErrorNumKey = this.getLoginErrorNumKey(elsAccount, elsSubAccount);
        Object cacheErrorNum = this.redisUtil.get(loginErrorNumKey);
        if (cacheErrorNum == null) {
            this.redisUtil.set(loginErrorNumKey, 1, this.getLoginErrorExpireTime());
            return;
        }
        this.redisUtil.set(loginErrorNumKey, Integer.parseInt(cacheErrorNum.toString()) + 1, this.redisUtil.getExpire(loginErrorNumKey));
    }
}

