/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.util;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.els.common.util.SpringContextUtils;
import com.els.config.mybatis.TenantContext;
import com.els.modules.system.enums.i18n.base.Ii18nEnum;
import com.els.modules.system.service.I18nService;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class I18nUtil {
    private static final Logger log = LoggerFactory.getLogger(I18nUtil.class);
    private static Pattern pattern = Pattern.compile("\\$\\{([^}]+)}");
    private static ThreadLocal<String> currentLanguage = new ThreadLocal();
    private static I18nService i18nService = SpringContextUtils.getBean(I18nService.class);
    public static LoadingCache<String, JSONObject> userLanguageCache = CacheBuilder.newBuilder().maximumSize(100000L).refreshAfterWrite(1800L, TimeUnit.SECONDS).build((CacheLoader)new CacheLoader<String, JSONObject>(){

        public JSONObject load(String userLanguage) throws Exception {
            String[] arr = userLanguage.split("_");
            JSONObject jsonObject = i18nService.findAllListCache(arr[0], arr[1]);
            log.info("\u67e5\u8be2\u5230\u5f53\u524d\u7528\u6237\u7684\u56fd\u9645\u5316\u6570\u636e\uff1a{}", (Object)jsonObject);
            if (jsonObject == null && !jsonObject.isEmpty()) {
                return new JSONObject();
            }
            return jsonObject;
        }
    });

    public static String getCurrentLanguage() {
        return currentLanguage.get();
    }

    public static void setCurrentLanguage(String language) {
        currentLanguage.set(language);
    }

    public static void clear() {
        currentLanguage.remove();
    }

    public static <T extends Enum<T>> String translate(T i18Enum) {
        return I18nUtil.translate(((Ii18nEnum)((Object)i18Enum)).i18nKey(), ((Ii18nEnum)((Object)i18Enum)).defaultValue());
    }

    public static <T extends Enum<T>> String translate(T i18Enum, String ... params) {
        return I18nUtil.translate(((Ii18nEnum)((Object)i18Enum)).i18nKey(), ((Ii18nEnum)((Object)i18Enum)).defaultValue(), params);
    }

    public static String translate(String i18nKey, String defaultValue) {
        if (StrUtil.isBlank((CharSequence)i18nKey)) {
            return defaultValue;
        }
        I18nService i18nService = SpringContextUtils.getBean(I18nService.class);
        return i18nService.getI18nValue(i18nKey, defaultValue);
    }

    public static String translateCache(String i18nKey, String defaultValue) {
        try {
            JSONObject i18nJson;
            if (StrUtil.isBlank((CharSequence)i18nKey)) {
                return defaultValue;
            }
            String language = I18nUtil.getCurrentLanguage();
            if (StrUtil.isBlank((CharSequence)language)) {
                language = "zh";
            }
            if ((i18nJson = (JSONObject)userLanguageCache.get((Object)(TenantContext.getTenant() + "_" + language))).size() == 0) {
                return defaultValue;
            }
            if (i18nJson.containsKey((Object)(TenantContext.getTenant() + "#" + i18nKey))) {
                return i18nJson.getString(TenantContext.getTenant() + "#" + i18nKey);
            }
            return defaultValue;
        }
        catch (ExecutionException e) {
            log.info("\u4ece\u672c\u5730\u7f13\u5b58\u83b7\u53d6\u56fd\u9645\u5316\u6570\u636e\u9519\u8bef\uff1a{}", (Object)e.getMessage());
            return defaultValue;
        }
    }

    public static String translate(String i18nKey, String defaultValue, String ... params) {
        if (params.length == 0) {
            return I18nUtil.translate(i18nKey, defaultValue);
        }
        if (StrUtil.isBlank((CharSequence)i18nKey)) {
            return I18nUtil.replace(defaultValue, params);
        }
        String i18nValue = I18nUtil.translate(i18nKey, defaultValue);
        return I18nUtil.replace(i18nValue, params);
    }

    private static String replace(String replaceString, String ... params) {
        StringBuffer sb = new StringBuffer();
        Matcher matcher = pattern.matcher(replaceString);
        while (matcher.find()) {
            int index = Integer.parseInt(matcher.group(1));
            matcher.appendReplacement(sb, params[index]);
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    public static void main(String[] args) {
        System.out.println(I18nUtil.translate("", "\u6211\u662f${2},\u6211\u6700${0},${1}\u54c8\u54c8", "\u5e05", "\u6ca1\u9519", "\u9648\u9f99"));
    }
}

