/*
 * Decompiled with CFR 0.152.
 */
package com.els;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.catalina.Context;
import org.apache.tomcat.util.scan.StandardJarScanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.actuate.autoconfigure.security.servlet.ManagementWebSecurityAutoConfiguration;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.autoconfigure.security.servlet.SecurityAutoConfiguration;
import org.springframework.boot.web.embedded.tomcat.TomcatServletWebServerFactory;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.core.env.ConfigurableEnvironment;
import springfox.documentation.swagger2.annotations.EnableSwagger2;

@EnableSwagger2
@SpringBootApplication(exclude={SecurityAutoConfiguration.class, ManagementWebSecurityAutoConfiguration.class})
public class ELSApplication {
    private static final Logger log = LoggerFactory.getLogger(ELSApplication.class);

    public static void main(String[] args) throws UnknownHostException {
        System.setProperty("spring.devtools.restart.enabled", "true");
        ConfigurableApplicationContext application = SpringApplication.run(ELSApplication.class, (String[])args);
        ConfigurableEnvironment env = application.getEnvironment();
        String ip = InetAddress.getLocalHost().getHostAddress();
        String port = env.getProperty("server.port");
        String path = env.getProperty("server.servlet.context-path");
        log.info("\n----------------------------------------------------------\n\tApplication iLogistics is running! Access URLs:\n\tLocal: \t\thttp://localhost:" + port + path + "/\n\tExternal: \thttp://" + ip + ":" + port + path + "/\n\tswagger-ui: \thttp://" + ip + ":" + port + path + "/swagger-ui.html\n\tDoc: \t\thttp://" + ip + ":" + port + path + "/doc.html\n----------------------------------------------------------");
    }

    @Bean
    public TomcatServletWebServerFactory tomcatFactory() {
        return new TomcatServletWebServerFactory(){

            protected void postProcessContext(Context context) {
                ((StandardJarScanner)context.getJarScanner()).setScanManifest(false);
            }
        };
    }
}

