/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.util;

import com.alibaba.excel.write.handler.SheetWriteHandler;
import com.alibaba.excel.write.metadata.holder.WriteSheetHolder;
import com.alibaba.excel.write.metadata.holder.WriteWorkbookHolder;
import com.els.common.exception.ELSBootException;
import com.els.common.system.vo.DictModel;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SqlInjectionUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.system.entity.ExcelDetail;
import com.els.modules.system.enums.ExcelDataTypeEnum;
import com.els.modules.system.service.DictService;
import com.els.modules.system.service.impl.DictServiceImpl;
import com.els.modules.system.util.I18nUtil;
import java.util.List;
import org.apache.poi.ss.usermodel.DataValidation;
import org.apache.poi.ss.usermodel.DataValidationConstraint;
import org.apache.poi.ss.usermodel.DataValidationHelper;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellRangeAddressList;

public class ExcelDictWriteHandler
implements SheetWriteHandler {
    private List<ExcelDetail> detailList;
    private DictService sysDictService;

    public ExcelDictWriteHandler(List<ExcelDetail> detailList) {
        this.detailList = detailList;
        this.sysDictService = SpringContextUtils.getBean(DictServiceImpl.class);
    }

    public void beforeSheetCreate(WriteWorkbookHolder writeWorkbookHolder, WriteSheetHolder writeSheetHolder) {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void afterSheetCreate(WriteWorkbookHolder writeWorkbookHolder, WriteSheetHolder writeSheetHolder) {
        Sheet sheet = writeSheetHolder.getSheet();
        DataValidationHelper helper = sheet.getDataValidationHelper();
        for (ExcelDetail detail : this.detailList) {
            int index = detail.getColumnIndex() - 1;
            if (!ExcelDataTypeEnum.DICT.getCode().equals(detail.getDataType())) continue;
            List<DictModel> dictList = null;
            String dictCode = detail.getDataFormat();
            if (dictCode.contains("#") || dictCode.contains(",")) {
                String[] params = null;
                params = dictCode.contains("#") ? dictCode.split("#") : dictCode.split(",");
                if (params.length < 3) {
                    throw new ELSBootException(I18nUtil.translate("", "\u5b57\u5178Code\u683c\u5f0f\u4e0d\u6b63\u786e"));
                }
                String[] sqlInjCheck = new String[]{params[0], params[1], params[2]};
                SqlInjectionUtil.filterContent(sqlInjCheck);
                if (params.length != 4) throw new ELSBootException(I18nUtil.translate("", "\u5b57\u5178\u4e0d\u5339\u914d"));
                String filterSql = params[3];
                SqlInjectionUtil.filterContent(filterSql);
                dictList = this.sysDictService.queryTableDictItemsByCodeAndFilter(params[0], params[1], params[2], filterSql, TenantContext.getTenant());
            } else {
                dictList = this.sysDictService.queryDictItemsByCode(detail.getDataFormat(), TenantContext.getTenant());
            }
            if (dictList.size() <= 0) continue;
            String[] values = new String[dictList.size()];
            for (int i = 0; i < dictList.size(); ++i) {
                values[i] = dictList.get(i).getText();
            }
            CellRangeAddressList addressList = new CellRangeAddressList(2, 1000, index, index);
            DataValidationConstraint constraint = helper.createExplicitListConstraint(values);
            DataValidation dataValidation = helper.createValidation(constraint, addressList);
            sheet.addValidationData(dataValidation);
        }
    }
}

