/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.util.encrypt;

import com.els.modules.system.util.encrypt.CipherUtil;
import java.io.ByteArrayOutputStream;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import javax.crypto.Cipher;

public class RSAUtil {
    private RSAUtil() {
    }

    public static String encryptSegmentByPublicKey(String dataStr, String key) throws Exception {
        byte[] data = dataStr.getBytes("UTF-8");
        byte[] keyBytes = RSAUtil.decryptBASE64(key);
        X509EncodedKeySpec x509KeySpec = new X509EncodedKeySpec(keyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        PublicKey publicKey = keyFactory.generatePublic(x509KeySpec);
        Cipher cipher = Cipher.getInstance(keyFactory.getAlgorithm());
        cipher.init(1, publicKey);
        int inputLen = data.length;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int offSet = 0;
        int i = 0;
        while (inputLen - offSet > 0) {
            byte[] cache = inputLen - offSet > 117 ? cipher.doFinal(data, offSet, 117) : cipher.doFinal(data, offSet, inputLen - offSet);
            out.write(cache, 0, cache.length);
            offSet = ++i * 117;
        }
        byte[] encryptData = out.toByteArray();
        out.close();
        String encryptStr = CipherUtil.encryptBASE64(encryptData);
        return encryptStr;
    }

    public static String decryptSegmentByPublicKey(String dataStr, String key) throws Exception {
        byte[] signByte = CipherUtil.decryptBASE64(dataStr);
        byte[] keyBytes = RSAUtil.decryptBASE64(key);
        X509EncodedKeySpec x509KeySpec = new X509EncodedKeySpec(keyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        PublicKey publicKey = keyFactory.generatePublic(x509KeySpec);
        Cipher cipher = Cipher.getInstance(keyFactory.getAlgorithm());
        cipher.init(2, publicKey);
        int inputLen = signByte.length;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int offSet = 0;
        int i = 0;
        while (inputLen - offSet > 0) {
            byte[] cache = inputLen - offSet > 128 ? cipher.doFinal(signByte, offSet, 128) : cipher.doFinal(signByte, offSet, inputLen - offSet);
            out.write(cache, 0, cache.length);
            offSet = ++i * 128;
        }
        byte[] decryptedData = out.toByteArray();
        out.close();
        return new String(decryptedData, "UTF-8");
    }

    public static byte[] decryptBASE64(String dataStr) throws Exception {
        Base64.Decoder decoder = Base64.getDecoder();
        return decoder.decode(dataStr);
    }
}

