/*
 * Decompiled with CFR 0.152.
 */
package com.els.framework.poi.excel.export.base;

import com.els.framework.poi.excel.entity.enmus.ExcelType;
import com.els.framework.poi.excel.entity.params.ExcelExportEntity;
import com.els.framework.poi.excel.export.base.ExportBase;
import com.els.framework.poi.excel.export.styler.IExcelExportStyler;
import com.els.framework.poi.util.PoiMergeCellUtil;
import com.els.framework.poi.util.PoiPublicUtil;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.imageio.ImageIO;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFClientAnchor;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.Drawing;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFClientAnchor;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ExcelExportBase
extends ExportBase {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExcelExportBase.class);
    private int currentIndex = 0;
    protected ExcelType type = ExcelType.HSSF;
    private Map<Integer, Double> statistics = new HashMap<Integer, Double>();
    private static final DecimalFormat DOUBLE_FORMAT = new DecimalFormat("######0.00");
    private IExcelExportStyler excelExportStyler;

    public int createCells(Drawing patriarch, int index, Object t, List<ExcelExportEntity> excelParams, Sheet sheet, Workbook workbook, short rowHeight) throws Exception {
        ExcelExportEntity entity;
        int k;
        Row row = sheet.createRow(index);
        row.setHeight(rowHeight);
        int maxHeight = 1;
        int cellNum = 0;
        int indexKey = this.createIndexCell(row, index, excelParams.get(0));
        cellNum += indexKey;
        int paramSize = excelParams.size();
        for (k = indexKey; k < paramSize; ++k) {
            entity = excelParams.get(k);
            if (entity.getList() != null) {
                Collection<?> list = this.getListCellValue(entity, t);
                int listC = 0;
                if (null == list) continue;
                for (Object obj : list) {
                    this.createListCells(patriarch, index + listC, cellNum, obj, entity.getList(), sheet, workbook);
                    ++listC;
                }
                cellNum += entity.getList().size();
                if (list.size() <= maxHeight) continue;
                maxHeight = list.size();
                continue;
            }
            Object value = this.getCellValue(entity, t);
            if (entity.getType() == 1) {
                this.createStringCell(row, cellNum++, value == null ? "" : value.toString(), index % 2 == 0 ? this.getStyles(false, entity) : this.getStyles(true, entity), entity);
                continue;
            }
            if (entity.getType() == 4) {
                this.createNumericCell(row, cellNum++, value == null ? "" : value.toString(), index % 2 == 0 ? this.getStyles(false, entity) : this.getStyles(true, entity), entity);
                continue;
            }
            this.createImageCell(patriarch, entity, row, cellNum++, value == null ? "" : value.toString(), t);
        }
        cellNum = 0;
        paramSize = excelParams.size();
        for (k = indexKey; k < paramSize; ++k) {
            entity = excelParams.get(k);
            if (entity.getList() != null) {
                cellNum += entity.getList().size();
                continue;
            }
            if (!entity.isNeedMerge()) continue;
            for (int i = index + 1; i < index + maxHeight; ++i) {
                sheet.getRow(i).createCell(cellNum);
                sheet.getRow(i).getCell(cellNum).setCellStyle(this.getStyles(false, entity));
            }
            sheet.addMergedRegion(new CellRangeAddress(index, index + maxHeight - 1, cellNum, cellNum));
            ++cellNum;
        }
        return maxHeight;
    }

    public void createImageCell(Drawing patriarch, ExcelExportEntity entity, Row row, int i, String imagePath, Object obj) throws Exception {
        row.setHeight((short)(50.0 * entity.getHeight()));
        row.createCell(i);
        Object anchor = this.type.equals((Object)ExcelType.HSSF) ? new HSSFClientAnchor(0, 0, 0, 0, (short)i, row.getRowNum(), (short)(i + 1), row.getRowNum() + 1) : new XSSFClientAnchor(0, 0, 0, 0, (int)((short)i), row.getRowNum(), (int)((short)(i + 1)), row.getRowNum() + 1);
        if (StringUtils.isEmpty((String)imagePath)) {
            return;
        }
        if (entity.getExportImageType() == 1) {
            ByteArrayOutputStream byteArrayOut = new ByteArrayOutputStream();
            try {
                String path = PoiPublicUtil.getWebRootPath(imagePath);
                LOGGER.debug("--- createImageCell getWebRootPath ----filePath--- " + path);
                path = path.replace("WEB-INF/classes/", "");
                path = path.replace("file:/", "");
                BufferedImage bufferImg = ImageIO.read(new File(path));
                ImageIO.write((RenderedImage)bufferImg, imagePath.substring(imagePath.indexOf(".") + 1, imagePath.length()), byteArrayOut);
                byte[] value = byteArrayOut.toByteArray();
                patriarch.createPicture((ClientAnchor)anchor, row.getSheet().getWorkbook().addPicture(value, this.getImageType(value)));
            }
            catch (IOException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
        } else {
            byte[] value = (byte[])(entity.getMethods() != null ? this.getFieldBySomeMethod(entity.getMethods(), obj) : entity.getMethod().invoke(obj, new Object[0]));
            if (value != null) {
                patriarch.createPicture((ClientAnchor)anchor, row.getSheet().getWorkbook().addPicture(value, this.getImageType(value)));
            }
        }
    }

    private int createIndexCell(Row row, int index, ExcelExportEntity excelExportEntity) {
        if (excelExportEntity.getName().equals("\u5e8f\u53f7") && excelExportEntity.getFormat().equals("isAddIndex")) {
            this.createStringCell(row, 0, this.currentIndex + "", index % 2 == 0 ? this.getStyles(false, null) : this.getStyles(true, null), null);
            ++this.currentIndex;
            return 1;
        }
        return 0;
    }

    public void createListCells(Drawing patriarch, int index, int cellNum, Object obj, List<ExcelExportEntity> excelParams, Sheet sheet, Workbook workbook) throws Exception {
        Row row;
        if (sheet.getRow(index) == null) {
            row = sheet.createRow(index);
            row.setHeight(this.getRowHeight(excelParams));
        } else {
            row = sheet.getRow(index);
        }
        int paramSize = excelParams.size();
        for (int k = 0; k < paramSize; ++k) {
            ExcelExportEntity entity = excelParams.get(k);
            Object value = this.getCellValue(entity, obj);
            if (entity.getType() == 1) {
                this.createStringCell(row, cellNum++, value == null ? "" : value.toString(), row.getRowNum() % 2 == 0 ? this.getStyles(false, entity) : this.getStyles(true, entity), entity);
                continue;
            }
            if (entity.getType() == 4) {
                this.createNumericCell(row, cellNum++, value == null ? "" : value.toString(), index % 2 == 0 ? this.getStyles(false, entity) : this.getStyles(true, entity), entity);
                continue;
            }
            this.createImageCell(patriarch, entity, row, cellNum++, value == null ? "" : value.toString(), obj);
        }
    }

    public void createNumericCell(Row row, int index, String text, CellStyle style, ExcelExportEntity entity) {
        Cell cell = row.createCell(index);
        if (StringUtils.isEmpty((String)text)) {
            cell.setCellValue("");
            cell.setCellType(CellType.STRING);
        } else {
            cell.setCellValue(Double.parseDouble(text));
            cell.setCellType(CellType.STRING);
        }
        if (style != null) {
            cell.setCellStyle(style);
        }
        this.addStatisticsData(index, text, entity);
    }

    public void createStringCell(Row row, int index, String text, CellStyle style, ExcelExportEntity entity) {
        Cell cell = row.createCell(index);
        if (style != null && style.getDataFormat() > 0 && style.getDataFormat() < 12) {
            cell.setCellValue(Double.parseDouble(text));
            cell.setCellType(CellType.STRING);
        } else {
            Object rText = this.type.equals((Object)ExcelType.HSSF) ? new HSSFRichTextString(text) : new XSSFRichTextString(text);
            cell.setCellValue((RichTextString)rText);
        }
        if (style != null) {
            cell.setCellStyle(style);
        }
        this.addStatisticsData(index, text, entity);
    }

    public void addStatisticsRow(CellStyle styles, Sheet sheet) {
        if (this.statistics.size() > 0) {
            Row row = sheet.createRow(sheet.getLastRowNum() + 1);
            Set<Integer> keys = this.statistics.keySet();
            this.createStringCell(row, 0, "\u5408\u8ba1", styles, null);
            for (Integer key : keys) {
                this.createStringCell(row, key, DOUBLE_FORMAT.format(this.statistics.get(key)), styles, null);
            }
            this.statistics.clear();
        }
    }

    private void addStatisticsData(Integer index, String text, ExcelExportEntity entity) {
        if (entity != null && entity.isStatistics()) {
            Double temp = 0.0;
            if (!this.statistics.containsKey(index)) {
                this.statistics.put(index, temp);
            }
            try {
                temp = Double.valueOf(text);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            this.statistics.put(index, this.statistics.get(index) + temp);
        }
    }

    public int getFieldWidth(List<ExcelExportEntity> excelParams) {
        int length = -1;
        for (ExcelExportEntity entity : excelParams) {
            length += entity.getList() != null ? entity.getList().size() : 1;
        }
        return length;
    }

    public int getImageType(byte[] value) {
        String type = PoiPublicUtil.getFileExtendName(value);
        if (type.equalsIgnoreCase("JPG")) {
            return 5;
        }
        if (type.equalsIgnoreCase("PNG")) {
            return 6;
        }
        return 5;
    }

    private Map<Integer, int[]> getMergeDataMap(List<ExcelExportEntity> excelParams) {
        HashMap<Integer, int[]> mergeMap = new HashMap<Integer, int[]>();
        int i = 0;
        for (ExcelExportEntity entity : excelParams) {
            if (entity.isMergeVertical()) {
                mergeMap.put(i, entity.getMergeRely());
            }
            if (entity.getList() != null) {
                for (ExcelExportEntity inner : entity.getList()) {
                    if (!inner.isMergeVertical()) continue;
                    mergeMap.put(i, inner.getMergeRely());
                }
                ++i;
                continue;
            }
            ++i;
        }
        return mergeMap;
    }

    public CellStyle getStyles(boolean needOne, ExcelExportEntity entity) {
        return this.excelExportStyler.getStyles(needOne, entity);
    }

    public void mergeCells(Sheet sheet, List<ExcelExportEntity> excelParams, int titleHeight) {
        Map<Integer, int[]> mergeMap = this.getMergeDataMap(excelParams);
        PoiMergeCellUtil.mergeCells(sheet, mergeMap, titleHeight);
    }

    public void setCellWith(List<ExcelExportEntity> excelParams, Sheet sheet) {
        int index = 0;
        for (int i = 0; i < excelParams.size(); ++i) {
            if (excelParams.get(i).getList() != null) {
                List<ExcelExportEntity> list = excelParams.get(i).getList();
                for (int j = 0; j < list.size(); ++j) {
                    sheet.setColumnWidth(index, (int)(256.0 * list.get(j).getWidth()));
                    ++index;
                }
                continue;
            }
            sheet.setColumnWidth(index, (int)(256.0 * excelParams.get(i).getWidth()));
            ++index;
        }
    }

    public void setCurrentIndex(int currentIndex) {
        this.currentIndex = currentIndex;
    }

    public void setExcelExportStyler(IExcelExportStyler excelExportStyler) {
        this.excelExportStyler = excelExportStyler;
    }

    public IExcelExportStyler getExcelExportStyler() {
        return this.excelExportStyler;
    }
}

