/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.message.handle.impl;

import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.URLUtil;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSONObject;
import com.els.common.system.util.ThirdTokenUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.config.JustAuthConfig;
import com.els.config.StaticConfig;
import com.els.modules.message.entity.ElsMsgConfigItem;
import com.els.modules.message.handle.impl.AbstractSendMsgImpl;
import com.els.modules.message.util.TemplateParseUtil;
import com.els.modules.message.vo.MsgVO;
import com.els.modules.system.entity.ElsSubAccount;
import com.els.modules.system.entity.ThirdAccount;
import com.els.modules.system.service.ThirdAccountService;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WxEnterpriseSendMsgImpl
extends AbstractSendMsgImpl {
    private static final Logger log = LoggerFactory.getLogger(WxEnterpriseSendMsgImpl.class);
    private static final String WECHAT_EP_SEND_MSG_URL = "https://qyapi.weixin.qq.com/cgi-bin/message/send";
    private static final String WECHAT_EP_OAUTH2_URL = "/els/system/thirdLogin/render/wechat_enterprise_web";

    @Override
    public void doSendMsg(MsgVO msg) {
        log.info("enter into WxEnterpriseSendMsgImpl.doSendMsg");
        try {
            ElsMsgConfigItem item = msg.getElsMsgConfigItem();
            ElsSubAccount account = msg.getAccount();
            ThirdAccountService thirdAccountService = SpringContextUtils.getBean(ThirdAccountService.class);
            List<ThirdAccount> list = thirdAccountService.getThirdAccount(account.getId(), "wechat_enterprise");
            if (list.isEmpty()) {
                log.error("receive not bind wechat_enterprise");
                return;
            }
            String urlString = "https://qyapi.weixin.qq.com/cgi-bin/message/send?access_token=" + ThirdTokenUtil.getWechatEpToken();
            Map<String, String> type = SpringContextUtils.getBean(JustAuthConfig.class).getType();
            String agentId = type.get("WECHAT_ENTERPRISE.agent-id");
            JSONObject body = new JSONObject();
            body.put("msgtype", (Object)"textcard");
            body.put("agentid", (Object)agentId);
            JSONObject textcard = new JSONObject();
            textcard.put("btntxt", (Object)"");
            textcard.put("title", (Object)item.getMsgTitle());
            textcard.put("url", (Object)this.getUrl(item.getLinkUrl() + this.getConcat(item.getLinkUrl()) + msg.getUrlParam()));
            if (StrUtil.isNotBlank((CharSequence)item.getMsgContent()) && msg.getParams() != null) {
                JSONObject object = SysUtil.objectToJSON(msg.getParams());
                String msgContent = TemplateParseUtil.getTemplateText("", item.getMsgContent(), (Map<String, Object>)object);
                textcard.put("description", (Object)msgContent);
            }
            body.put("textcard", (Object)textcard);
            for (ThirdAccount thirdAccount : list) {
                body.put("touser", (Object)thirdAccount.getThirdUserUuid());
                log.info("send_msgBody:" + body.toString());
                String result = HttpUtil.post((String)urlString, (String)body.toString());
                log.info("sendMsg_result:" + result);
            }
        }
        catch (Exception e) {
            log.error("WxEnterpriseSendMsgImpl.doSendMsg failed:", (Throwable)e);
        }
    }

    private String getConcat(String url) {
        if (StrUtil.isBlank((CharSequence)url)) {
            return "?";
        }
        return url.indexOf("?") > -1 ? "&" : "?";
    }

    private String getUrl(String urlParam) {
        String routeUri = URLUtil.encodeAll((String)urlParam);
        StringBuilder url = new StringBuilder(SpringContextUtils.getBean(StaticConfig.class).getServiceAddress());
        url.append(WECHAT_EP_OAUTH2_URL).append("?routeUri=").append(routeUri);
        return url.toString();
    }

    public static void main(String[] args) {
        String token = "https://api.weixin.qq.com/cgi-bin/message/template/send?access_token=46_cdvi4kKxG51o5_ao4LYEVUKSrVEJ2tKBwrgKE688wb6NOaXJuSyH4AJzZmdAHZ_CepbFFpP6AjmiPXQBDMuh50-zESXmm5E28EcH5q5_YJJwXXFyuUuCs-7sjmW5Ydt9BBB_1U2Ztcd4CCgkIOTfABACIN";
        String body = "{\r\n           \"touser\":\"oCQZC6GSLuribL-Ez_WK_Qz4o4XU\",\r\n           \"template_id\":\"TrCHKlWNdYk8_4v-T1ovVbi1t4IOC9guBrj84diJpyo\",\r\n           \"url\":\"http://v5sit.51qqt.com/user/login\",           \r\n           \"data\":{\r\n           \t\"number\": {\r\n                       \"value\":\"aaa\",\r\n                       \"color\":\"#173177\"\r\n                   }\r\n           }\r\n}";
        HttpUtil.post((String)token, (String)body);
    }
}

