/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.message.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.els.common.util.SysUtil;
import com.els.modules.message.entity.ElsMsgConfigHead;
import com.els.modules.message.entity.ElsMsgConfigItem;
import com.els.modules.message.mapper.ElsMsgConfigHeadMapper;
import com.els.modules.message.mapper.ElsMsgConfigItemMapper;
import com.els.modules.message.service.ElsMsgConfigHeadService;
import java.io.Serializable;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ElsMsgConfigHeadServiceImpl
extends ServiceImpl<ElsMsgConfigHeadMapper, ElsMsgConfigHead>
implements ElsMsgConfigHeadService {
    @Autowired
    private ElsMsgConfigHeadMapper elsMsgConfigHeadMapper;
    @Autowired
    private ElsMsgConfigItemMapper elsMsgConfigItemMapper;

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void saveMain(ElsMsgConfigHead elsMsgConfigHead, List<ElsMsgConfigItem> elsMsgConfigItemList) {
        this.elsMsgConfigHeadMapper.insert(elsMsgConfigHead);
        this.insertData(elsMsgConfigHead, elsMsgConfigItemList);
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void updateMain(ElsMsgConfigHead elsMsgConfigHead, List<ElsMsgConfigItem> elsMsgConfigItemList) {
        this.elsMsgConfigHeadMapper.updateById(elsMsgConfigHead);
        this.elsMsgConfigItemMapper.deleteByMainId(elsMsgConfigHead.getId());
        this.insertData(elsMsgConfigHead, elsMsgConfigItemList);
    }

    private void insertData(ElsMsgConfigHead elsMsgConfigHead, List<ElsMsgConfigItem> elsMsgConfigItemList) {
        for (ElsMsgConfigItem entity : elsMsgConfigItemList) {
            entity.setHeadId(elsMsgConfigHead.getId());
            SysUtil.setSysParam(entity, elsMsgConfigHead);
        }
        if (!elsMsgConfigItemList.isEmpty()) {
            this.elsMsgConfigItemMapper.insertBatchSomeColumn(elsMsgConfigItemList);
        }
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void delMain(String id) {
        this.elsMsgConfigItemMapper.deleteByMainId(id);
        this.elsMsgConfigHeadMapper.deleteById((Serializable)((Object)id));
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void delBatchMain(List<String> idList) {
        for (Serializable serializable : idList) {
            this.elsMsgConfigItemMapper.deleteByMainId(serializable.toString());
            this.elsMsgConfigHeadMapper.deleteById(serializable);
        }
    }

    @Override
    public List<ElsMsgConfigHead> getByOperation(String elsAccount, String businessType, String operation) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"business_type", (Object)businessType);
        queryWrapper.eq((Object)"operate_type", (Object)operation);
        queryWrapper.eq((Object)"els_account", (Object)elsAccount);
        List configHeadList = ((ElsMsgConfigHeadMapper)this.baseMapper).selectList((Wrapper)queryWrapper);
        if (configHeadList.isEmpty()) {
            queryWrapper.clear();
            queryWrapper.eq((Object)"business_type", (Object)businessType);
            queryWrapper.eq((Object)"operate_type", (Object)operation);
            queryWrapper.eq((Object)"els_account", (Object)"100000");
            configHeadList = ((ElsMsgConfigHeadMapper)this.baseMapper).selectList((Wrapper)queryWrapper);
        }
        return configHeadList;
    }
}

