/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.message.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.query.QueryGenerator;
import com.els.common.system.vo.LoginUser;
import com.els.config.mybatis.TenantContext;
import com.els.framework.poi.excel.ExcelImportUtil;
import com.els.framework.poi.excel.entity.ExportParams;
import com.els.framework.poi.excel.entity.ImportParams;
import com.els.framework.poi.excel.view.ELSEntityExcelView;
import com.els.modules.message.entity.ElsMsgConfigHead;
import com.els.modules.message.entity.ElsMsgConfigItem;
import com.els.modules.message.service.ElsMsgConfigHeadService;
import com.els.modules.message.service.ElsMsgConfigItemService;
import com.els.modules.message.vo.ElsMsgConfigHeadVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.shiro.SecurityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;

@RestController
@RequestMapping(value={"/message/elsMsgConfigHead"})
@Api(tags={"\u6d88\u606f\u914d\u7f6e\u5934"})
public class ElsMsgConfigHeadController
extends BaseController<ElsMsgConfigHead, ElsMsgConfigHeadService> {
    private static final Logger log = LoggerFactory.getLogger(ElsMsgConfigHeadController.class);
    @Autowired
    private ElsMsgConfigHeadService elsMsgConfigHeadService;
    @Autowired
    private ElsMsgConfigItemService elsMsgConfigItemService;

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    public Result<?> queryPageList(ElsMsgConfigHead elsMsgConfigHead, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper<ElsMsgConfigHead> queryWrapper = QueryGenerator.initQueryWrapper(elsMsgConfigHead, req.getParameterMap());
        queryWrapper.eq((Object)"els_account", (Object)TenantContext.getTenant());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.elsMsgConfigHeadService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok(pageList);
    }

    @ApiOperation(value="\u7cfb\u7edf\u7ea7\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u7cfb\u7edf\u7ea7\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/sysList"})
    public Result<?> querySysPageList(ElsMsgConfigHead elsMsgConfigHead, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper<ElsMsgConfigHead> queryWrapper = QueryGenerator.initQueryWrapper(elsMsgConfigHead, req.getParameterMap());
        queryWrapper.eq((Object)"els_account", (Object)"100000");
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.elsMsgConfigHeadService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok(pageList);
    }

    @AutoLog(value="\u6d88\u606f\u914d\u7f6e\u5934-\u6dfb\u52a0", logType=2, operateType=2)
    @ApiOperation(value="\u6dfb\u52a0", notes="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    public Result<?> add(@RequestBody ElsMsgConfigHeadVO elsMsgConfigHeadPage) {
        ElsMsgConfigHead elsMsgConfigHead = new ElsMsgConfigHead();
        BeanUtils.copyProperties((Object)elsMsgConfigHeadPage, (Object)elsMsgConfigHead);
        this.elsMsgConfigHeadService.saveMain(elsMsgConfigHead, elsMsgConfigHeadPage.getElsMsgConfigItemList());
        return Result.ok(elsMsgConfigHead);
    }

    @AutoLog(value="\u6d88\u606f\u914d\u7f6e\u5934-\u7f16\u8f91", logType=2, operateType=3)
    @ApiOperation(value="\u7f16\u8f91", notes="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    public Result<?> edit(@RequestBody ElsMsgConfigHeadVO elsMsgConfigHeadPage) {
        ElsMsgConfigHead elsMsgConfigHead = new ElsMsgConfigHead();
        BeanUtils.copyProperties((Object)elsMsgConfigHeadPage, (Object)elsMsgConfigHead);
        this.elsMsgConfigHeadService.updateMain(elsMsgConfigHead, elsMsgConfigHeadPage.getElsMsgConfigItemList());
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u6d88\u606f\u914d\u7f6e\u5934-\u901a\u8fc7id\u5220\u9664", logType=2, operateType=4)
    @ApiOperation(value="\u901a\u8fc7id\u5220\u9664", notes="\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    public Result<?> delete(@RequestParam(name="id", required=true) String id) {
        this.elsMsgConfigHeadService.delMain(id);
        return this.commonSuccessResult(4);
    }

    @AutoLog(value="\u6d88\u606f\u914d\u7f6e\u5934-\u6279\u91cf\u5220\u9664", logType=2, operateType=4)
    @ApiOperation(value="\u6279\u91cf\u5220\u9664", notes="\u6279\u91cf\u5220\u9664")
    @GetMapping(value={"/deleteBatch"})
    public Result<?> deleteBatch(@RequestParam(name="ids", required=true) String ids) {
        this.elsMsgConfigHeadService.delBatchMain(Arrays.asList(ids.split(",")));
        return this.commonSuccessResult(4);
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2", notes="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    public Result<?> queryById(@RequestParam(name="id", required=true) String id) {
        ElsMsgConfigHead elsMsgConfigHead = (ElsMsgConfigHead)this.elsMsgConfigHeadService.getById((Serializable)((Object)id));
        ElsMsgConfigHeadVO elsMsgConfigHeadVO = new ElsMsgConfigHeadVO();
        BeanUtils.copyProperties((Object)elsMsgConfigHead, (Object)elsMsgConfigHeadVO);
        List<ElsMsgConfigItem> elsMsgConfigItemList = this.elsMsgConfigItemService.selectByMainId(id);
        elsMsgConfigHeadVO.setElsMsgConfigItemList(elsMsgConfigItemList);
        return Result.ok(elsMsgConfigHeadVO);
    }

    @ApiOperation(value="\u901a\u8fc7\u6d88\u606f\u914d\u7f6e\u5934id\u67e5\u8be2\u6d88\u606f\u914d\u7f6e\u884c", notes="\u901a\u8fc7\u6d88\u606f\u914d\u7f6e\u5934id\u67e5\u8be2\u6d88\u606f\u914d\u7f6e\u884c")
    @GetMapping(value={"/queryElsMsgConfigItemByMainId"})
    public Result<?> queryElsMsgConfigItemListByMainId(@RequestParam(name="id", required=true) String id) {
        List<ElsMsgConfigItem> elsMsgConfigItemList = this.elsMsgConfigItemService.selectByMainId(id);
        return Result.ok(elsMsgConfigItemList);
    }

    @AutoLog(value="\u6d88\u606f\u914d\u7f6e\u5934-\u5bfc\u51faExcel", logType=2, operateType=6)
    @GetMapping(value={"/exportXls"})
    public ModelAndView exportXls(HttpServletRequest request, ElsMsgConfigHead elsMsgConfigHead) {
        QueryWrapper<ElsMsgConfigHead> queryWrapper = QueryGenerator.initQueryWrapper(elsMsgConfigHead, request.getParameterMap());
        LoginUser sysUser = (LoginUser)SecurityUtils.getSubject().getPrincipal();
        ArrayList<ElsMsgConfigHeadVO> pageList = new ArrayList<ElsMsgConfigHeadVO>();
        List elsMsgConfigHeadList = this.elsMsgConfigHeadService.list((Wrapper)queryWrapper);
        for (ElsMsgConfigHead temp : elsMsgConfigHeadList) {
            ElsMsgConfigHeadVO vo = new ElsMsgConfigHeadVO();
            BeanUtils.copyProperties((Object)temp, (Object)vo);
            List<ElsMsgConfigItem> elsMsgConfigItemList = this.elsMsgConfigItemService.selectByMainId(temp.getId());
            vo.setElsMsgConfigItemList(elsMsgConfigItemList);
            pageList.add(vo);
        }
        ModelAndView mv = new ModelAndView((View)new ELSEntityExcelView());
        mv.addObject("fileName", (Object)"\u6d88\u606f\u914d\u7f6e\u5934");
        mv.addObject("entity", ElsMsgConfigHeadVO.class);
        mv.addObject("params", (Object)new ExportParams("\u6d88\u606f\u914d\u7f6e\u5934\u6570\u636e", "\u5bfc\u51fa\u4eba:" + sysUser.getRealname(), "\u6d88\u606f\u914d\u7f6e\u5934", request.getParameter("defineColumnCode")));
        mv.addObject("data", pageList);
        return mv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AutoLog(value="\u6d88\u606f\u914d\u7f6e\u5934-\u5bfc\u5165Excel", logType=2, operateType=5)
    @PostMapping(value={"/importExcel"})
    public Result<?> importExcel(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        Iterator iterator = fileMap.entrySet().iterator();
        if (iterator.hasNext()) {
            Map.Entry entity = iterator.next();
            MultipartFile file = (MultipartFile)entity.getValue();
            ImportParams params = new ImportParams();
            params.setTitleRows(2);
            params.setHeadRows(1);
            params.setNeedSave(true);
            try {
                List<ElsMsgConfigHeadVO> list = ExcelImportUtil.importExcel(file.getInputStream(), ElsMsgConfigHeadVO.class, params);
                for (ElsMsgConfigHeadVO page : list) {
                    ElsMsgConfigHead po = new ElsMsgConfigHead();
                    BeanUtils.copyProperties((Object)page, (Object)po);
                    this.elsMsgConfigHeadService.saveMain(po, page.getElsMsgConfigItemList());
                }
                Result<Object> result = Result.ok("\u6587\u4ef6\u5bfc\u5165\u6210\u529f\uff01\u6570\u636e\u884c\u6570:" + list.size());
                return result;
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                Result<Object> result = Result.error("\u6587\u4ef6\u5bfc\u5165\u5931\u8d25:" + e.getMessage());
                return result;
            }
            finally {
                try {
                    file.getInputStream().close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return Result.error("\u6587\u4ef6\u5bfc\u5165\u5931\u8d25\uff01");
    }
}

