/*
 * Decompiled with CFR 0.152.
 */
package com.els.config.mybatis;

import cn.hutool.core.util.StrUtil;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.ConvertUtils;
import com.els.config.mybatis.TenantContext;
import java.lang.reflect.Field;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import org.apache.ibatis.binding.MapperMethod;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.shiro.SecurityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@Intercepts(value={@Signature(type=Executor.class, method="update", args={MappedStatement.class, Object.class})})
public class MybatisInterceptor
implements Interceptor {
    private static final Logger log = LoggerFactory.getLogger(MybatisInterceptor.class);

    public Object intercept(Invocation invocation) throws Throwable {
        MappedStatement mappedStatement = (MappedStatement)invocation.getArgs()[0];
        SqlCommandType sqlCommandType = mappedStatement.getSqlCommandType();
        Object parameter = invocation.getArgs()[1];
        if (parameter != null) {
            Field[] fields;
            if (SqlCommandType.INSERT == sqlCommandType) {
                Map map;
                if (parameter instanceof Map && (map = (Map)parameter).containsKey("list")) {
                    return invocation.proceed();
                }
                fields = ConvertUtils.getAllFields(parameter);
                this.setInsertFields(fields, parameter);
            }
            if (SqlCommandType.UPDATE == sqlCommandType) {
                MapperMethod.ParamMap p;
                if (parameter instanceof MapperMethod.ParamMap && (parameter = (p = (MapperMethod.ParamMap)parameter).containsKey((Object)"et") ? p.get((Object)"et") : (p.containsKey((Object)"param1") ? p.get((Object)"param1") : null)) == null) {
                    return invocation.proceed();
                }
                fields = ConvertUtils.getAllFields(parameter);
                this.setUpdateFields(fields, parameter);
            }
        }
        return invocation.proceed();
    }

    private void setInsertFields(Field[] fields, Object parameter) {
        LoginUser sysUser = this.getLoginUser();
        boolean injectionEls = this.getInjectionEls(fields, parameter);
        for (Field field : fields) {
            log.debug("------field.name------" + field.getName());
            try {
                String sysOrgCode;
                if ("elsAccount".equals(field.getName())) {
                    this.injectionElsAccount(field, parameter, injectionEls);
                }
                if ("createBy".equals(field.getName()) || "updateBy".equals(field.getName())) {
                    field.setAccessible(true);
                    Object local_by = field.get(parameter);
                    field.setAccessible(false);
                    if (local_by == null || local_by.equals("")) {
                        String by;
                        String string = by = sysUser == null ? "els" : sysUser.getSubAccount();
                        if (ConvertUtils.isNotEmpty(by)) {
                            field.setAccessible(true);
                            field.set(parameter, by);
                            field.setAccessible(false);
                        }
                    }
                }
                if ("createTime".equals(field.getName()) || "updateTime".equals(field.getName())) {
                    field.setAccessible(true);
                    Object local_date = field.get(parameter);
                    field.setAccessible(false);
                    if (local_date == null || local_date.equals("")) {
                        field.setAccessible(true);
                        field.set(parameter, new Date());
                        field.setAccessible(false);
                    }
                }
                if (!"sysOrgCode".equals(field.getName())) continue;
                field.setAccessible(true);
                Object local_sysOrgCode = field.get(parameter);
                field.setAccessible(false);
                if (local_sysOrgCode != null && !local_sysOrgCode.equals("")) continue;
                String string = sysOrgCode = sysUser == null ? "" : sysUser.getOrgCode();
                if (!ConvertUtils.isNotEmpty(sysOrgCode)) continue;
                field.setAccessible(true);
                field.set(parameter, sysOrgCode);
                field.setAccessible(false);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void setUpdateFields(Field[] fields, Object parameter) {
        LoginUser sysUser = this.getLoginUser();
        for (Field field : fields) {
            log.debug("------field.name------" + field.getName());
            try {
                if ("updateBy".equals(field.getName()) && sysUser != null) {
                    String updateBy = sysUser.getSubAccount();
                    field.setAccessible(true);
                    field.set(parameter, updateBy);
                    field.setAccessible(false);
                }
                if (!"updateTime".equals(field.getName())) continue;
                field.setAccessible(true);
                field.set(parameter, new Date());
                field.setAccessible(false);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private LoginUser getLoginUser() {
        try {
            return (LoginUser)SecurityUtils.getSubject().getPrincipal();
        }
        catch (Exception e) {
            return null;
        }
    }

    private void injectionElsAccount(Field field, Object parameter, boolean injectionEls) throws IllegalAccessException {
        field.setAccessible(true);
        Object local_elsAccount = field.get(parameter);
        field.setAccessible(false);
        if (injectionEls && (local_elsAccount == null || local_elsAccount.equals(""))) {
            String elsAccount;
            String string = elsAccount = StrUtil.isNotBlank((CharSequence)TenantContext.getTenant()) ? TenantContext.getTenant() : "100000";
            if (ConvertUtils.isNotEmpty(elsAccount)) {
                field.setAccessible(true);
                field.set(parameter, elsAccount);
                field.setAccessible(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean getInjectionEls(Field[] fields, Object parameter) {
        for (Field field : fields) {
            if (!"injectionEls".equals(field.getName())) continue;
            try {
                field.setAccessible(true);
                boolean bl = (Boolean)field.get(parameter);
                return bl;
            }
            catch (IllegalAccessException e) {
                boolean bl = true;
                return bl;
            }
            finally {
                field.setAccessible(false);
            }
        }
        return true;
    }

    public Object plugin(Object target) {
        return Plugin.wrap((Object)target, (Interceptor)this);
    }

    public void setProperties(Properties properties) {
    }
}

