/*
 * Decompiled with CFR 0.152.
 */
package com.els.common.system.util;

import cn.hutool.core.util.StrUtil;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSONObject;
import com.els.common.exception.ELSBootException;
import com.els.common.util.RedisUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.config.JustAuthConfig;
import com.els.modules.system.util.I18nUtil;
import java.util.Map;

public class ThirdTokenUtil {
    private static final String WECHAT_MP_GET_TOKEN_URL = "https://api.weixin.qq.com/cgi-bin/token?grant_type=client_credential";
    private static final String WECHAT_MP_GET_TOKEN_KEY = "sys:thirdToken:weixin_mp";
    private static final String WECHAT_EP_GET_TOKEN_URL = "https://qyapi.weixin.qq.com/cgi-bin/gettoken";
    private static final String WECHAT_EP_GET_TOKEN_KEY = "sys:thirdToken:weixin_ep";
    private static final String DING_TALK_GET_TOKEN_URL = "https://oapi.dingtalk.com/gettoken";
    private static final String DING_TALK_GET_TOKEN_KEY = "sys:thirdToken:dingtalk";
    private static RedisUtil redisUtil = SpringContextUtils.getBean(RedisUtil.class);

    public static String getWechatMpToken() {
        String token = (String)redisUtil.get(WECHAT_MP_GET_TOKEN_KEY);
        if (StrUtil.isNotBlank((CharSequence)token)) {
            return token;
        }
        Map<String, String> type = SpringContextUtils.getBean(JustAuthConfig.class).getType();
        String appid = type.get("WECHAT_MP.client-id");
        String secret = type.get("WECHAT_MP.client-secret");
        JSONObject object = new JSONObject();
        object.put("appid", (Object)appid);
        object.put("secret", (Object)secret);
        String invokeUrl = "https://api.weixin.qq.com/cgi-bin/token?grant_type=client_credential&" + SysUtil.getUrlParamByJson(object);
        String result = HttpUtil.get((String)invokeUrl);
        JSONObject resultObj = JSONObject.parseObject((String)result);
        if (!resultObj.containsKey((Object)"access_token")) {
            throw new ELSBootException(I18nUtil.translate("", resultObj.getString("errmsg")));
        }
        token = resultObj.getString("access_token");
        int expiresIn = resultObj.getIntValue("expires_in");
        redisUtil.set(WECHAT_MP_GET_TOKEN_KEY, token, expiresIn - 1200);
        return token;
    }

    public static String getWechatEpToken() {
        String token = (String)redisUtil.get(WECHAT_EP_GET_TOKEN_KEY);
        if (StrUtil.isNotBlank((CharSequence)token)) {
            return token;
        }
        Map<String, String> type = SpringContextUtils.getBean(JustAuthConfig.class).getType();
        String appid = type.get("WECHAT_ENTERPRISE.client-id");
        String secret = type.get("WECHAT_ENTERPRISE.client-secret");
        JSONObject object = new JSONObject();
        object.put("corpid", (Object)appid);
        object.put("corpsecret", (Object)secret);
        String invokeUrl = "https://qyapi.weixin.qq.com/cgi-bin/gettoken?" + SysUtil.getUrlParamByJson(object);
        String result = HttpUtil.get((String)invokeUrl);
        JSONObject resultObj = JSONObject.parseObject((String)result);
        if (!resultObj.containsKey((Object)"access_token")) {
            throw new ELSBootException(I18nUtil.translate("", resultObj.getString("errmsg")));
        }
        token = resultObj.getString("access_token");
        int expiresIn = resultObj.getIntValue("expires_in");
        redisUtil.set(WECHAT_EP_GET_TOKEN_KEY, token, (long)expiresIn - 1200L);
        return token;
    }

    public static String getDingtalkToken() {
        String token = (String)redisUtil.get(DING_TALK_GET_TOKEN_KEY);
        if (StrUtil.isNotBlank((CharSequence)token)) {
            return token;
        }
        Map<String, String> type = SpringContextUtils.getBean(JustAuthConfig.class).getType();
        String appid = type.get("DINGTALK.client-id");
        String secret = type.get("DINGTALK.client-secret");
        JSONObject object = new JSONObject();
        object.put("appkey", (Object)appid);
        object.put("appsecret", (Object)secret);
        String invokeUrl = "https://oapi.dingtalk.com/gettoken?" + SysUtil.getUrlParamByJson(object);
        String result = HttpUtil.get((String)invokeUrl);
        JSONObject resultObj = JSONObject.parseObject((String)result);
        if (!resultObj.containsKey((Object)"access_token")) {
            throw new ELSBootException(I18nUtil.translate("", resultObj.getString("errmsg")));
        }
        token = resultObj.getString("access_token");
        int expiresIn = resultObj.getIntValue("expires_in");
        redisUtil.set(DING_TALK_GET_TOKEN_KEY, token, (long)expiresIn - 10L);
        return token;
    }

    public static void main(String[] args) {
        JSONObject object = new JSONObject();
        object.put("appid", (Object)"wx65e0b7fba748919f");
        object.put("secret", (Object)"b37570eb06988bf2c962b382d8aa16a9");
        System.out.println(SysUtil.getUrlParamByJson(object));
    }
}

