/*
 * Decompiled with CFR 0.152.
 */
package com.els.common.util;

import com.alibaba.fastjson.JSONObject;
import com.els.common.api.vo.Result;
import com.els.common.util.RestUtil;
import com.els.common.util.SpringContextUtils;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;

public class RestDesformUtil {
    private static String domain = null;
    private static String path = null;

    public static Result queryOne(String desformCode, String dataId, String token) {
        String url = RestDesformUtil.getBaseUrl(desformCode, dataId).toString();
        HttpHeaders headers = RestDesformUtil.getHeaders(token);
        ResponseEntity<JSONObject> result = RestUtil.request(url, HttpMethod.GET, headers, null, null, JSONObject.class);
        return RestDesformUtil.packageReturn(result);
    }

    public static Result addOne(String desformCode, JSONObject formData, String token) {
        return RestDesformUtil.addOrEditOne(desformCode, formData, token, HttpMethod.POST);
    }

    public static Result editOne(String desformCode, JSONObject formData, String token) {
        return RestDesformUtil.addOrEditOne(desformCode, formData, token, HttpMethod.PUT);
    }

    private static Result addOrEditOne(String desformCode, JSONObject formData, String token, HttpMethod method) {
        String url = RestDesformUtil.getBaseUrl(desformCode).toString();
        HttpHeaders headers = RestDesformUtil.getHeaders(token);
        ResponseEntity<JSONObject> result = RestUtil.request(url, method, headers, null, formData, JSONObject.class);
        return RestDesformUtil.packageReturn(result);
    }

    public static Result removeOne(String desformCode, String dataId, String token) {
        String url = RestDesformUtil.getBaseUrl(desformCode, dataId).toString();
        HttpHeaders headers = RestDesformUtil.getHeaders(token);
        ResponseEntity<JSONObject> result = RestUtil.request(url, HttpMethod.DELETE, headers, null, null, JSONObject.class);
        return RestDesformUtil.packageReturn(result);
    }

    private static Result packageReturn(ResponseEntity<JSONObject> result) {
        if (result.getBody() != null) {
            return (Result)((JSONObject)result.getBody()).toJavaObject(Result.class);
        }
        return Result.error("\u64cd\u4f5c\u5931\u8d25");
    }

    private static StringBuilder getBaseUrl() {
        StringBuilder builder = new StringBuilder(domain).append(path);
        builder.append("/desform/api");
        return builder;
    }

    private static StringBuilder getBaseUrl(String desformCode, String dataId) {
        StringBuilder builder = RestDesformUtil.getBaseUrl();
        builder.append("/").append(desformCode);
        if (dataId != null) {
            builder.append("/").append(dataId);
        }
        return builder;
    }

    private static StringBuilder getBaseUrl(String desformCode) {
        return RestDesformUtil.getBaseUrl(desformCode, null);
    }

    private static HttpHeaders getHeaders(String token) {
        HttpHeaders headers = new HttpHeaders();
        String mediaType = "application/json;charset=UTF-8";
        headers.setContentType(MediaType.parseMediaType((String)mediaType));
        headers.set("Accept", mediaType);
        headers.set("X-Access-Token", token);
        return headers;
    }

    static {
        domain = SpringContextUtils.getDomain();
        path = SpringContextUtils.getApplicationContext().getEnvironment().getProperty("server.servlet.context-path");
    }
}

