/*
 * Decompiled with CFR 0.152.
 */
package com.els.common.util.security;

import cn.hutool.core.codec.Base64Decoder;
import cn.hutool.core.codec.Base64Encoder;
import cn.hutool.crypto.SecureUtil;
import cn.hutool.crypto.asymmetric.KeyType;
import cn.hutool.crypto.asymmetric.RSA;
import cn.hutool.crypto.asymmetric.Sign;
import cn.hutool.crypto.asymmetric.SignAlgorithm;
import cn.hutool.crypto.symmetric.AES;
import cn.hutool.json.JSONObject;
import com.els.common.util.security.entity.MyKeyPair;
import com.els.common.util.security.entity.SecurityReq;
import com.els.common.util.security.entity.SecurityResp;
import com.els.common.util.security.entity.SecuritySignReq;
import com.els.common.util.security.entity.SecuritySignResp;
import java.security.KeyPair;
import javax.crypto.SecretKey;

public class SecurityTools {
    public static final String ALGORITHM = "AES/ECB/PKCS5Padding";

    public static SecurityResp valid(SecurityReq req) {
        SecurityResp resp = new SecurityResp();
        String pubKey = req.getPubKey();
        String aesKey = req.getAesKey();
        String data = req.getData();
        String signData = req.getSignData();
        RSA rsa = new RSA(null, Base64Decoder.decode((CharSequence)pubKey));
        Sign sign = new Sign(SignAlgorithm.SHA1withRSA, null, pubKey);
        byte[] decryptAes = rsa.decrypt(aesKey, KeyType.PublicKey);
        AES aes = SecureUtil.aes((byte[])decryptAes);
        String dencrptValue = aes.decryptStr(data);
        resp.setData(new JSONObject((Object)dencrptValue));
        boolean verify = sign.verify(dencrptValue.getBytes(), Base64Decoder.decode((CharSequence)signData));
        resp.setSuccess(verify);
        return resp;
    }

    public static SecuritySignResp sign(SecuritySignReq req) {
        SecretKey secretKey = SecureUtil.generateKey((String)ALGORITHM);
        byte[] key = secretKey.getEncoded();
        String prikey = req.getPrikey();
        String data = req.getData();
        AES aes = SecureUtil.aes((byte[])key);
        aes.getSecretKey().getEncoded();
        String encrptData = aes.encryptBase64(data);
        RSA rsa = new RSA(prikey, null);
        byte[] encryptAesKey = rsa.encrypt(secretKey.getEncoded(), KeyType.PrivateKey);
        Sign sign = new Sign(SignAlgorithm.SHA1withRSA, prikey, null);
        byte[] signed = sign.sign(data.getBytes());
        SecuritySignResp resp = new SecuritySignResp();
        resp.setAesKey(Base64Encoder.encode((byte[])encryptAesKey));
        resp.setData(encrptData);
        resp.setSignData(Base64Encoder.encode((byte[])signed));
        return resp;
    }

    public static MyKeyPair generateKeyPair() {
        KeyPair keyPair = SecureUtil.generateKeyPair((String)SignAlgorithm.SHA1withRSA.getValue(), (int)2048);
        String priKey = Base64Encoder.encode((byte[])keyPair.getPrivate().getEncoded());
        String pubkey = Base64Encoder.encode((byte[])keyPair.getPublic().getEncoded());
        MyKeyPair resp = new MyKeyPair();
        resp.setPriKey(priKey);
        resp.setPubKey(pubkey);
        return resp;
    }
}

