/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.dashboard.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.els.common.exception.ELSBootException;
import com.els.modules.dashboard.entity.ChartData;
import com.els.modules.dashboard.enums.ChartDataTypeEnum;
import com.els.modules.dashboard.mapper.ChartDataMapper;
import com.els.modules.dashboard.service.ChartDataService;
import com.els.modules.dashboard.vo.ChartDataVO;
import freemarker.cache.StringTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.Template;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class ChartDataServiceImpl
extends ServiceImpl<ChartDataMapper, ChartData>
implements ChartDataService {
    @Override
    public void saveChartData(ChartData chartData) {
        ((ChartDataMapper)this.baseMapper).insert(chartData);
    }

    @Override
    public void updateChartData(ChartData chartData) {
        ((ChartDataMapper)this.baseMapper).updateById(chartData);
    }

    @Override
    public void delChartData(String id) {
        ((ChartDataMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void delBatchChartData(List<String> idList) {
        ((ChartDataMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    public ChartDataVO getDataById(String dataId, Map<String, Object> dataMap) {
        ChartData data = (ChartData)((ChartDataMapper)this.baseMapper).selectById((Serializable)((Object)dataId));
        if (data == null) {
            throw new ELSBootException("\u56fe\u8868\u6570\u636e\u4e0d\u5b58\u5728");
        }
        ChartDataVO dataVO = new ChartDataVO();
        BeanUtils.copyProperties((Object)data, (Object)dataVO);
        Configuration configuration = new Configuration(Configuration.VERSION_2_3_27);
        StringTemplateLoader templateLoader = new StringTemplateLoader();
        configuration.setTemplateLoader((TemplateLoader)templateLoader);
        configuration.setDefaultEncoding("UTF-8");
        StringWriter stringWriter = new StringWriter();
        try {
            Template template = new Template(data.getDataCode(), data.getDataSql(), configuration);
            template.process(dataMap, (Writer)stringWriter);
        }
        catch (Exception e) {
            throw new ELSBootException("sql\u6a21\u677f\u6e32\u67d3\u5931\u8d25", e.getMessage());
        }
        if (ChartDataTypeEnum.NUMBER.getCode().equals(data.getDataType())) {
            dataVO.setResultData(((ChartDataMapper)this.baseMapper).selectCountForXml(stringWriter.toString()));
        } else if (ChartDataTypeEnum.LIST.getCode().equals(data.getDataType())) {
            dataVO.setResultData(((ChartDataMapper)this.baseMapper).selectListForXml(stringWriter.toString()));
        } else if (ChartDataTypeEnum.SINGLE_RECORD.getCode().equals(data.getDataType())) {
            dataVO.setResultData(((ChartDataMapper)this.baseMapper).selectOneForXml(stringWriter.toString()));
        }
        return dataVO;
    }
}

