/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.aspect;

import com.els.common.util.SpringContextUtils;
import com.els.modules.system.util.I18nUtil;
import javax.servlet.http.HttpServletRequest;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class I18nAspect {
    @Pointcut(value="execution(public * com.els.modules..*.*Controller.*(..))")
    public void executeService() {
    }

    @Around(value="executeService()")
    public Object doAround(ProceedingJoinPoint pjp) throws Throwable {
        HttpServletRequest request = SpringContextUtils.getHttpServletRequest();
        String language = request.getHeader("language");
        I18nUtil.setCurrentLanguage(language);
        Object result = pjp.proceed();
        return result;
    }
}

