/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.message.handle.impl;

import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.URLUtil;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSONObject;
import com.els.common.system.util.ThirdTokenUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.config.JustAuthConfig;
import com.els.config.StaticConfig;
import com.els.modules.message.entity.ElsMsgConfigItem;
import com.els.modules.message.handle.impl.AbstractSendMsgImpl;
import com.els.modules.message.util.TemplateParseUtil;
import com.els.modules.message.vo.MsgVO;
import com.els.modules.system.entity.ElsSubAccount;
import com.els.modules.system.entity.ThirdAccount;
import com.els.modules.system.service.ThirdAccountService;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DingtalkSendMsgImpl
extends AbstractSendMsgImpl {
    private static final Logger log = LoggerFactory.getLogger(DingtalkSendMsgImpl.class);
    private static final String DING_TALK_SEND_MSG_URL = "https://oapi.dingtalk.com/topapi/message/corpconversation/asyncsend_v2";
    private static final String DING_TALK_OAUTH2_URL = "/els/system/thirdLogin/render/dingtalk_account";

    @Override
    public void doSendMsg(MsgVO msg) {
        log.info("enter into DingtalkSendMsgImpl.doSendMsg");
        try {
            ElsMsgConfigItem item = msg.getElsMsgConfigItem();
            ElsSubAccount account = msg.getReceiveAccount();
            ThirdAccountService thirdAccountService = SpringContextUtils.getBean(ThirdAccountService.class);
            List<ThirdAccount> list = thirdAccountService.getThirdAccount(account.getId(), "dingtalk");
            if (list.isEmpty()) {
                log.error("receive not bind dingtalk_account");
                return;
            }
            String token = ThirdTokenUtil.getDingtalkToken();
            StringBuilder users = new StringBuilder();
            for (ThirdAccount dto : list) {
                String unionId = dto.getThirdUserUuid();
                String userId = this.getUserIdByUnionId(unionId, token);
                if (!StrUtil.isNotBlank((CharSequence)userId)) continue;
                if (users.length() == 0) {
                    users.append(userId);
                    continue;
                }
                users.append(",").append(userId);
            }
            log.info("dingtalk_receive:" + users);
            String urlString = "https://oapi.dingtalk.com/topapi/message/corpconversation/asyncsend_v2?access_token=" + token;
            Map<String, String> type = SpringContextUtils.getBean(JustAuthConfig.class).getType();
            String agentId = type.get("DINGTALK.agent-id");
            JSONObject body = new JSONObject();
            body.put("agent_id", (Object)agentId);
            body.put("userid_list", (Object)users.toString());
            JSONObject msgObj = new JSONObject();
            msgObj.put("msgtype", (Object)"action_card");
            JSONObject actionCard = new JSONObject();
            actionCard.put("title", (Object)item.getMsgTitle());
            actionCard.put("single_url", (Object)this.getUrl(item.getLinkUrl() + this.getConcat(item.getLinkUrl()) + msg.getUrlParam()));
            actionCard.put("single_title", (Object)"\u8be6\u60c5");
            if (StrUtil.isNotBlank((CharSequence)item.getMsgContent()) && msg.getParams() != null) {
                JSONObject object = SysUtil.objectToJSON(msg.getParams());
                String msgContent = TemplateParseUtil.getTemplateText("", item.getMsgContent(), (Map<String, Object>)object);
                actionCard.put("markdown", (Object)msgContent);
            }
            msgObj.put("action_card", (Object)actionCard);
            body.put("msg", (Object)msgObj);
            log.info("send_dingtalk_msgBody:" + body.toString());
            String result = HttpUtil.post((String)urlString, (String)body.toString());
            log.info("sendMsg_dingtalk_result:" + result);
        }
        catch (Exception e) {
            log.error("DingtalkSendMsgImpl.doSendMsg failed:", (Throwable)e);
        }
    }

    private String getConcat(String url) {
        if (StrUtil.isBlank((CharSequence)url)) {
            return "?";
        }
        return url.contains("?") ? "&" : "?";
    }

    private String getUrl(String urlParam) {
        String routeUri = URLUtil.encodeAll((String)urlParam);
        StringBuilder url = new StringBuilder(SpringContextUtils.getBean(StaticConfig.class).getServiceAddress());
        url.append(DING_TALK_OAUTH2_URL).append("?routeUri=").append(routeUri);
        return url.toString();
    }

    private String getUserIdByUnionId(String unionId, String token) {
        String result = HttpUtil.post((String)("https://oapi.dingtalk.com/topapi/user/getbyunionid?access_token=" + token), (String)("{\"unionid\":\"" + unionId + "\"}"));
        JSONObject resultObj = JSONObject.parseObject((String)result);
        if (resultObj.containsKey((Object)"result")) {
            JSONObject obj = resultObj.getJSONObject("result");
            return obj.getString("userid");
        }
        return null;
    }
}

