/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.aspect;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.IPUtils;
import com.els.common.util.SpringContextUtils;
import com.els.config.mybatis.TenantContext;
import com.els.modules.system.entity.Log;
import com.els.modules.system.service.LogService;
import com.els.modules.system.util.AopElUtils;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.SecurityUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Aspect
@Component
public class AutoLogAspect {
    @Autowired
    private LogService sysLogService;
    private static final String EL = "#";

    @Pointcut(value="@annotation(com.els.common.aspect.annotation.AutoLog)")
    public void logPointCut() {
    }

    @Around(value="logPointCut()")
    public Object around(ProceedingJoinPoint point) throws Throwable {
        long beginTime = System.currentTimeMillis();
        Object result = point.proceed();
        long time = System.currentTimeMillis() - beginTime;
        this.saveSysLog(point, time, result);
        return result;
    }

    private void saveSysLog(ProceedingJoinPoint joinPoint, long time, Object result) {
        Object param;
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        Method method = signature.getMethod();
        Log sysLog = new Log();
        sysLog.setElsAccount(TenantContext.getTenant());
        AutoLog syslog = method.getAnnotation(AutoLog.class);
        if (syslog != null) {
            sysLog.setLogType(syslog.logType());
            String[] values = syslog.value().split("-");
            if (StrUtil.isNotBlank((CharSequence)syslog.busModule())) {
                sysLog.setBusModule(syslog.busModule());
            } else {
                sysLog.setBusModule(values[0]);
            }
            if (values.length > 1) {
                sysLog.setOperateName(values[1]);
            } else if (values.length == 1) {
                sysLog.setOperateName(values[0]);
            }
        } else {
            return;
        }
        Map paramMap = AopElUtils.getParameters(joinPoint);
        EvaluationContext context = AopElUtils.buildContext(joinPoint, paramMap);
        String value = StrUtil.blankToDefault((CharSequence)syslog.value(), (String)"");
        if (value.contains(EL)) {
            String[] split = StrUtil.split((CharSequence)value, (CharSequence)"+");
            StringBuffer sb = new StringBuffer();
            for (String str : split) {
                if (str.startsWith(EL)) {
                    try {
                        Expression sourceEl = AopElUtils.getExpressionByKey(str);
                        sb.append((String)sourceEl.getValue(context, String.class));
                        continue;
                    }
                    catch (Exception sourceEl) {
                        // empty catch block
                    }
                }
                sb.append(str);
            }
            value = sb.toString();
        }
        String className = joinPoint.getTarget().getClass().getName();
        String methodName = signature.getName();
        sysLog.setMethod(className + "." + methodName + "()");
        sysLog.setLogContent(value);
        if (sysLog.getLogType() == 2) {
            sysLog.setOperateType(this.getOperateType(methodName, syslog.operateType()));
        }
        String responseParamStr = null;
        try {
            ObjectMapper mapper = new ObjectMapper();
            responseParamStr = mapper.writeValueAsString(result);
            sysLog.setResponseParam(responseParamStr);
        }
        catch (Exception mapper) {
            // empty catch block
        }
        JSONObject paramObj = null;
        String businessId = null;
        Object[] args = joinPoint.getArgs();
        Object object = param = args.length > 0 ? joinPoint.getArgs()[0] : new Object();
        if (param instanceof BaseEntity) {
            paramObj = this.getJsonByObejct(param);
            businessId = paramObj.getString("id");
            if (StrUtil.isBlank((CharSequence)businessId)) {
                businessId = paramObj.getString("businessId");
            }
            this.saveSysLog(time, method, sysLog, paramMap, responseParamStr, businessId);
        } else if (param instanceof String) {
            businessId = (String)param;
            if (businessId.length() > 20) {
                businessId = null;
            }
            this.saveSysLog(time, method, sysLog, paramMap, responseParamStr, businessId);
        } else if (param instanceof ArrayList) {
            JSONArray params = this.getJsonArrayByObejct(param);
            for (int i = 0; i < params.size(); ++i) {
                JSONObject baseObject = params.getJSONObject(i);
                this.saveSysLog(time, method, sysLog, paramMap, responseParamStr, baseObject.getString("id"));
            }
        }
    }

    private void saveSysLog(long time, Method method, Log sysLog, Map<String, Object> paramMap, String responseParamStr, String businessId) {
        if (StrUtil.isBlank((CharSequence)businessId)) {
            try {
                JSONObject jsonObject = JSONObject.parseObject((String)responseParamStr);
                businessId = jsonObject.getJSONObject("result").getString("id");
            }
            catch (Exception jsonObject) {
                // empty catch block
            }
        }
        sysLog.setBusinessId(businessId);
        try {
            String params = JSONObject.toJSONString(paramMap);
            sysLog.setRequestParam(params);
        }
        catch (Exception params) {
            // empty catch block
        }
        HttpServletRequest request = SpringContextUtils.getHttpServletRequest();
        sysLog.setIp(IPUtils.getIpAddr(request));
        LoginUser sysUser = (LoginUser)SecurityUtils.getSubject().getPrincipal();
        if (sysUser != null) {
            sysLog.setUserid(sysUser.getSubAccount());
            sysLog.setUsername(sysUser.getRealname());
        }
        sysLog.setCostTime(time);
        sysLog.setCreateTime(new Date());
        sysLog.setRequestType(this.getRequestType(method));
        this.sysLogService.saveLog(sysLog);
    }

    private JSONObject getJsonByObejct(Object param) {
        ObjectMapper mapper = new ObjectMapper();
        String json = "{}";
        try {
            json = mapper.writeValueAsString(param);
        }
        catch (JsonProcessingException jsonProcessingException) {
            // empty catch block
        }
        return JSONObject.parseObject((String)json);
    }

    private JSONArray getJsonArrayByObejct(Object param) {
        ObjectMapper mapper = new ObjectMapper();
        String json = "[]";
        try {
            json = mapper.writeValueAsString(param);
        }
        catch (JsonProcessingException jsonProcessingException) {
            // empty catch block
        }
        return JSONArray.parseArray((String)json);
    }

    private String getRequestType(Method targetMethod) {
        Annotation[] annotations = targetMethod.getAnnotations();
        String type = "";
        for (Annotation anno : annotations) {
            if (!anno.annotationType().getName().startsWith(RequestMapping.class.getPackage().getName())) continue;
            if (anno instanceof RequestMapping) {
                RequestMethod[] method = ((RequestMapping)anno).method();
                type = Arrays.stream(method).map(Enum::name).collect(Collectors.joining(","));
                break;
            }
            if (anno instanceof GetMapping) {
                type = "GET";
                break;
            }
            if (anno instanceof PostMapping) {
                type = "POST";
                break;
            }
            if (anno instanceof PutMapping) {
                type = "PUT";
                break;
            }
            if (anno instanceof PatchMapping) {
                type = "PATCH";
                break;
            }
            if (!(anno instanceof DeleteMapping)) break;
            type = "DELETE";
            break;
        }
        return type;
    }

    private int getOperateType(String methodName, int operateType) {
        if (operateType > 0) {
            return operateType;
        }
        if (methodName.startsWith("list")) {
            return 1;
        }
        if (methodName.startsWith("add")) {
            return 2;
        }
        if (methodName.startsWith("edit")) {
            return 3;
        }
        if (methodName.startsWith("delete")) {
            return 4;
        }
        if (methodName.startsWith("import")) {
            return 5;
        }
        if (methodName.startsWith("export")) {
            return 6;
        }
        return 1;
    }
}

