/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.system.query.QueryGenerator;
import com.els.config.mybatis.TenantContext;
import com.els.modules.system.entity.DataLog;
import com.els.modules.system.service.DataLogService;
import com.els.modules.system.util.I18nUtil;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/dataLog"})
public class DataLogController {
    private static final Logger log = LoggerFactory.getLogger(DataLogController.class);
    @Autowired
    private DataLogService service;

    @RequestMapping(value={"/list"}, method={RequestMethod.GET})
    public Result<IPage<DataLog>> queryPageList(DataLog dataLog, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        Result<IPage<DataLog>> result = new Result<IPage<DataLog>>();
        QueryWrapper<DataLog> queryWrapper = QueryGenerator.initQueryWrapper(dataLog, req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        queryWrapper.eq((Object)"els_account", (Object)TenantContext.getTenant());
        IPage pageList = this.service.page((IPage)page, (Wrapper)queryWrapper);
        log.info("\u67e5\u8be2\u5f53\u524d\u9875\uff1a" + pageList.getCurrent());
        log.info("\u67e5\u8be2\u5f53\u524d\u9875\u6570\u91cf\uff1a" + pageList.getSize());
        log.info("\u67e5\u8be2\u7ed3\u679c\u6570\u91cf\uff1a" + pageList.getRecords().size());
        log.info("\u6570\u636e\u603b\u6570\uff1a" + pageList.getTotal());
        result.setSuccess(true);
        result.setResult(pageList);
        return result;
    }

    @RequestMapping(value={"/queryCompareList"}, method={RequestMethod.GET})
    public Result<List<DataLog>> queryCompareList(HttpServletRequest req) {
        Result<List<DataLog>> result = new Result<List<DataLog>>();
        String dataId1 = req.getParameter("dataId1");
        String dataId2 = req.getParameter("dataId2");
        ArrayList<String> idList = new ArrayList<String>();
        idList.add(dataId1);
        idList.add(dataId2);
        try {
            List list = this.service.listByIds(idList);
            result.setResult(list);
            result.setSuccess(true);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    @RequestMapping(value={"/queryDataVerList"}, method={RequestMethod.GET})
    public Result<List<DataLog>> queryDataVerList(HttpServletRequest req) {
        Result<List<DataLog>> result = new Result<List<DataLog>>();
        String dataTable = req.getParameter("dataTable");
        String dataId = req.getParameter("dataId");
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"data_table", (Object)dataTable);
        queryWrapper.eq((Object)"data_id", (Object)dataId);
        List list = this.service.list((Wrapper)queryWrapper);
        if (list == null || list.size() <= 0) {
            result.error500(I18nUtil.translate("i18n_alert_LYurvVH_1d3877ae", "\u672a\u627e\u5230\u7248\u672c\u4fe1\u606f"));
        } else {
            result.setResult(list);
            result.setSuccess(true);
        }
        return result;
    }
}

