/*
 * Decompiled with CFR 0.152.
 */
package com.els.common.util.encryption;

import java.nio.charset.StandardCharsets;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.crypto.Cipher;
import org.apache.commons.codec.binary.Base64;

public class RsaEncryptUtil {
    public static Map<String, String> genKeyPair() throws NoSuchAlgorithmException {
        KeyPairGenerator keyPairGen = KeyPairGenerator.getInstance("RSA");
        keyPairGen.initialize(1024, new SecureRandom());
        KeyPair keyPair = keyPairGen.generateKeyPair();
        RSAPrivateKey privateKey = (RSAPrivateKey)keyPair.getPrivate();
        RSAPublicKey publicKey = (RSAPublicKey)keyPair.getPublic();
        String publicKeyString = new String(Base64.encodeBase64((byte[])publicKey.getEncoded()));
        String privateKeyString = new String(Base64.encodeBase64((byte[])privateKey.getEncoded()));
        ConcurrentHashMap<String, String> keyMap = new ConcurrentHashMap<String, String>();
        keyMap.put("publicKey", publicKeyString);
        keyMap.put("privateKey", privateKeyString);
        return keyMap;
    }

    public static String encrypt(String str, String publicKey) throws Exception {
        byte[] decoded = Base64.decodeBase64((String)publicKey);
        RSAPublicKey pubKey = (RSAPublicKey)KeyFactory.getInstance("RSA").generatePublic(new X509EncodedKeySpec(decoded));
        Cipher cipher = Cipher.getInstance("RSA");
        cipher.init(1, pubKey);
        return Base64.encodeBase64String((byte[])cipher.doFinal(str.getBytes(StandardCharsets.UTF_8)));
    }

    public static String decrypt(String str, String privateKey) throws Exception {
        byte[] inputByte = Base64.decodeBase64((byte[])str.getBytes(StandardCharsets.UTF_8));
        byte[] decoded = Base64.decodeBase64((String)privateKey);
        RSAPrivateKey priKey = (RSAPrivateKey)KeyFactory.getInstance("RSA").generatePrivate(new PKCS8EncodedKeySpec(decoded));
        Cipher cipher = Cipher.getInstance("RSA");
        cipher.init(2, priKey);
        return new String(cipher.doFinal(inputByte));
    }

    public static void main(String[] args) throws Exception {
        String str = "sl62dg15jsi";
        Map<String, String> keyMap = RsaEncryptUtil.genKeyPair();
        System.out.println("\u516c\u94a5\uff1a" + keyMap.get("publicKey"));
        System.out.println("\u79c1\u94a5\uff1a" + keyMap.get("privateKey"));
        String encryptString = RsaEncryptUtil.encrypt(str, keyMap.get("publicKey"));
        System.out.println(str + "\t\u52a0\u5bc6\u540e\u7684\u5b57\u7b26\u4e32\u4e3a:" + encryptString);
        String decryptString = RsaEncryptUtil.decrypt(encryptString, keyMap.get("privateKey"));
        System.out.println("\u8fd8\u539f\u540e\u7684\u5b57\u7b26\u4e32\u4e3a:" + decryptString);
    }
}

