/*
 * Decompiled with CFR 0.152.
 */
package com.els.filter;

import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONUtil;
import com.els.common.exception.ELSBootException;
import com.els.modules.system.util.I18nUtil;
import java.io.IOException;
import java.net.URL;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class CsrfFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(CsrfFilter.class);
    private String[] csrfWhitePaths;
    private String[] csrfWhiteDomains;

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse res = (HttpServletResponse)response;
        String referer = req.getHeader("referer");
        if (!StrUtil.isBlank((CharSequence)referer)) {
            URL refererUrl = new URL(referer);
            String refererHost = refererUrl.getHost();
            int refererPort = refererUrl.getPort();
            String refererHostAndPort = refererPort == -1 ? refererHost : refererHost + ":" + refererPort;
            String requestURL = req.getRequestURL().toString();
            URL urlRequest = new URL(requestURL);
            String requestHost = urlRequest.getHost();
            int requestPort = urlRequest.getPort();
            String requestHostAndPort = requestPort == -1 ? requestHost : requestHost + ":" + requestPort;
            if (requestHostAndPort.equalsIgnoreCase(refererHostAndPort)) {
                filterChain.doFilter(request, response);
            } else {
                if (this.isCsrfWhiteDomains(refererHostAndPort)) {
                    filterChain.doFilter(request, response);
                    return;
                }
                String path = urlRequest.getPath();
                log.info("path = " + path);
                String actionPath = path.replaceAll(request.getServletContext().getContextPath(), "");
                log.info("actionPath = " + actionPath);
                filterChain.doFilter(request, response);
            }
        } else {
            filterChain.doFilter(request, response);
        }
    }

    private void forwardToController(ServletRequest request, ServletResponse response) throws IOException, ServletException {
        request.setAttribute("filter.error", (Object)new ELSBootException(I18nUtil.translate("i18n_alert_WWWWHXCLQVVIOqBy_2b60332d", "csrf\u8de8\u7ad9\u70b9\u4f2a\u9020\u8bf7\u6c42\u5df2\u7ecf\u88ab\u62e6\u622a")));
        request.getRequestDispatcher("/error/exception-throw").forward(request, response);
    }

    public void destroy() {
    }

    private boolean isCsrfWhitePaths(String path) {
        if (this.csrfWhitePaths != null && this.csrfWhitePaths.length > 0) {
            for (String csrfWhitePath : this.csrfWhitePaths) {
                if (StrUtil.isBlank((CharSequence)csrfWhitePath) || !csrfWhitePath.equals(path)) continue;
                log.info("\u8de8\u7ad9\u70b9\u8bf7\u6c42\u6240\u6709\u8def\u5f84\u767d\u540d\u5355\uff1acsrfWhitePaths = " + JSONUtil.toJsonStr((Object)this.csrfWhitePaths));
                log.info("\u7b26\u5408\u8de8\u7ad9\u70b9\u8bf7\u6c42\u8def\u5f84\u767d\u540d\u5355\uff1apath = " + path);
                return true;
            }
        }
        return false;
    }

    private boolean isCsrfWhiteDomains(String refererHostAndPort) {
        if (this.csrfWhiteDomains != null && this.csrfWhiteDomains.length > 0) {
            for (String csrfWhiteDomain : this.csrfWhiteDomains) {
                if (StrUtil.isBlank((CharSequence)csrfWhiteDomain) || !csrfWhiteDomain.equals(refererHostAndPort)) continue;
                log.info("\u8de8\u7ad9\u70b9\u8bf7\u6c42\u6240\u6709\u3010\u57df\u540d\u3011]\u767d\u540d\u5355\uff1acsrfWhiteDomains = " + JSONUtil.toJsonStr((Object)this.csrfWhiteDomains));
                log.info("\u7b26\u5408\u8de8\u7ad9\u70b9\u8bf7\u6c42\u3010\u57df\u540d\u3011\u767d\u540d\u5355\uff1arefererHost = " + refererHostAndPort);
                return true;
            }
            log.info("\u8de8\u7ad9\u70b9\u8bf7\u6c42\u975e\u6cd5\u3010\u57df\u540d\u3011\uff1arefererHost = " + refererHostAndPort);
        }
        return false;
    }
}

