/*
 * Decompiled with CFR 0.152.
 */
package com.els.framework.poi.excel;

import com.els.common.aspect.annotation.Dict;
import com.els.framework.poi.excel.entity.ExportParams;
import com.els.framework.poi.excel.entity.TemplateExportParams;
import com.els.framework.poi.excel.entity.enmus.ExcelType;
import com.els.framework.poi.excel.entity.params.ExcelExportEntity;
import com.els.framework.poi.excel.export.ExcelExportServer;
import com.els.framework.poi.excel.export.template.ExcelExportOfTemplateUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public final class ExcelExportUtil {
    private static final ThreadLocal<Map<String, String>> THREAD_DICT_MAP = new ThreadLocal();
    private static final ThreadLocal<Map<String, Dict>> THREAD_DICT_FIELD_MAP = new ThreadLocal();

    public static Workbook exportExcel(ExportParams entity, Class<?> pojoClass, Collection<?> dataSet, String[] exportFields) {
        Object workbook = ExcelType.HSSF.equals((Object)entity.getType()) ? new HSSFWorkbook() : (dataSet.size() < 1000 ? new XSSFWorkbook() : new SXSSFWorkbook());
        new ExcelExportServer().createSheet((Workbook)workbook, entity, pojoClass, dataSet, exportFields);
        ExcelExportUtil.removeThreadDictMapValue();
        return workbook;
    }

    public static Workbook exportExcel(ExportParams entity, Class<?> pojoClass, Collection<?> dataSet) {
        Object workbook = ExcelType.HSSF.equals((Object)entity.getType()) ? new HSSFWorkbook() : (dataSet.size() < 1000 ? new XSSFWorkbook() : new SXSSFWorkbook());
        new ExcelExportServer().createSheet((Workbook)workbook, entity, pojoClass, dataSet, null);
        ExcelExportUtil.removeThreadDictMapValue();
        return workbook;
    }

    public static Workbook exportExcel(ExportParams entity, List<ExcelExportEntity> entityList, Collection<? extends Map<?, ?>> dataSet) {
        Object workbook = ExcelType.HSSF.equals((Object)entity.getType()) ? new HSSFWorkbook() : (dataSet.size() < 1000 ? new XSSFWorkbook() : new SXSSFWorkbook());
        new ExcelExportServer().createSheetForMap((Workbook)workbook, entity, entityList, dataSet);
        ExcelExportUtil.removeThreadDictMapValue();
        return workbook;
    }

    public static Workbook exportExcel(List<Map<String, Object>> list, ExcelType type) {
        Object workbook = ExcelType.HSSF.equals((Object)type) ? new HSSFWorkbook() : new XSSFWorkbook();
        for (Map<String, Object> map : list) {
            ExcelExportServer server = new ExcelExportServer();
            server.createSheet((Workbook)workbook, (ExportParams)map.get("title"), (Class)map.get("entity"), (Collection)map.get("data"), null);
        }
        return workbook;
    }

    public static Workbook exportExcel(TemplateExportParams params, Class<?> pojoClass, Collection<?> dataSet, Map<String, Object> map) {
        Workbook excleByTemplate = new ExcelExportOfTemplateUtil().createExcleByTemplate(params, pojoClass, dataSet, map);
        ExcelExportUtil.removeThreadDictMapValue();
        return excleByTemplate;
    }

    public static Workbook exportExcel(TemplateExportParams params, Map<String, Object> map) {
        Workbook excleByTemplate = new ExcelExportOfTemplateUtil().createExcleByTemplate(params, null, null, map);
        ExcelExportUtil.removeThreadDictMapValue();
        return excleByTemplate;
    }

    public static void initThreadDictMap() {
        Map<String, Dict> fieldMap;
        Map<String, String> threadDictMap = THREAD_DICT_MAP.get();
        if (null == threadDictMap) {
            threadDictMap = new HashMap<String, String>(32);
            THREAD_DICT_MAP.set(threadDictMap);
        }
        if (null == (fieldMap = THREAD_DICT_FIELD_MAP.get())) {
            fieldMap = new HashMap<String, Dict>(16);
            THREAD_DICT_FIELD_MAP.set(fieldMap);
        }
    }

    public static void setThreadDictMapValue(String key, String value) {
        Map<String, String> threadDictMap = THREAD_DICT_MAP.get();
        threadDictMap.putIfAbsent(key, value);
        THREAD_DICT_MAP.set(threadDictMap);
    }

    public static void setThreadDictFieldMapValue(String key, Dict dict) {
        Map<String, Dict> threadDictMap = THREAD_DICT_FIELD_MAP.get();
        threadDictMap.putIfAbsent(key, dict);
        THREAD_DICT_FIELD_MAP.set(threadDictMap);
    }

    public static Map<String, String> getThreadDictMapValue() {
        return THREAD_DICT_MAP.get();
    }

    public static Dict getThreadDictField(String fieldName) {
        return THREAD_DICT_FIELD_MAP.get() == null ? null : THREAD_DICT_FIELD_MAP.get().get(fieldName);
    }

    public static void removeThreadDictMapValue() {
        Map<String, Dict> threadDictFieldMap;
        Map<String, String> threadDictMap = THREAD_DICT_MAP.get();
        if (null != threadDictMap) {
            threadDictMap.clear();
        }
        if (null != (threadDictFieldMap = THREAD_DICT_FIELD_MAP.get())) {
            threadDictFieldMap.clear();
        }
        THREAD_DICT_MAP.remove();
        THREAD_DICT_FIELD_MAP.remove();
    }
}

