/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.attachment.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.SpringContextUtils;
import com.els.modules.attachment.entity.PurchaseAttachment;
import com.els.modules.attachment.entity.SaleAttachment;
import com.els.modules.attachment.mapper.SaleAttachmentMapper;
import com.els.modules.attachment.service.PurchaseAttachmentService;
import com.els.modules.attachment.service.SaleAttachmentService;
import com.els.modules.attachment.vo.AttachmentSendVO;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.shiro.SecurityUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class SaleAttachmentServiceImpl
extends ServiceImpl<SaleAttachmentMapper, SaleAttachment>
implements SaleAttachmentService {
    @Override
    public void delAttachmentSale(String id) {
        ((SaleAttachmentMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void delBatchAttachmentSale(List<String> idList) {
        ((SaleAttachmentMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    public void sendFile(AttachmentSendVO sendVO) {
        String elsAccount = sendVO.getElsAccount();
        List<SaleAttachment> saleAttachmentList = ((SaleAttachmentMapper)this.baseMapper).selectByMainId(sendVO.getHeadId());
        List<SaleAttachment> needSendList = saleAttachmentList.parallelStream().filter(attachment -> !"1".equals(attachment.getSendStatus())).filter(attachment -> elsAccount.equals(attachment.getUploadElsAccount())).collect(Collectors.toList());
        if (CollectionUtil.isNotEmpty(needSendList)) {
            needSendList.forEach(attachment -> attachment.setSendStatus("1"));
            this.updateBatchById(needSendList);
            ArrayList<PurchaseAttachment> insertPurchaseList = new ArrayList<PurchaseAttachment>();
            Map<Object, Object> toSend = sendVO.getToSend() == null ? new ConcurrentHashMap() : sendVO.getToSend();
            for (String string : toSend.keySet()) {
                String purchaseElsAccount = (String)toSend.get(string);
                for (SaleAttachment saleAttachment : needSendList) {
                    PurchaseAttachment purchaseAttachment = new PurchaseAttachment();
                    BeanUtils.copyProperties((Object)saleAttachment, (Object)purchaseAttachment);
                    purchaseAttachment.setId(IdWorker.getIdStr());
                    purchaseAttachment.setElsAccount(purchaseElsAccount);
                    purchaseAttachment.setRelationId(saleAttachment.getId());
                    purchaseAttachment.setHeadId(string);
                    insertPurchaseList.add(purchaseAttachment);
                    saleAttachment.setRelationId(purchaseAttachment.getId());
                }
            }
            this.updateBatchById(needSendList);
            PurchaseAttachmentService purchaseAttachmentService = SpringContextUtils.getBean(PurchaseAttachmentService.class);
            purchaseAttachmentService.saveBatch(insertPurchaseList);
        }
    }

    @Override
    public List<SaleAttachment> selectByMainId(String mainId) {
        return ((SaleAttachmentMapper)this.baseMapper).selectByMainId(mainId);
    }

    @Override
    public List<PurchaseAttachment> toPurchaseAttachment(String mainId) {
        LoginUser user = (LoginUser)SecurityUtils.getSubject().getPrincipal();
        if (user != null && !StringUtils.isEmpty((Object)user.getElsAccount())) {
            List saleAttachmentList = ((SaleAttachmentMapper)this.baseMapper).selectByMainId(mainId).stream().filter(attachment -> attachment.getUploadElsAccount().equals(user.getElsAccount())).collect(Collectors.toList());
            ArrayList attachmentList = Lists.newArrayList();
            for (SaleAttachment saleAttachment : saleAttachmentList) {
                PurchaseAttachment attachment2 = new PurchaseAttachment();
                BeanUtils.copyProperties((Object)saleAttachment, (Object)attachment2);
                attachmentList.add(attachment2);
            }
            return attachmentList;
        }
        return Lists.newArrayList();
    }
}

