/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.message.util;

import com.els.common.exception.ELSBootException;
import com.els.modules.system.util.I18nUtil;
import freemarker.cache.CacheStorage;
import freemarker.cache.NullCacheStorage;
import freemarker.cache.StringTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateExceptionHandler;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;

public class TemplateParseUtil {
    private static final Configuration CONFIGURATION = new Configuration(Configuration.VERSION_2_3_27);

    private TemplateParseUtil() {
    }

    public static String getTemplateText(String templateName, String templateContent, Map<String, Object> paramsMap) {
        StringWriter stringWriter = new StringWriter();
        try {
            Template template = new Template(templateName, templateContent, CONFIGURATION);
            template.process(paramsMap, (Writer)stringWriter);
            return stringWriter.toString();
        }
        catch (Exception e) {
            throw new ELSBootException(I18nUtil.translate("i18n_alert_WWWIriHKmWWWWWW_1017c16b", "sql\u6a21\u677f\u6e32\u67d3\u5931\u8d25\uff1a ${0}", e.getMessage()));
        }
    }

    static {
        StringTemplateLoader templateLoader = new StringTemplateLoader();
        CONFIGURATION.setTemplateLoader((TemplateLoader)templateLoader);
        CONFIGURATION.setDefaultEncoding("UTF-8");
        CONFIGURATION.setTemplateExceptionHandler(TemplateExceptionHandler.RETHROW_HANDLER);
        CONFIGURATION.setCacheStorage((CacheStorage)NullCacheStorage.INSTANCE);
    }
}

