/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.message.websocket;

import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.websocket.OnClose;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.Session;
import javax.websocket.server.PathParam;
import javax.websocket.server.ServerEndpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@ServerEndpoint(value="/websocket/{userId}")
public class WebSocket {
    private static final Logger log = LoggerFactory.getLogger(WebSocket.class);
    private Session session;
    private static CopyOnWriteArraySet<WebSocket> webSockets = new CopyOnWriteArraySet();
    private static Map<String, Session> sessionPool = new HashMap<String, Session>();

    @OnOpen
    public void onOpen(Session session, @PathParam(value="userId") String userId) {
        try {
            this.session = session;
            webSockets.add(this);
            sessionPool.put(userId, session);
            log.info("\u3010websocket\u6d88\u606f\u3011\u6709\u65b0\u7684\u8fde\u63a5\uff0c\u603b\u6570\u4e3a:" + webSockets.size());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @OnClose
    public void onClose() {
        try {
            webSockets.remove(this);
            log.info("\u3010websocket\u6d88\u606f\u3011\u8fde\u63a5\u65ad\u5f00\uff0c\u603b\u6570\u4e3a:" + webSockets.size());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @OnMessage
    public void onMessage(String message) {
        JSONObject obj = new JSONObject();
        obj.put("cmd", (Object)"heartcheck");
        obj.put("msgTxt", (Object)"\u5fc3\u8df3\u54cd\u5e94");
        this.session.getAsyncRemote().sendText(obj.toJSONString());
    }

    public void sendAllMessage(String message) {
        for (WebSocket webSocket : webSockets) {
            try {
                if (!webSocket.session.isOpen()) continue;
                webSocket.session.getAsyncRemote().sendText(message);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void sendOneMessage(String userId, String message) {
        Session session = sessionPool.get(userId);
        if (session != null && session.isOpen()) {
            try {
                log.info("\u3010websocket\u6d88\u606f\u3011 \u5355\u70b9\u6d88\u606f:" + message);
                session.getAsyncRemote().sendText(message);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void sendMoreMessage(String[] userIds, String message) {
        for (String userId : userIds) {
            Session session = sessionPool.get(userId);
            if (session == null || !session.isOpen()) continue;
            try {
                log.info("\u3010websocket\u6d88\u606f\u3011 \u5355\u70b9\u6d88\u606f:" + message);
                session.getAsyncRemote().sendText(message);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

