/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.excel.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.els.common.constant.CommonConstant;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.config.mybatis.TenantContext;
import com.els.modules.system.entity.CompanyI18n;
import com.els.modules.system.entity.I18n;
import com.els.modules.system.service.AbstractExcelHandler;
import com.els.modules.system.service.CheckService;
import com.els.modules.system.service.CompanyI18nService;
import com.els.modules.system.service.I18nService;
import com.els.modules.system.vo.I18nVO;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="I18nDataImportImpl2")
public class I18nDataImportImpl
extends AbstractExcelHandler {
    @Autowired
    private I18nService i18nService;
    @Autowired
    private CheckService checkService;
    @Autowired
    private CompanyI18nService companyI18nService;

    @Override
    public void importExcel(List<Map<String, Object>> dataList) {
        String elsAccount = TenantContext.getTenant();
        ArrayList<I18nVO> list = new ArrayList<I18nVO>();
        ArrayList<String> keyList = new ArrayList<String>();
        for (Map<String, Object> data : dataList) {
            I18nVO i18n = (I18nVO)JSON.parseObject((String)JSON.toJSONString(data), I18nVO.class);
            i18n.setElsAccount(elsAccount);
            keyList.add(i18n.getI18nKey());
            list.add(i18n);
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.in((Object)"i18n_key", keyList);
        List i18nList = this.i18nService.list((Wrapper)queryWrapper);
        HashMap<String, Object> dbMap = new HashMap<String, Object>();
        for (Object i18n : i18nList) {
            dbMap.put(((BaseEntity)i18n).getElsAccount() + ((I18n)i18n).getLanguage() + ((I18n)i18n).getI18nKey(), i18n);
        }
        if (elsAccount.equals("100000")) {
            ArrayList<I18n> i18nInsertList = new ArrayList<I18n>();
            for (I18nVO i18n : list) {
                String msg;
                I18n i18nZh;
                if (StringUtils.isNotBlank((CharSequence)i18n.getChinese()) && dbMap.containsKey(i18n.getElsAccount() + "zh" + i18n.getI18nKey())) {
                    i18nZh = new I18n();
                    i18nZh.setId(((I18n)dbMap.get(i18n.getElsAccount() + "zh" + i18n.getI18nKey())).getId());
                    i18nZh.setI18nValue(i18n.getChinese());
                    this.i18nService.updateById(i18nZh);
                }
                if (StringUtils.isNotBlank((CharSequence)i18n.getEnglish()) && dbMap.containsKey(i18n.getElsAccount() + "en" + i18n.getI18nKey())) {
                    i18nZh = new I18n();
                    i18nZh.setId(((I18n)dbMap.get(i18n.getElsAccount() + "en" + i18n.getI18nKey())).getId());
                    i18nZh.setI18nValue(i18n.getEnglish());
                    this.i18nService.updateById(i18nZh);
                    continue;
                }
                I18n i18nNew = new I18n();
                i18nNew.setElsAccount(elsAccount);
                i18nNew.setDeleted(CommonConstant.DEL_FLAG_0);
                i18nNew.setCreateTime(new Date());
                if (!StringUtils.isNotBlank((CharSequence)i18n.getChinese())) continue;
                i18nNew.setId(IdWorker.getIdStr());
                if (StringUtils.isBlank((CharSequence)i18n.getI18nKey())) {
                    i18nNew.setI18nKey(this.i18nService.createI18nKey(i18n.getChinese(), "import"));
                }
                if (!"success".equals(msg = this.checkExist(i18nNew.getId(), i18nNew.getLanguage() + "-" + i18nNew.getI18nKey()))) {
                    throw new ELSBootException(msg);
                }
                i18nNew.setI18nValue(i18n.getChinese());
                i18nNew.setLanguage("zh");
                i18nInsertList.add(i18nNew);
                if (!StringUtils.isNotBlank((CharSequence)i18n.getEnglish())) continue;
                i18nNew.setId(IdWorker.getIdStr());
                i18nNew.setLanguage("en");
                i18nNew.setI18nValue(i18n.getEnglish());
                i18nInsertList.add(i18nNew);
            }
            if (!i18nInsertList.isEmpty()) {
                this.i18nService.saveBatch(i18nInsertList);
            }
        } else {
            ArrayList<CompanyI18n> companyI18nList = new ArrayList<CompanyI18n>();
            ArrayList<I18n> i18nInsertList = new ArrayList<I18n>();
            for (I18nVO i18n : list) {
                I18n i18n1;
                CompanyI18n companyI18n;
                String i18nId;
                if (StringUtils.isNotBlank((CharSequence)i18n.getChinese()) && dbMap.containsKey("100000zh" + i18n.getI18nKey())) {
                    i18nId = ((I18n)dbMap.get("100000zh" + i18n.getI18nKey())).getId();
                    this.companyI18nService.deleteByI18nId(elsAccount, i18nId);
                    companyI18n = new CompanyI18n();
                    companyI18n.setElsAccount(elsAccount);
                    companyI18n.setId(IdWorker.getIdStr());
                    companyI18n.setI18nId(i18nId);
                    companyI18n.setI18nValue(i18n.getChinese());
                    companyI18n.setDeleted(CommonConstant.DEL_FLAG_0);
                    companyI18n.setCreateTime(new Date());
                    companyI18nList.add(companyI18n);
                } else if (StringUtils.isNotBlank((CharSequence)i18n.getChinese()) && dbMap.containsKey(i18n.getElsAccount() + "zh" + i18n.getI18nKey())) {
                    i18n1 = new I18n();
                    i18n1.setId(((I18n)dbMap.get(i18n.getElsAccount() + "zh" + i18n.getI18nKey())).getId());
                    i18n1.setI18nValue(i18n.getChinese());
                    this.i18nService.updateById(i18n1);
                } else {
                    I18n i18nNew = new I18n();
                    i18nNew.setElsAccount(elsAccount);
                    i18nNew.setDeleted(CommonConstant.DEL_FLAG_0);
                    i18nNew.setCreateTime(new Date());
                    if (StringUtils.isNotBlank((CharSequence)i18n.getChinese())) {
                        String msg;
                        i18nNew.setId(IdWorker.getIdStr());
                        if (StringUtils.isBlank((CharSequence)i18n.getI18nKey())) {
                            i18nNew.setI18nKey(this.i18nService.createI18nKey(i18n.getChinese(), "import"));
                        }
                        if (!"success".equals(msg = this.checkExist(i18nNew.getId(), i18nNew.getLanguage() + "-" + i18nNew.getI18nKey()))) {
                            throw new ELSBootException(msg);
                        }
                        i18nNew.setLanguage("zh");
                        i18nNew.setI18nValue(i18n.getChinese());
                        i18nInsertList.add(i18nNew);
                        if (StringUtils.isNotBlank((CharSequence)i18n.getEnglish())) {
                            i18nNew.setId(IdWorker.getIdStr());
                            i18nNew.setLanguage("en");
                            i18nNew.setI18nValue(i18n.getEnglish());
                            i18nInsertList.add(i18nNew);
                        }
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)i18n.getEnglish()) && dbMap.containsKey("100000en" + i18n.getI18nKey())) {
                    i18nId = ((I18n)dbMap.get("100000en" + i18n.getI18nKey())).getId();
                    this.companyI18nService.deleteByI18nId(elsAccount, i18nId);
                    companyI18n = new CompanyI18n();
                    companyI18n.setElsAccount(elsAccount);
                    companyI18n.setId(IdWorker.getIdStr());
                    companyI18n.setI18nId(i18nId);
                    companyI18n.setI18nValue(i18n.getEnglish());
                    companyI18n.setDeleted(CommonConstant.DEL_FLAG_0);
                    companyI18n.setCreateTime(new Date());
                    companyI18nList.add(companyI18n);
                    continue;
                }
                if (!StringUtils.isNotBlank((CharSequence)i18n.getEnglish()) || !dbMap.containsKey(i18n.getElsAccount() + "zh" + i18n.getI18nKey())) continue;
                i18n1 = new I18n();
                i18n1.setId(((I18n)dbMap.get(i18n.getElsAccount() + "zh" + i18n.getI18nKey())).getId());
                i18n1.setI18nValue(i18n.getEnglish());
                this.i18nService.updateById(i18n1);
            }
            if (!companyI18nList.isEmpty()) {
                this.companyI18nService.saveBatch(companyI18nList);
            }
            if (!i18nInsertList.isEmpty()) {
                this.i18nService.saveBatch(i18nInsertList);
            }
        }
    }

    private String checkExist(String dataId, String value) {
        return this.checkService.checkExist(dataId, "els_i18n", "concat(language,'-',i18n_key)", value);
    }
}

