/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.service.impl;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.RedisUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.system.entity.CompanyInterfaceConfig;
import com.els.modules.system.mapper.CompanyInterfaceConfigMapper;
import com.els.modules.system.service.CompanyInterfaceConfigService;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class CompanyInterfaceConfigServiceImpl
extends BaseServiceImpl<CompanyInterfaceConfigMapper, CompanyInterfaceConfig>
implements CompanyInterfaceConfigService {
    private static final String REDIS_KEY = "sys:company:interface:";
    @Resource
    private RedisUtil redisUtil;

    private String getRedisKey(String elsAccount, String interfaceCode) {
        StringBuilder redisKey = new StringBuilder(REDIS_KEY);
        redisKey.append(elsAccount);
        redisKey.append(interfaceCode);
        return redisKey.toString();
    }

    @Override
    public void updateCompanyInterfaceConfig(CompanyInterfaceConfig config) {
        if (StrUtil.isBlank((CharSequence)config.getInterfaceCode())) {
            throw new ELSBootException("\u63a5\u53e3\u5e73\u53f0\u63a5\u53e3\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StrUtil.isBlank((CharSequence)config.getInterfaceId())) {
            config.setElsAccount(TenantContext.getTenant());
            config.setInterfaceId(config.getId());
            config.setId(null);
            config.setUpdateBy(null);
            config.setUpdateTime(null);
            ((CompanyInterfaceConfigMapper)this.baseMapper).insert(config);
        } else {
            String id = config.getId();
            config.setId(config.getInterfaceId());
            config.setInterfaceId(id);
            config.setUpdateBy(null);
            config.setUpdateTime(null);
            ((CompanyInterfaceConfigMapper)this.baseMapper).updateById(config);
        }
        this.redisUtil.del(this.getRedisKey(TenantContext.getTenant(), config.getSrmInterfaceCode()));
    }

    @Override
    public IPage<CompanyInterfaceConfig> findPageList(Page<CompanyInterfaceConfig> page, QueryWrapper<CompanyInterfaceConfig> wrapper) {
        return ((CompanyInterfaceConfigMapper)this.baseMapper).findPageList(page, TenantContext.getTenant(), wrapper);
    }

    @Override
    public CompanyInterfaceConfig getOneConfig(String elsAccount, String srmInterfaceCode) {
        CompanyInterfaceConfig config = (CompanyInterfaceConfig)this.redisUtil.get(this.getRedisKey(elsAccount, srmInterfaceCode));
        if (config != null) {
            return config;
        }
        config = ((CompanyInterfaceConfigMapper)this.baseMapper).getOneConfig(elsAccount, srmInterfaceCode);
        if (config != null) {
            this.redisUtil.set(this.getRedisKey(elsAccount, srmInterfaceCode), config, 14400L);
        }
        return config;
    }
}

