/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.util.encrypt;

import java.security.Key;
import java.security.MessageDigest;
import java.util.Base64;
import java.util.Map;
import javax.crypto.KeyGenerator;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.digest.DigestUtils;

public abstract class CipherUtil {
    public static final String CHARSET_UTF8 = "UTF-8";
    public static final int SIZE_1024 = 1024;
    public static final String KEY_ALGORITHM_SHA256 = "SHA-256";
    public static final String KEY_ALGORITHM_MD5 = "MD5";
    public static final String KEY_ALGORITHM_HMAC = "HmacMD5";

    public static String decryptBASE64Str(String dataStr) throws Exception {
        return new String(CipherUtil.decryptBASE64(dataStr));
    }

    public static byte[] decryptBASE64(String dataStr) throws Exception {
        Base64.Decoder decoder = Base64.getDecoder();
        return decoder.decode(dataStr);
    }

    public static String encryptBASE64(String dataStr) throws Exception {
        byte[] datas = dataStr.getBytes(CHARSET_UTF8);
        return CipherUtil.encryptBASE64(datas);
    }

    public static String encryptBASE64(byte[] datas) throws Exception {
        Base64.Encoder encoder = Base64.getEncoder();
        return encoder.encodeToString(datas);
    }

    public static byte[] encryptMD5(String dataStr) throws Exception {
        byte[] data = dataStr.getBytes(CHARSET_UTF8);
        MessageDigest md5 = MessageDigest.getInstance(KEY_ALGORITHM_MD5);
        md5.update(data);
        return md5.digest();
    }

    public static byte[] encryptMD5(byte[] data) throws Exception {
        MessageDigest md5 = MessageDigest.getInstance(KEY_ALGORITHM_MD5);
        md5.update(data);
        return md5.digest();
    }

    public static String encryptMD5Hex(String dataStr) throws Exception {
        return DigestUtils.md5Hex((String)dataStr);
    }

    public static String encryptMD5Hex(byte[] data) throws Exception {
        return DigestUtils.md5Hex((byte[])data);
    }

    public static byte[] encryptSHA256(String dataStr) throws Exception {
        byte[] data = dataStr.getBytes(CHARSET_UTF8);
        MessageDigest md5 = MessageDigest.getInstance(KEY_ALGORITHM_SHA256);
        md5.update(data);
        return md5.digest();
    }

    public static byte[] encryptSHA256(byte[] data) throws Exception {
        MessageDigest md5 = MessageDigest.getInstance(KEY_ALGORITHM_SHA256);
        md5.update(data);
        return md5.digest();
    }

    public static String encryptSHA256Hex(String dataStr) throws Exception {
        return DigestUtils.sha256Hex((String)dataStr);
    }

    public static String encryptSHA256Hex(byte[] data) throws Exception {
        return DigestUtils.sha256Hex((byte[])data);
    }

    public static String encryptSHA512Hex(String dataStr) throws Exception {
        return DigestUtils.sha512Hex((String)dataStr);
    }

    public static String encryptSHA512Hex(byte[] data) throws Exception {
        return DigestUtils.sha512Hex((byte[])data);
    }

    public static String encryptSHA1Hex(String dataStr) throws Exception {
        return DigestUtils.sha1Hex((String)dataStr);
    }

    public static String encryptSHA1Hex(byte[] data) throws Exception {
        return DigestUtils.sha1Hex((byte[])data);
    }

    public static String initMacKey() throws Exception {
        KeyGenerator keyGenerator = KeyGenerator.getInstance(KEY_ALGORITHM_HMAC);
        SecretKey secretKey = keyGenerator.generateKey();
        return CipherUtil.encryptBASE64(secretKey.getEncoded());
    }

    public static byte[] encryptHMAC(byte[] data, String key) throws Exception {
        SecretKeySpec secretKey = new SecretKeySpec(CipherUtil.decryptBASE64(key), KEY_ALGORITHM_HMAC);
        Mac mac = Mac.getInstance(secretKey.getAlgorithm());
        mac.init(secretKey);
        return mac.doFinal(data);
    }

    public static String getPrivateKey(Map<String, Object> keyMap, String privateKey) throws Exception {
        Key key = (Key)keyMap.get(privateKey);
        return CipherUtil.encryptBASE64(key.getEncoded());
    }

    public static String getPublicKey(Map<String, Object> keyMap, String publicKey) throws Exception {
        Key key = (Key)keyMap.get(publicKey);
        return CipherUtil.encryptBASE64(key.getEncoded());
    }
}

