/*
 * Decompiled with CFR 0.152.
 */
package com.els.common.util;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;

public class ImgCreatorUtil {
    static final String[] BEAUTIFUL_COLORS = new String[]{"232,221,203", "205,179,128", "3,101,100", "3,54,73", "3,22,52", "237,222,139", "251,178,23", "96,143,159", "1,77,103", "254,67,101", "252,157,154", "249,205,173", "200,200,169", "131,175,155", "229,187,129", "161,23,21", "34,8,7", "118,77,57", "17,63,61", "60,79,57", "95,92,51", "179,214,110", "248,147,29", "227,160,93", "178,190,126", "114,111,238", "56,13,49", "89,61,67", "250,218,141", "3,38,58", "179,168,150", "222,125,44", "20,68,106", "130,57,53", "137,190,178", "201,186,131", "222,211,140", "222,156,83", "23,44,60", "39,72,98", "153,80,84", "217,104,49", "230,179,61", "174,221,129", "107,194,53", "6,128,67", "38,157,128", "178,200,187", "69,137,148", "117,121,71", "114,83,52", "87,105,60", "82,75,46", "171,92,37", "100,107,48", "98,65,24", "54,37,17", "137,157,192", "250,227,113", "29,131,8", "220,87,18", "29,191,151", "35,235,185", "213,26,33", "160,191,124", "101,147,74", "64,116,52", "255,150,128", "255,94,72", "38,188,213", "167,220,224", "1,165,175", "179,214,110", "248,147,29", "230,155,3", "209,73,78", "62,188,202", "224,160,158", "161,47,47", "0,90,171", "107,194,53", "174,221,129", "6,128,67", "38,157,128", "201,138,131", "220,162,151", "137,157,192", "175,215,237", "92,167,186", "255,66,93", "147,224,255", "247,68,97", "185,227,217"};

    public static void main(String[] args) throws IOException {
        String name = "\u8001\u5a46";
        byte[] bytes = ImgCreatorUtil.generateImg(name);
        File file = new File("test.jpg");
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        fileOutputStream.write(bytes);
    }

    public static byte[] generateImg(String name) {
        String first;
        int width = 100;
        int height = 100;
        int nameLen = name.length();
        String nameWritten = "";
        nameWritten = nameLen <= 2 ? name : (ImgCreatorUtil.isChinese(first = name.substring(0, 1)) ? name.substring(0, 3) : name.substring(0, 3).toUpperCase());
        BufferedImage bi = new BufferedImage(width, height, 1);
        Graphics2D g2 = (Graphics2D)bi.getGraphics();
        g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g2.setBackground(ImgCreatorUtil.getRandomColor());
        g2.clearRect(0, 0, width, height);
        g2.setPaint(Color.WHITE);
        Font font = null;
        if (nameWritten.length() >= 2) {
            int size = nameWritten.length() == 2 ? 30 : 20;
            font = new Font("\u5fae\u8f6f\u96c5\u9ed1", 0, size);
            g2.setFont(font);
            String firstWritten = nameWritten.substring(0, 1);
            String secondWritten = nameWritten.substring(1);
            if (ImgCreatorUtil.isChinese(firstWritten) && ImgCreatorUtil.isChinese(secondWritten)) {
                g2.drawString(nameWritten, 20, 60);
            } else if (ImgCreatorUtil.isChinese(firstWritten) && !ImgCreatorUtil.isChinese(secondWritten)) {
                g2.drawString(nameWritten, 27, 60);
            } else {
                nameWritten = nameWritten.substring(0, 1);
            }
        }
        if (nameWritten.length() == 1) {
            if (ImgCreatorUtil.isChinese(nameWritten)) {
                font = new Font("\u5fae\u8f6f\u96c5\u9ed1", 0, 50);
                g2.setFont(font);
                g2.drawString(nameWritten, 25, 70);
            } else {
                font = new Font("\u5fae\u8f6f\u96c5\u9ed1", 0, 55);
                g2.setFont(font);
                g2.drawString(nameWritten.toUpperCase(), 33, 67);
            }
        }
        BufferedImage rounded = ImgCreatorUtil.makeRoundedCorner(bi, 99);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)rounded, "png", os);
            return os.toByteArray();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static boolean isChinese(String str) {
        String regEx = "[\\u4e00-\\u9fa5]+";
        Pattern p = Pattern.compile(regEx);
        Matcher m = p.matcher(str);
        return m.find();
    }

    private static Color getRandomColor() {
        int len = BEAUTIFUL_COLORS.length;
        Random random = new Random();
        String[] color = BEAUTIFUL_COLORS[random.nextInt(len)].split(",");
        return new Color(Integer.parseInt(color[0]), Integer.parseInt(color[1]), Integer.parseInt(color[2]));
    }

    public static BufferedImage makeRoundedCorner(BufferedImage image, int cornerRadius) {
        int w = image.getWidth();
        int h = image.getHeight();
        BufferedImage output = new BufferedImage(w, h, 2);
        Graphics2D g2 = output.createGraphics();
        g2.setComposite(AlphaComposite.Src);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setColor(Color.WHITE);
        g2.fill(new RoundRectangle2D.Float(0.0f, 0.0f, w, h, cornerRadius, cornerRadius));
        g2.setComposite(AlphaComposite.SrcAtop);
        g2.drawImage((Image)image, 0, 0, null);
        g2.dispose();
        return output;
    }
}

