/*
 * Decompiled with CFR 0.152.
 */
package com.els.config;

import com.els.modules.log.vo.LoggerMessage;
import com.els.modules.log.vo.LoggerQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.messaging.simp.SimpMessagingTemplate;
import org.springframework.web.socket.config.annotation.EnableWebSocketMessageBroker;
import org.springframework.web.socket.config.annotation.StompEndpointRegistry;
import org.springframework.web.socket.config.annotation.WebSocketMessageBrokerConfigurer;
import org.springframework.web.socket.server.standard.ServerEndpointExporter;

@Configuration
@EnableWebSocketMessageBroker
public class WebSocketConfig
implements WebSocketMessageBrokerConfigurer {
    @Autowired
    private SimpMessagingTemplate messagingTemplate;

    @Bean
    public ServerEndpointExporter serverEndpointExporter() {
        return new ServerEndpointExporter();
    }

    public void registerStompEndpoints(StompEndpointRegistry registry) {
        registry.addEndpoint(new String[]{"/websocket"}).setAllowedOrigins(new String[]{"*"}).withSockJS();
    }

    @PostConstruct
    public void pushLogger() {
        ThreadPoolExecutor executorService = new ThreadPoolExecutor(2, 2, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                while (true) {
                    try {
                        while (true) {
                            LoggerMessage log;
                            if ((log = LoggerQueue.getInstance().poll()) == null || WebSocketConfig.this.messagingTemplate == null) {
                                continue;
                            }
                            WebSocketConfig.this.messagingTemplate.convertAndSend((Object)"/topic/pullLogger", (Object)log);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        continue;
                    }
                    break;
                }
            }
        };
        executorService.submit(runnable);
    }
}

