/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.dashboard.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.query.QueryGenerator;
import com.els.config.mybatis.TenantContext;
import com.els.modules.dashboard.entity.ChartConfig;
import com.els.modules.dashboard.mapper.DashboardChartMapper;
import com.els.modules.dashboard.service.ChartConfigService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@Api(tags={"\u56fe\u8868\u914d\u7f6e"})
@RestController
@RequestMapping(value={"/dashboard/chartConfig"})
public class ChartConfigController
extends BaseController<ChartConfig, ChartConfigService> {
    @Autowired
    private ChartConfigService chartConfigService;
    @Autowired
    private DashboardChartMapper dashboardChartMapper;

    @ApiOperation(value="\u56fe\u8868\u914d\u7f6e-\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u56fe\u8868\u914d\u7f6e-\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    public Result<?> queryPageList(ChartConfig chartConfig, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper<ChartConfig> queryWrapper = QueryGenerator.initQueryWrapper(chartConfig, req.getParameterMap());
        queryWrapper.lambda().eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.chartConfigService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok(pageList);
    }

    @AutoLog(value="\u56fe\u8868\u914d\u7f6e-\u6dfb\u52a0", logType=2, operateType=2)
    @ApiOperation(value="\u56fe\u8868\u914d\u7f6e-\u6dfb\u52a0", notes="\u56fe\u8868\u914d\u7f6e-\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    public Result<?> add(@RequestBody ChartConfig chartConfig) {
        this.chartConfigService.saveChartConfig(chartConfig);
        return this.commonSuccessResult(2);
    }

    @AutoLog(value="\u56fe\u8868\u914d\u7f6e-\u7f16\u8f91", logType=2, operateType=3)
    @ApiOperation(value="\u56fe\u8868\u914d\u7f6e-\u7f16\u8f91", notes="\u56fe\u8868\u914d\u7f6e-\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    public Result<?> edit(@RequestBody ChartConfig chartConfig) {
        this.chartConfigService.updateChartConfig(chartConfig);
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u56fe\u8868\u914d\u7f6e-\u901a\u8fc7id\u5220\u9664", logType=2, operateType=4)
    @ApiOperation(value="\u56fe\u8868\u914d\u7f6e-\u901a\u8fc7id\u5220\u9664", notes="\u56fe\u8868\u914d\u7f6e-\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    public Result<?> delete(@RequestParam(name="id", required=true) String id) {
        this.chartConfigService.delChartConfig(id);
        this.dashboardChartMapper.deleteByChartId(id);
        return this.commonSuccessResult(4);
    }

    @AutoLog(value="\u56fe\u8868\u914d\u7f6e-\u6279\u91cf\u5220\u9664", logType=2, operateType=4)
    @ApiOperation(value="\u56fe\u8868\u914d\u7f6e-\u6279\u91cf\u5220\u9664", notes="\u56fe\u8868\u914d\u7f6e-\u6279\u91cf\u5220\u9664")
    @GetMapping(value={"/deleteBatch"})
    public Result<?> deleteBatch(@RequestParam(name="ids", required=true) String ids) {
        List<String> idList = Arrays.asList(ids.split(","));
        this.chartConfigService.delBatchChartConfig(idList);
        return this.commonSuccessResult(4);
    }

    @ApiOperation(value="\u56fe\u8868\u914d\u7f6e-\u901a\u8fc7id\u67e5\u8be2", notes="\u56fe\u8868\u914d\u7f6e-\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    public Result<?> queryById(@RequestParam(name="id", required=true) String id) {
        ChartConfig chartConfig = (ChartConfig)this.chartConfigService.getById((Serializable)((Object)id));
        return Result.ok(chartConfig);
    }

    @AutoLog(value="\u56fe\u8868\u914d\u7f6e-\u5bfc\u51faExcel", logType=2, operateType=6)
    @RequestMapping(value={"/exportXls"}, method={RequestMethod.GET})
    public ModelAndView exportXls(HttpServletRequest request, ChartConfig chartConfig) {
        return super.exportXls(request, chartConfig, ChartConfig.class, "\u56fe\u8868\u914d\u7f6e");
    }

    @AutoLog(value="\u56fe\u8868\u914d\u7f6e-\u5bfc\u5165Excel", logType=2, operateType=5)
    @RequestMapping(value={"/importExcel"}, method={RequestMethod.POST})
    public Result<?> importExcel(HttpServletRequest request, HttpServletResponse response) {
        return super.importExcel(request, response, ChartConfig.class);
    }
}

