/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.query.QueryGenerator;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.InterfaceUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.system.entity.ThirdAuth;
import com.els.modules.system.service.ThirdAuthService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.SecurityUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u7b2c\u4e09\u65b9\u7cfb\u7edf\u51ed\u8bc1\u914d\u7f6e"})
@RestController
@RequestMapping(value={"/system/thirdAuth"})
public class ThirdAuthController
extends BaseController<ThirdAuth, ThirdAuthService> {
    private static final String SRM_INTERFACE_CODE = "getInterfaceSsoToken";
    @Autowired
    private ThirdAuthService thirdAuthService;
    @Resource
    private InterfaceUtil interfaceUtil;

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    public Result<?> queryPageList(ThirdAuth thirdAuth, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper<ThirdAuth> queryWrapper = QueryGenerator.initQueryWrapper(thirdAuth, req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        queryWrapper.eq((Object)"els_account", (Object)TenantContext.getTenant());
        IPage pageList = this.thirdAuthService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok(pageList);
    }

    @AutoLog(value="\u7b2c\u4e09\u65b9\u7cfb\u7edf\u51ed\u8bc1\u914d\u7f6e-\u6dfb\u52a0")
    @ApiOperation(value="\u6dfb\u52a0", notes="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    public Result<?> add(@RequestBody ThirdAuth thirdAuth) {
        this.thirdAuthService.saveThirdAuth(thirdAuth);
        return Result.ok(thirdAuth);
    }

    @AutoLog(value="\u7b2c\u4e09\u65b9\u7cfb\u7edf\u51ed\u8bc1\u914d\u7f6e-\u7f16\u8f91")
    @ApiOperation(value="\u7f16\u8f91", notes="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    public Result<?> edit(@RequestBody ThirdAuth thirdAuth) {
        this.thirdAuthService.updateThirdAuth(thirdAuth);
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u7b2c\u4e09\u65b9\u7cfb\u7edf\u51ed\u8bc1\u914d\u7f6e-\u901a\u8fc7id\u5220\u9664")
    @ApiOperation(value="\u901a\u8fc7id\u5220\u9664", notes="\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    public Result<?> delete(@RequestParam(name="id") String id) {
        this.thirdAuthService.delThirdAuth(id);
        return this.commonSuccessResult(4);
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2", notes="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    public Result<?> queryById(@RequestParam(name="id") String id) {
        ThirdAuth thirdAuth = (ThirdAuth)this.thirdAuthService.getById((Serializable)((Object)id));
        return Result.ok(thirdAuth);
    }

    @ApiOperation(value="\u83b7\u53d6\u63a5\u53e3\u5e73\u53f0\u5355\u70b9\u767b\u5f55token", notes="\u83b7\u53d6\u63a5\u53e3\u5e73\u53f0\u5355\u70b9\u767b\u5f55token")
    @GetMapping(value={"/getInterfaceToken"})
    public Result<?> getInterfaceToken() {
        LoginUser sysUser = (LoginUser)SecurityUtils.getSubject().getPrincipal();
        JSONObject param = new JSONObject();
        param.put("bus_account", (Object)sysUser.getElsAccount());
        param.put("srm_interface_code", (Object)SRM_INTERFACE_CODE);
        JSONObject body = new JSONObject();
        body.put("subAccount", (Object)sysUser.getSubAccount());
        param.put("body", (Object)body);
        JSONObject result = this.interfaceUtil.callInterface(sysUser.getElsAccount(), sysUser.getSubAccount(), param, null);
        return Result.ok(result);
    }

    @ApiOperation(value="\u83b7\u53d6\u5355\u70b9\u767b\u5f55\u5730\u5740", notes="\u83b7\u53d6\u5355\u70b9\u767b\u5f55\u5730\u5740")
    @GetMapping(value={"/getSSOUrl"})
    public Result<?> getSSOUrl(@RequestParam(name="type") String type) {
        JSONObject result = new JSONObject();
        result.put("token", (Object)this.thirdAuthService.getSSOUrl(type));
        return Result.ok(result);
    }

    @GetMapping(value={"/test"})
    public Result<?> test() {
        JSONObject param = new JSONObject();
        param.put("bus_account", (Object)"100000");
        param.put("srm_interface_code", (Object)SRM_INTERFACE_CODE);
        JSONObject body = new JSONObject();
        body.put("subAccount", (Object)"admin");
        param.put("body", (Object)body);
        JSONObject result = this.interfaceUtil.callInterface("100000", "10001", param, null);
        return Result.ok(result);
    }
}

