/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.RedisUtil;
import com.els.common.util.SpringContextUtils;
import com.els.config.mybatis.TenantContext;
import com.els.modules.integration.service.SrmToIPaasService;
import com.els.modules.system.entity.ThirdAuth;
import com.els.modules.system.mapper.ThirdAuthMapper;
import com.els.modules.system.service.ElsIpaasConfigService;
import com.els.modules.system.service.ThirdAuthService;
import com.els.modules.system.util.I18nUtil;
import java.io.Serializable;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ThirdAuthServiceImpl
extends BaseServiceImpl<ThirdAuthMapper, ThirdAuth>
implements ThirdAuthService {
    private static final Logger log = LoggerFactory.getLogger(ThirdAuthServiceImpl.class);
    public static final String REDIS_KEY = "sys:thirdAuth:";
    @Resource
    private RedisUtil redisUtil;
    @Autowired
    private ElsIpaasConfigService elsIpaasConfigService;

    private String getRedisKey(String elsAccount, String appType) {
        StringBuilder redisKey = new StringBuilder(REDIS_KEY);
        redisKey.append(elsAccount);
        redisKey.append(appType);
        return redisKey.toString();
    }

    @Override
    public void saveThirdAuth(ThirdAuth thirdAuth) {
        ThirdAuth auth = (ThirdAuth)((ThirdAuthMapper)this.baseMapper).selectOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"els_account", (Object)TenantContext.getTenant())).eq((Object)"app_type", (Object)thirdAuth.getAppType()));
        if (auth != null) {
            throw new ELSBootException("\u5df2\u7ecf\u5b58\u5728\u5e94\u7528\u7c7b\u578b\uff0c\u4e0d\u80fd\u91cd\u590d\u6dfb\u52a0\uff01");
        }
        ((ThirdAuthMapper)this.baseMapper).insert(thirdAuth);
    }

    @Override
    public void updateThirdAuth(ThirdAuth thirdAuth) {
        thirdAuth.setAppType(null);
        ((ThirdAuthMapper)this.baseMapper).updateById(thirdAuth);
        this.redisUtil.del(this.getRedisKey(thirdAuth.getElsAccount(), thirdAuth.getAppType()));
    }

    @Override
    public void delThirdAuth(String id) {
        ThirdAuth thirdAuth = (ThirdAuth)((ThirdAuthMapper)this.baseMapper).selectById((Serializable)((Object)id));
        ((ThirdAuthMapper)this.baseMapper).deleteById((Serializable)((Object)id));
        this.redisUtil.del(this.getRedisKey(thirdAuth.getElsAccount(), thirdAuth.getAppType()));
    }

    @Override
    public ThirdAuth getThirdAuthByType(String elsAccount, String appType) {
        ThirdAuth auth = (ThirdAuth)this.redisUtil.get(this.getRedisKey(elsAccount, appType));
        if (auth != null) {
            return auth;
        }
        auth = (ThirdAuth)((ThirdAuthMapper)this.baseMapper).selectOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"els_account", (Object)elsAccount)).eq((Object)"app_type", (Object)appType));
        if (auth != null) {
            this.redisUtil.set(this.getRedisKey(elsAccount, appType), auth, 14400L);
        }
        return auth;
    }

    @Override
    public String getSSOUrl(String type) {
        String elsAccount = TenantContext.getTenant();
        if (type.equals("2")) {
            SrmToIPaasService srmToIPaasService = SpringContextUtils.getBean(SrmToIPaasService.class);
            ElsIpaasConfigService elsIpaasConfigService = SpringContextUtils.getBean(ElsIpaasConfigService.class);
            JSONObject param = new JSONObject();
            JSONObject body = new JSONObject();
            body.put("elsAccount", (Object)elsAccount);
            param.put("interface_code", (Object)"getToken");
            param.put("body", (Object)body);
            JSONObject object = srmToIPaasService.callIPaasInterface(param, "valueAddedApplication", elsIpaasConfigService.getIpaasInterfaceCode("get-tenant-token"));
            if ("200".equals(object.getString("code"))) {
                log.info("callIPaasInterface_result:" + object.toJSONString());
                return object.getJSONObject("data").getJSONObject("result").getString("token");
            }
            throw new ELSBootException(object.getString("message"));
        }
        throw new ELSBootException(I18nUtil.translate("i18n_alert_AcxMKW_6151ff74", "\u7c7b\u578b\u4e0d\u5b58\u5728\uff01"));
    }
}

