/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.util;

import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;

public class AopElUtils {
    private static final ExpressionParser EXPRESSION_PARSER = new SpelExpressionParser();
    private static final ConcurrentMap<String, Expression> EXPRESSION_MAP = Maps.newConcurrentMap();

    public static EvaluationContext buildContext(ProceedingJoinPoint point, Object result) {
        EvaluationContext context = AopElUtils.buildContext(point);
        context.setVariable("result", result);
        return context;
    }

    public static EvaluationContext buildContext(ProceedingJoinPoint point) {
        StandardEvaluationContext context = new StandardEvaluationContext();
        MethodSignature ms = (MethodSignature)point.getSignature();
        String[] parameterNames = ms.getParameterNames();
        Object[] args = point.getArgs();
        for (int i = 0; i < parameterNames.length; ++i) {
            context.setVariable(parameterNames[i], args[i]);
        }
        return context;
    }

    public static Expression getExpressionByKey(String key) {
        if (EXPRESSION_MAP.containsKey(key)) {
            return (Expression)EXPRESSION_MAP.get(key);
        }
        Expression expression = EXPRESSION_PARSER.parseExpression(key);
        EXPRESSION_MAP.put(key, expression);
        return expression;
    }

    public static Map getParameters(ProceedingJoinPoint point) {
        MethodSignature ms = (MethodSignature)point.getSignature();
        String[] parameterNames = ms.getParameterNames();
        Object[] args = point.getArgs();
        HashMap paramMap = Maps.newHashMap();
        for (int i = 0; i < parameterNames.length; ++i) {
            if (!(args[i] instanceof Serializable)) continue;
            paramMap.put(parameterNames[i], args[i]);
        }
        return paramMap;
    }
}

