/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.controller;

import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.vo.LoginUser;
import com.els.modules.system.entity.ElsPasswordSecurity;
import com.els.modules.system.enums.i18n.I18nRecordOperaEnum;
import com.els.modules.system.service.ElsPasswordSecurityService;
import com.els.modules.system.util.I18nUtil;
import com.els.modules.system.vo.ElsPasswordSecurityVo;
import com.els.modules.system.vo.ElsPwSecurityEditVo;
import com.els.modules.system.vo.ElsPwSecuritySaveVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import javax.validation.Valid;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.SecurityUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u5bc6\u7801\u7b56\u7565\u4fe1\u606f"})
@RestController
@RequestMapping(value={"/elsPasswordSecurity"})
public class ElsPasswordSecurityController
extends BaseController<ElsPasswordSecurity, ElsPasswordSecurityService> {
    @Autowired
    private ElsPasswordSecurityService elsPasswordSecurityService;

    @AutoLog(value="\u5bc6\u7801\u7b56\u7565\u4fe1\u606f-\u6dfb\u52a0")
    @ApiOperation(value="\u6dfb\u52a0\u5bc6\u7801\u7b56\u7565\u4fe1\u606f", notes="\u6dfb\u52a0\u5bc6\u7801\u7b56\u7565\u4fe1\u606f")
    @PostMapping(value={"/addElsPwSecurity"})
    public Result<?> add(@RequestBody @Valid ElsPwSecuritySaveVo elsPwSecuritySaveVo) {
        LoginUser sysUser = (LoginUser)SecurityUtils.getSubject().getPrincipal();
        elsPwSecuritySaveVo.setElsAccount(this.getTenantId()).setCreateBy(sysUser.getSubAccount()).setUpdateBy(sysUser.getSubAccount());
        this.elsPasswordSecurityService.saveElsPasswordSecurity(elsPwSecuritySaveVo);
        return Result.ok();
    }

    @AutoLog(value="\u5bc6\u7801\u7b56\u7565\u4fe1\u606f-\u7f16\u8f91")
    @ApiOperation(value="\u7f16\u8f91\u5bc6\u7801\u7b56\u7565\u4fe1\u606f", notes="\u7f16\u8f91\u5bc6\u7801\u7b56\u7565\u4fe1\u606f")
    @PostMapping(value={"/editElsPwSecurity"})
    public Result<?> edit(@RequestBody @Valid ElsPwSecurityEditVo elsPwSecurityEditVo) {
        Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)elsPwSecurityEditVo.getId()), (String)I18nUtil.translate(I18nRecordOperaEnum.I18N_NEED_RECORD_ID));
        LoginUser sysUser = (LoginUser)SecurityUtils.getSubject().getPrincipal();
        elsPwSecurityEditVo.setElsAccount(this.getTenantId()).setUpdateBy(sysUser.getSubAccount());
        this.elsPasswordSecurityService.updateElsPasswordSecurity(elsPwSecurityEditVo);
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u5bc6\u7801\u7b56\u7565\u4fe1\u606f\u8868")
    @ApiOperation(value="\u83b7\u53d6\u5bc6\u7801\u7b56\u7565\u8bb0\u5f55\u4fe1\u606f")
    @RequestMapping(value={"/getElsPasswordSecurity"}, method={RequestMethod.POST})
    public Result<?> getElsPasswordSecurity() {
        ElsPasswordSecurityVo elsPasswordSecurityVo = this.elsPasswordSecurityService.getElsPasswordSecurity(this.getTenantId());
        return Result.ok(elsPasswordSecurityVo);
    }

    @AutoLog(value="\u9a8c\u8bc1\u5bc6\u7801\u662f\u5426\u5230\u671f\u672a\u4fee\u6539")
    @ApiOperation(value="\u9a8c\u8bc1\u5bc6\u7801\u662f\u5426\u5230\u671f\u672a\u4fee\u6539")
    @RequestMapping(value={"/verifyModifyInterval"}, method={RequestMethod.POST})
    public Result<Object> verifyModifyInterval() {
        String elsaAccount = this.getTenantId();
        String elsSubAccount = ((LoginUser)SecurityUtils.getSubject().getPrincipal()).getSubAccount();
        String result = this.elsPasswordSecurityService.verifyModifyInterval(elsaAccount, elsSubAccount);
        return Result.ok((Object)result);
    }
}

