/*
 * Decompiled with CFR 0.152.
 */
package com.els.framework.poi.excel.export;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.BooleanUtil;
import com.alibaba.fastjson.JSONObject;
import com.els.common.exception.ELSBootException;
import com.els.framework.poi.excel.ExcelEntity;
import com.els.framework.poi.excel.ExcelExportClassColumnDTO;
import com.els.framework.poi.excel.entity.ExportFieldAnalysisParams;
import com.els.framework.poi.excel.entity.ExportParams;
import com.els.framework.poi.excel.entity.enmus.ExcelType;
import com.els.framework.poi.excel.entity.params.ExcelExportEntity;
import com.els.framework.poi.excel.entity.vo.ExcelTemplateConfigItemVO;
import com.els.framework.poi.excel.entity.vo.ExcelTemplateHeadVO;
import com.els.framework.poi.excel.entity.vo.ExcelUserColumnDefineVO;
import com.els.framework.poi.excel.export.base.ColumnDefineExcelExportBase;
import com.els.framework.poi.excel.export.styler.IExcelExportStyler;
import com.els.framework.poi.exception.excel.ExcelExportException;
import com.els.framework.poi.exception.excel.enums.ExcelExportEnum;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Drawing;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ColumnDefineExcelExportServer
extends ColumnDefineExcelExportBase {
    private static final Logger LOGGER = LoggerFactory.getLogger(ColumnDefineExcelExportServer.class);
    private int maxNum = 60000;

    private int createHeaderAndTitle(ExportParams entity, Sheet sheet, Workbook workbook, List<ExcelExportEntity> excelParams) {
        int rows = 0;
        int feildWidth = this.getFieldWidth(excelParams);
        if (entity.getTitle() != null) {
            rows += this.createHeaderRow(entity, sheet, workbook, feildWidth);
        }
        rows += this.createTitleRow(entity, sheet, workbook, rows, excelParams);
        sheet.createFreezePane(0, rows, 0, rows);
        return rows;
    }

    public int createHeaderRow(ExportParams entity, Sheet sheet, Workbook workbook, int feildWidth) {
        Row row = sheet.createRow(0);
        row.setHeight(entity.getTitleHeight());
        this.createStringCell(row, 0, entity.getTitle(), this.getExcelExportStyler().getHeaderStyle(entity.getHeaderColor()), null);
        for (int i = 1; i <= feildWidth; ++i) {
            this.createStringCell(row, i, "", this.getExcelExportStyler().getHeaderStyle(entity.getHeaderColor()), null);
        }
        if (feildWidth > 0) {
            sheet.addMergedRegion(new CellRangeAddress(0, 0, 0, feildWidth));
        }
        if (entity.getSecondTitle() != null) {
            row = sheet.createRow(1);
            row.setHeight(entity.getSecondTitleHeight());
            CellStyle style = workbook.createCellStyle();
            style.setAlignment(HorizontalAlignment.RIGHT);
            this.createStringCell(row, 0, entity.getSecondTitle(), style, null);
            for (int i = 1; i <= feildWidth; ++i) {
                this.createStringCell(row, i, "", this.getExcelExportStyler().getHeaderStyle(entity.getHeaderColor()), null);
            }
            if (feildWidth > 0) {
                sheet.addMergedRegion(new CellRangeAddress(1, 1, 0, feildWidth));
            }
            return 2;
        }
        return 1;
    }

    public void createSheetByTemplateHead(Workbook workbook, ExportParams entity, List<ExcelExportClassColumnDTO> columnList, ExcelTemplateHeadVO templateHeadVO, Collection<JSONObject> dataSet) {
        this.createSheetByConfig(workbook, entity, columnList, null, templateHeadVO, null, dataSet);
    }

    public void createSheetByTemplateItem(Workbook workbook, ExportParams entity, List<ExcelExportClassColumnDTO> columnList, List<ExcelTemplateConfigItemVO> templateConfigItemList, Collection<JSONObject> dataSet) {
        if (CollUtil.isEmpty(templateConfigItemList)) {
            templateConfigItemList = columnList.stream().filter(x -> null != x.getExcel() && !x.getExcel().isIgnore() && !BooleanUtil.isTrue((Boolean)x.getCollection())).map(x -> {
                ExcelTemplateConfigItemVO t = new ExcelTemplateConfigItemVO();
                ExcelEntity excel1 = x.getExcel();
                t.setFieldName(x.getFileName());
                t.setFieldType(x.getFileType());
                t.setSortOrder(CharSequenceUtil.isNotBlank((CharSequence)excel1.getOrderNum()) ? Integer.valueOf(Integer.parseInt(excel1.getOrderNum())) : null);
                t.setFieldLabel("class_field_name_" + CharSequenceUtil.blankToDefault((CharSequence)excel1.getName(), (String)x.getFileName()));
                return t;
            }).collect(Collectors.toList());
        }
        if (CollUtil.isEmpty(columnList)) {
            throw new ELSBootException("i18n_alert_APWFSqjWWWWWuGA_e5064083", "\u5f53\u524d\u6570\u636e\u65e0\u53ef\u7528Excel\u5bfc\u51fa\u5217");
        }
        this.createSheetByConfig(workbook, entity, columnList, null, null, templateConfigItemList, dataSet);
    }

    public void createSheetByColumnDefine(Workbook workbook, ExportParams entity, List<ExcelExportClassColumnDTO> columnList, List<ExcelUserColumnDefineVO> columnDefineVoList, Collection<JSONObject> dataSet) {
        this.createSheetByConfig(workbook, entity, columnList, columnDefineVoList, null, null, dataSet);
    }

    private void createSheetByConfig(Workbook workbook, ExportParams entity, List<ExcelExportClassColumnDTO> columnList, List<ExcelUserColumnDefineVO> columnDefineVoList, ExcelTemplateHeadVO templateHeadVO, List<ExcelTemplateConfigItemVO> templateConfigItemList, Collection<JSONObject> dataSet) {
        Sheet sheet;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Excel version is {}", (Object)(entity.getType().equals((Object)ExcelType.HSSF) ? "03" : "07"));
        }
        if (workbook == null || entity == null || dataSet == null) {
            throw new ExcelExportException(ExcelExportEnum.PARAMETER_ERROR);
        }
        this.type = entity.getType();
        if (this.type.equals((Object)ExcelType.XSSF)) {
            this.maxNum = 1000000;
        }
        try {
            sheet = workbook.createSheet(entity.getSheetName());
        }
        catch (Exception e) {
            sheet = workbook.createSheet();
        }
        try {
            int index;
            this.dataHanlder = entity.getDataHanlder();
            if (this.dataHanlder != null) {
                this.needHanlderList = Arrays.asList(this.dataHanlder.getNeedHandlerFields());
            }
            this.setExcelExportStyler((IExcelExportStyler)entity.getStyle().getConstructor(Workbook.class).newInstance(workbook));
            Drawing patriarch = sheet.createDrawingPatriarch();
            ArrayList<ExcelExportEntity> excelParams = new ArrayList<ExcelExportEntity>();
            if (entity.isAddIndex()) {
                excelParams.add(this.indexExcelEntity(entity));
            }
            ExportFieldAnalysisParams fieldAnalysisParams = new ExportFieldAnalysisParams().setTargetTitleKey("default-key").setColumnFilterTitleMap(Maps.newHashMap());
            String targetId = null;
            Map<String, ExcelExportClassColumnDTO> classColumnList = columnList.stream().collect(Collectors.toMap(ExcelExportClassColumnDTO::getFileName, Function.identity(), (v1, v2) -> v2));
            if ("head_item".equals(entity.getExportType()) || "custom".equals(entity.getExportType())) {
                this.filterExcelFieldByTemplateHead(targetId, excelParams, classColumnList, templateHeadVO, fieldAnalysisParams);
            } else if ("item".equals(entity.getExportType())) {
                this.filterExcelFieldByTemplateItem(targetId, excelParams, classColumnList, templateConfigItemList, fieldAnalysisParams);
            } else {
                this.filterExcelFieldByColumnDefine(targetId, excelParams, classColumnList, columnDefineVoList, fieldAnalysisParams);
            }
            if (CollUtil.isEmpty(excelParams)) {
                throw new ELSBootException("i18n_alert_APWFSqjWWWWWuGA_e5064083", "\u5f53\u524d\u6570\u636e\u65e0\u53ef\u7528Excel\u5bfc\u51fa\u5217");
            }
            this.sortExportColumn(excelParams);
            int titleHeight = index = entity.isCreateHeadRows() ? this.createHeaderAndTitle(entity, sheet, workbook, excelParams) : 0;
            this.setCellWith(excelParams, sheet);
            short rowHeight = this.getRowHeight(excelParams);
            this.setCurrentIndex(1);
            Iterator<JSONObject> its = dataSet.iterator();
            ArrayList<JSONObject> tempList = new ArrayList<JSONObject>();
            while (its.hasNext()) {
                JSONObject t = its.next();
                index += this.createCells(patriarch, index, t, excelParams, sheet, workbook, rowHeight);
                tempList.add(t);
                if (index < this.maxNum) continue;
                break;
            }
            this.mergeCells(sheet, excelParams, titleHeight);
            if (entity.getFreezeCol() != 0) {
                sheet.createFreezePane(entity.getFreezeCol(), 0, entity.getFreezeCol(), 0);
            }
            its = dataSet.iterator();
            int le = tempList.size();
            for (int i = 0; i < le; ++i) {
                its.next();
                its.remove();
            }
            this.addStatisticsRow(this.getExcelExportStyler().getStyles(true, null), sheet);
            if (dataSet.size() > 0) {
                this.createSheetByColumnDefine(workbook, entity, columnList, columnDefineVoList, dataSet);
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new ExcelExportException(ExcelExportEnum.EXPORT_ERROR, e.getCause());
        }
    }

    public void createSheetForMap(Workbook workbook, ExportParams entity, List<ExcelExportEntity> entityList, Collection<? extends Map<?, ?>> dataSet) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Excel version is {}", (Object)(entity.getType().equals((Object)ExcelType.HSSF) ? "03" : "07"));
        }
        if (workbook == null || entity == null || entityList == null || dataSet == null) {
            throw new ExcelExportException(ExcelExportEnum.PARAMETER_ERROR);
        }
        this.type = entity.getType();
        if (this.type.equals((Object)ExcelType.XSSF)) {
            this.maxNum = 1000000;
        }
        Sheet sheet = null;
        try {
            sheet = workbook.createSheet(entity.getSheetName());
        }
        catch (Exception e) {
            sheet = workbook.createSheet();
        }
        try {
            int index;
            this.dataHanlder = entity.getDataHanlder();
            if (this.dataHanlder != null) {
                this.needHanlderList = Arrays.asList(this.dataHanlder.getNeedHandlerFields());
            }
            this.setExcelExportStyler((IExcelExportStyler)entity.getStyle().getConstructor(Workbook.class).newInstance(workbook));
            Drawing patriarch = sheet.createDrawingPatriarch();
            ArrayList<ExcelExportEntity> excelParams = new ArrayList<ExcelExportEntity>();
            if (entity.isAddIndex()) {
                excelParams.add(this.indexExcelEntity(entity));
            }
            excelParams.addAll(entityList);
            this.sortExportColumn(excelParams);
            int titleHeight = index = entity.isCreateHeadRows() ? this.createHeaderAndTitle(entity, sheet, workbook, excelParams) : 0;
            this.setCellWith(excelParams, sheet);
            short rowHeight = this.getRowHeight(excelParams);
            this.setCurrentIndex(1);
            Iterator<Map<?, ?>> its = dataSet.iterator();
            ArrayList tempList = new ArrayList();
            while (its.hasNext()) {
                Map<?, ?> t = its.next();
                index += this.createCells(patriarch, index, t, excelParams, sheet, workbook, rowHeight);
                tempList.add(t);
                if (index < this.maxNum) continue;
                break;
            }
            if (entity.getFreezeCol() != 0) {
                sheet.createFreezePane(entity.getFreezeCol(), 0, entity.getFreezeCol(), 0);
            }
            this.mergeCells(sheet, excelParams, titleHeight);
            its = dataSet.iterator();
            int le = tempList.size();
            for (int i = 0; i < le; ++i) {
                its.next();
                its.remove();
            }
            if (dataSet.size() > 0) {
                this.createSheetForMap(workbook, entity, entityList, dataSet);
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new ExcelExportException(ExcelExportEnum.EXPORT_ERROR, e.getCause());
        }
    }

    private int createTitleRow(ExportParams title, Sheet sheet, Workbook workbook, int index, List<ExcelExportEntity> excelParams) {
        Row row = sheet.createRow(index);
        int rows = this.getRowNums(excelParams);
        row.setHeight((short)450);
        Row listRow = null;
        if (rows == 2) {
            listRow = sheet.createRow(index + 1);
            listRow.setHeight((short)450);
        }
        int cellIndex = 0;
        CellStyle titleStyle = this.getExcelExportStyler().getTitleStyle(title.getColor());
        int exportFieldTitleSize = excelParams.size();
        for (int i = 0; i < exportFieldTitleSize; ++i) {
            ExcelExportEntity entity = excelParams.get(i);
            if (StringUtils.isNotBlank((CharSequence)entity.getName())) {
                this.createStringCell(row, cellIndex, entity.getName(), titleStyle, entity);
            }
            if (entity.getList() != null) {
                List<ExcelExportEntity> sTitel = entity.getList();
                if (StringUtils.isNotBlank((CharSequence)entity.getName()) && sTitel.size() > 1) {
                    sheet.addMergedRegion(new CellRangeAddress(index, index, cellIndex, cellIndex + sTitel.size() - 1));
                }
                int size = sTitel.size();
                for (int j = 0; j < size; ++j) {
                    this.createStringCell(rows == 2 ? listRow : row, cellIndex, sTitel.get(j).getName(), titleStyle, entity);
                    ++cellIndex;
                }
                --cellIndex;
            } else if (rows == 2) {
                this.createStringCell(listRow, cellIndex, "", titleStyle, entity);
                sheet.addMergedRegion(new CellRangeAddress(index, index + 1, cellIndex, cellIndex));
            }
            ++cellIndex;
        }
        return rows;
    }

    private int getRowNums(List<ExcelExportEntity> excelParams) {
        for (int i = 0; i < excelParams.size(); ++i) {
            if (excelParams.get(i).getList() == null || !StringUtils.isNotBlank((CharSequence)excelParams.get(i).getName())) continue;
            return 2;
        }
        return 1;
    }

    private ExcelExportEntity indexExcelEntity(ExportParams entity) {
        ExcelExportEntity exportEntity = new ExcelExportEntity();
        exportEntity.setOrderNum(0);
        exportEntity.setName(entity.getIndexName());
        exportEntity.setWidth(10.0);
        exportEntity.setFormat("isAddIndex");
        return exportEntity;
    }
}

