/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.aspect;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.service.IService;
import com.els.common.aspect.annotation.PermissionDataOpt;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.util.JwtUtil;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.modules.system.entity.PermissionData;
import com.els.modules.system.service.PermissionDataService;
import com.els.modules.system.util.AdminFlagUtil;
import com.els.modules.system.util.I18nUtil;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class PermissionDataOptAspect {
    private static final Logger log = LoggerFactory.getLogger(PermissionDataOptAspect.class);
    @Autowired
    private PermissionDataService permissionDataService;

    @Pointcut(value="@annotation(com.els.common.aspect.annotation.PermissionDataOpt)")
    public void pointCut() {
    }

    @Around(value="pointCut()")
    public Object arround(ProceedingJoinPoint point) throws Throwable {
        JSONObject companySet;
        String adminFlag;
        IService iService;
        Object obj;
        HttpServletRequest request = SpringContextUtils.getHttpServletRequest();
        MethodSignature signature = (MethodSignature)point.getSignature();
        Method method = signature.getMethod();
        PermissionDataOpt permissionDataOpt = method.getAnnotation(PermissionDataOpt.class);
        String account = JwtUtil.getUserNameByToken(request);
        String businessType = permissionDataOpt.businessType();
        Class<? extends IService> beanName = permissionDataOpt.beanClass();
        Object param = point.getArgs().length > 0 ? point.getArgs()[0] : new Object();
        String dataId = null;
        JSONObject paramObj = null;
        JSONObject dbObj = null;
        if (param instanceof BaseEntity) {
            paramObj = this.getJsonByObejct(param);
            dataId = paramObj.getString("id");
        } else if (param instanceof String) {
            dataId = (String)param;
        }
        if (StrUtil.isNotBlank(dataId) && (obj = (iService = SpringContextUtils.getBean(beanName)).getById((Serializable)((Object)dataId))) != null) {
            dbObj = this.getJsonByObejct(obj);
        }
        if ("1".equals(adminFlag = AdminFlagUtil.getAdminFlag())) {
            return point.proceed();
        }
        String permissionScope = null;
        boolean optFlag = false;
        LoginUser user = SysUtil.getLoginUser();
        if (user != null && (companySet = user.getCompanySet()) != null) {
            String flag = companySet.getString("dataPermissionOpt");
            permissionScope = companySet.getString("permissionScope");
            if ("1".equals(flag)) {
                optFlag = true;
            }
        }
        if (!optFlag || StrUtil.isBlank(permissionScope)) {
            return point.proceed();
        }
        List scopeList = StrUtil.split(permissionScope, (CharSequence)",");
        if (!scopeList.contains(businessType)) {
            return point.proceed();
        }
        List<PermissionData> dataList = this.permissionDataService.getPermissionDataList(account.split("_")[0], account.split("_")[1], businessType);
        if (dataList != null && !dataList.isEmpty()) {
            if (dbObj != null) {
                this.checkPerission(dataList, dbObj);
            }
            if (paramObj != null) {
                this.checkPerission(dataList, paramObj);
            }
        } else {
            throw new ELSBootException(I18nUtil.translate("i18n_alert_LjeyBjERrESAcjWFtkbWWVKHRvjW_d6954df8", "\u60a8\u7684\u8d26\u53f7\u6ca1\u6709\u914d\u7f6e\u8be5\u4e1a\u52a1\u7c7b\u578b\u7684\u6570\u636e\u64cd\u4f5c\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01"));
        }
        return point.proceed();
    }

    private void checkPerission(List<PermissionData> dataOptList, JSONObject dbObj) {
        if (dataOptList.isEmpty()) {
            throw new ELSBootException(I18nUtil.translate("i18n_alert_LjeyBjERrESAcjWFtkbWWVKHRvjW_d6954df8", "\u60a8\u7684\u8d26\u53f7\u6ca1\u6709\u914d\u7f6e\u8be5\u4e1a\u52a1\u7c7b\u578b\u7684\u6570\u636e\u64cd\u4f5c\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01"));
        }
        Map<String, List<PermissionData>> optMap = dataOptList.parallelStream().collect(Collectors.groupingBy(PermissionData::getPermissionField));
        for (String permissionField : optMap.keySet()) {
            String dataValue = dbObj.getString(permissionField);
            if (StrUtil.isEmpty((CharSequence)dataValue)) continue;
            List<PermissionData> dataList = optMap.get(permissionField);
            boolean checkFlag = false;
            for (PermissionData data : dataList) {
                String permissionValue = data.getPermissionValue();
                if (!permissionValue.equals(dataValue) || !"1".equals(data.getOperation())) continue;
                checkFlag = true;
                break;
            }
            if (checkFlag) continue;
            throw new ELSBootException(I18nUtil.translate("i18n_alert_LjeyvArWFtkbWImWtBjERWWWWWWWWWjWFtkbWWVKHRvjW_9af7744c", "\u60a8\u7684\u8d26\u53f7\u5f00\u542f\u4e86\u6570\u636e\u64cd\u4f5c\u6743\u9650\u68c0\u67e5\uff0c\u4f46\u6ca1\u6709\u914d\u7f6e${0}_${1}\u7684\u6570\u636e\u64cd\u4f5c\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01", permissionField, dataValue));
        }
    }

    private JSONObject getJsonByObejct(Object param) {
        ObjectMapper mapper = new ObjectMapper();
        String json = "{}";
        try {
            json = mapper.writeValueAsString(param);
        }
        catch (JsonProcessingException e) {
            log.error("json\u89e3\u6790\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return JSONObject.parseObject((String)json);
    }
}

