/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.controller;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.api.dto.SelectionsDto;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.query.QueryGenerator;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.ConvertUtils;
import com.els.framework.poi.excel.entity.ExportParams;
import com.els.framework.poi.excel.view.ELSEntityExcelView;
import com.els.modules.system.entity.ElsPasswordPolicy;
import com.els.modules.system.service.ElsPasswordPolicyService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.shiro.SecurityUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;

@Api(tags={"\u5bc6\u7801\u7b56\u7565\u4fe1\u606f"})
@RestController
@RequestMapping(value={"/com/elsPasswordPolicy"})
public class ElsPasswordPolicyController
extends BaseController<ElsPasswordPolicy, ElsPasswordPolicyService> {
    @Autowired
    private ElsPasswordPolicyService elsPasswordPolicyService;

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    public Result<?> queryPageList(ElsPasswordPolicy elsPasswordPolicy, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper<ElsPasswordPolicy> queryWrapper = QueryGenerator.initQueryWrapper(elsPasswordPolicy, req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.elsPasswordPolicyService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok(pageList);
    }

    @AutoLog(value="\u5bc6\u7801\u7b56\u7565\u4fe1\u606f-\u6dfb\u52a0")
    @ApiOperation(value="\u6dfb\u52a0", notes="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    public Result<?> add(@RequestBody ElsPasswordPolicy elsPasswordPolicy) {
        this.elsPasswordPolicyService.saveElsPasswordPolicy(elsPasswordPolicy);
        return Result.ok(elsPasswordPolicy);
    }

    @AutoLog(value="\u5bc6\u7801\u7b56\u7565\u4fe1\u606f-\u7f16\u8f91")
    @ApiOperation(value="\u7f16\u8f91", notes="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    public Result<?> edit(@RequestBody ElsPasswordPolicy elsPasswordPolicy) {
        this.elsPasswordPolicyService.updateElsPasswordPolicy(elsPasswordPolicy);
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u5bc6\u7801\u7b56\u7565\u4fe1\u606f-\u901a\u8fc7id\u5220\u9664")
    @ApiOperation(value="\u901a\u8fc7id\u5220\u9664", notes="\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    public Result<?> delete(@RequestParam(name="id", required=true) String id) {
        this.elsPasswordPolicyService.delElsPasswordPolicy(id);
        return this.commonSuccessResult(4);
    }

    @AutoLog(value="\u5bc6\u7801\u7b56\u7565\u4fe1\u606f-\u6279\u91cf\u5220\u9664")
    @ApiOperation(value="\u6279\u91cf\u5220\u9664", notes="\u6279\u91cf\u5220\u9664")
    @GetMapping(value={"/deleteBatch"})
    public Result<?> deleteBatch(@RequestParam(name="ids", required=true) String ids) {
        List<String> idList = Arrays.asList(ids.split(","));
        this.elsPasswordPolicyService.delBatchElsPasswordPolicy(idList);
        return this.commonSuccessResult(4);
    }

    @AutoLog(value="\u5bc6\u7801\u7b56\u7565\u4fe1\u606f-\u901a\u8fc7id\u67e5\u8be2")
    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2", notes="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    public Result<?> queryById(@RequestParam(name="id", required=true) String id) {
        ElsPasswordPolicy elsPasswordPolicy = (ElsPasswordPolicy)this.elsPasswordPolicyService.getById((Serializable)((Object)id));
        return Result.ok(elsPasswordPolicy);
    }

    @PostMapping(value={"/exportXls"})
    public ModelAndView exportXls(HttpServletRequest request, ElsPasswordPolicy elsPasswordPolicy, @RequestBody SelectionsDto selectionsDto) {
        List<String> selectionList;
        QueryWrapper<ElsPasswordPolicy> queryWrapper = QueryGenerator.initQueryWrapper(elsPasswordPolicy, request.getParameterMap());
        LoginUser sysUser = (LoginUser)SecurityUtils.getSubject().getPrincipal();
        String[] ids = selectionsDto.getSelections();
        if (ConvertUtils.isNotEmpty(ids) && CollectionUtil.isNotEmpty(selectionList = Arrays.asList(ids))) {
            queryWrapper.clear();
            Map parameterMap = request.getParameterMap();
            QueryGenerator.doMultiFieldsOrder(queryWrapper, parameterMap, elsPasswordPolicy);
            queryWrapper.in((Object)"id", selectionList);
        }
        List elsPasswordPolicyList = this.elsPasswordPolicyService.list((Wrapper)queryWrapper);
        ModelAndView mv = new ModelAndView((View)new ELSEntityExcelView());
        mv.addObject("fileName", (Object)"\u5bc6\u7801\u7b56\u7565\u4fe1\u606f");
        mv.addObject("entity", ElsPasswordPolicy.class);
        mv.addObject("params", (Object)new ExportParams("\u5bc6\u7801\u7b56\u7565\u4fe1\u606f", "\u5bfc\u51fa\u4eba:" + sysUser.getRealname(), "\u5bc6\u7801\u7b56\u7565\u4fe1\u606f", request.getParameter("defineColumnCode")));
        mv.addObject("data", (Object)elsPasswordPolicyList);
        return mv;
    }

    @PostMapping(value={"/importExcel"})
    public Result<?> importExcel(HttpServletRequest request, HttpServletResponse response) {
        return super.importExcel(request, response, ElsPasswordPolicy.class);
    }
}

