/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.controller;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.util.RandomUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.extra.mail.MailUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.api.dto.SelectionsDto;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.constant.CommonConstant;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.query.QueryGenerator;
import com.els.common.system.util.JwtUtil;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.ConvertUtils;
import com.els.common.util.PasswordUtil;
import com.els.common.util.RedisUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.common.util.security.ShowDocTokenUtil;
import com.els.config.mybatis.TenantContext;
import com.els.framework.poi.excel.ExcelImportUtil;
import com.els.framework.poi.excel.entity.ExportParams;
import com.els.framework.poi.excel.entity.ImportParams;
import com.els.framework.poi.excel.view.ELSEntityExcelView;
import com.els.modules.system.entity.ElsSubAccount;
import com.els.modules.system.entity.PersonalSetting;
import com.els.modules.system.entity.UserRole;
import com.els.modules.system.service.BaseImGroupService;
import com.els.modules.system.service.ElsSubAccountOrgService;
import com.els.modules.system.service.ElsSubAccountService;
import com.els.modules.system.service.PersonalSettingService;
import com.els.modules.system.service.UserRoleService;
import com.els.modules.system.util.I18nUtil;
import com.els.modules.system.vo.ElsSubAccountVO;
import com.els.modules.system.vo.UserRoleVO;
import com.google.common.collect.Lists;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;

@Api(tags={"\u7528\u6237\u7ba1\u7406"})
@RestController
@RequestMapping(value={"/elsSubAccount"})
public class ElsSubAccountController {
    private static final Logger log = LoggerFactory.getLogger(ElsSubAccountController.class);
    @Value(value="${spring.mail.host}")
    private String sendHost;
    @Value(value="${spring.mail.username}")
    private String sendUsername;
    @Value(value="${spring.mail.password}")
    private String sendPassword;
    @Autowired
    private ElsSubAccountService elsSubAccountService;
    @Autowired
    private UserRoleService userRoleService;
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private PersonalSettingService personalSettingService;

    @RequestMapping(value={"/list"}, method={RequestMethod.GET})
    public Result<IPage<ElsSubAccountVO>> queryPageList(ElsSubAccountVO user, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        Result<IPage<ElsSubAccountVO>> result = new Result<IPage<ElsSubAccountVO>>();
        QueryWrapper<ElsSubAccountVO> queryWrapper = QueryGenerator.initQueryWrapper(user, req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        queryWrapper.eq((Object)"els_account", (Object)TenantContext.getTenant());
        IPage pageList = this.elsSubAccountService.page((IPage)page, (Wrapper)queryWrapper);
        List<String> codes = pageList.getRecords().stream().filter(x -> StrUtil.isNotEmpty((CharSequence)x.getOrgCode())).flatMap(x -> Arrays.stream(x.getOrgCode().split(","))).distinct().collect(Collectors.toList());
        ElsSubAccountOrgService elsSubAccountOrgService = (ElsSubAccountOrgService)SpringContextUtils.getBean("purchaseOrganizationInfoServiceImpl");
        Map<String, String> orgMap = elsSubAccountOrgService.listDeptOrganization(codes);
        String jsonString = JSON.toJSONString((Object)pageList);
        IPage page2 = (IPage)JSON.parseObject((String)jsonString, (TypeReference)new TypeReference<Page<ElsSubAccountVO>>(){}, (Feature[])new Feature[0]);
        for (ElsSubAccountVO elsSubAccount : page2.getRecords()) {
            String orgCode = elsSubAccount.getOrgCode();
            if (!StrUtil.isNotEmpty((CharSequence)orgCode)) continue;
            ArrayList ids = Lists.newArrayList((Object[])orgCode.split(","));
            String org = ids.stream().filter(orgMap::containsKey).map(orgMap::get).collect(Collectors.joining(","));
            elsSubAccount.setOrgCode_dictText(org);
        }
        result.setSuccess(true);
        result.setResult(page2);
        return result;
    }

    @AutoLog(value="\u4f9b\u5e94\u5546\u8d26\u53f7\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @RequestMapping(value={"/otherList"}, method={RequestMethod.GET})
    @ApiOperation(value="\u4f9b\u5e94\u5546\u8d26\u53f7\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u4f9b\u5e94\u5546\u8d26\u53f7\u5206\u9875\u5217\u8868\u67e5\u8be2")
    public Result<IPage<ElsSubAccount>> queryOtherPageList(ElsSubAccount user, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        Result<IPage<ElsSubAccount>> result = new Result<IPage<ElsSubAccount>>();
        QueryWrapper<ElsSubAccount> queryWrapper = QueryGenerator.initQueryWrapper(user, req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        queryWrapper.notIn((Object)"els_account", new Object[]{TenantContext.getTenant(), "100000"});
        IPage pageList = this.elsSubAccountService.page((IPage)page, (Wrapper)queryWrapper);
        result.setSuccess(true);
        result.setResult(pageList);
        return result;
    }

    @AutoLog(value="\u7528\u6237\u8d26\u6237-\u6dfb\u52a0", operateType=2)
    @RequestMapping(value={"/add"}, method={RequestMethod.POST})
    @RequiresPermissions(value={"account:add"})
    public Result<?> add(@RequestBody JSONObject jsonObject) {
        Result result = new Result();
        String selectedRoles = jsonObject.getString("selectedroles");
        ElsSubAccount user = (ElsSubAccount)JSON.parseObject((String)jsonObject.toJSONString(), ElsSubAccount.class);
        ElsSubAccount sysUser = this.elsSubAccountService.getUserBySubAccount(user.getSubAccount());
        if (sysUser != null) {
            throw new ELSBootException(I18nUtil.translate("i18n_alert_JeyIOMKW_d8bcd3b3", "\u5b50\u8d26\u53f7\u5df2\u7ecf\u5b58\u5728\uff01"));
        }
        if (StringUtils.isNotBlank((CharSequence)user.getOrgCode())) {
            ElsSubAccountOrgService elsSubAccountOrgService = (ElsSubAccountOrgService)SpringContextUtils.getBean("purchaseOrganizationInfoServiceImpl");
            boolean includCompany = elsSubAccountOrgService.checkOrgCode(user.getOrgCode());
            Assert.isTrue((!includCompany ? 1 : 0) != 0, (String)I18nUtil.translate("i18n_alert_xGxOiFRC_4b44d29c", "\u90e8\u95e8\u4e0d\u80fd\u9009\u62e9\u516c\u53f8"));
        }
        user.setCreateTime(new Date());
        String salt = ConvertUtils.randomGen(8);
        user.setSalt(salt);
        String passwordEncode = PasswordUtil.encrypt(TenantContext.getTenant() + "_" + user.getSubAccount(), user.getPassword(), salt);
        user.setPassword(passwordEncode);
        user.setStatus(1);
        user.setDeleted(CommonConstant.DEL_FLAG_0);
        this.elsSubAccountService.addUserWithRole(user, selectedRoles);
        BaseImGroupService baseImGroupService = (BaseImGroupService)SpringContextUtils.getBean("baseImGroupServiceImpl");
        baseImGroupService.initGroup(user.getId());
        List<String> list = Arrays.asList("EMAIL", "NEWS", "VOICE", "MSG", "WECHAT", "DINGTALK");
        ArrayList<PersonalSetting> personalSettings = new ArrayList<PersonalSetting>();
        for (String str : list) {
            PersonalSetting personalSetting = new PersonalSetting();
            personalSetting.setId(UUID.randomUUID().toString().replace("-", ""));
            personalSetting.setElsAccount(user.getElsAccount());
            personalSetting.setSubAccount(user.getSubAccount());
            personalSetting.setCreateBy(user.getCreateBy());
            personalSetting.setCreateTime(new Date());
            personalSetting.setUpdateBy(user.getUpdateBy());
            personalSetting.setUpdateTime(new Date());
            personalSetting.setReceiveType(str);
            personalSetting.setIsReceive(0);
            personalSettings.add(personalSetting);
        }
        this.personalSettingService.saveBatch(personalSettings);
        result.success(I18nUtil.translate("i18n_alert_SuLRW_34dd402d", "\u6dfb\u52a0\u6210\u529f\uff01"));
        return Result.ok(user);
    }

    @AutoLog(value="\u7528\u6237\u8d26\u6237-\u7f16\u8f91", operateType=3)
    @RequestMapping(value={"/edit"}, method={RequestMethod.POST})
    @RequiresPermissions(value={"account:edit"})
    public Result<ElsSubAccount> edit(@RequestBody JSONObject jsonObject) {
        Result<ElsSubAccount> result = new Result<ElsSubAccount>();
        ElsSubAccount sysUser = (ElsSubAccount)this.elsSubAccountService.getById((Serializable)((Object)jsonObject.getString("id")));
        if (sysUser == null) {
            result.error500(I18nUtil.translate("i18n_alert_LYuIdKD_12f57c8c", "\u672a\u627e\u5230\u5bf9\u5e94\u5b9e\u4f53"));
        } else {
            ElsSubAccount user = (ElsSubAccount)JSON.parseObject((String)jsonObject.toJSONString(), ElsSubAccount.class);
            if (StringUtils.isNotBlank((CharSequence)user.getOrgCode())) {
                ElsSubAccountOrgService elsSubAccountOrgService = (ElsSubAccountOrgService)SpringContextUtils.getBean("purchaseOrganizationInfoServiceImpl");
                boolean includCompany = elsSubAccountOrgService.checkOrgCode(user.getOrgCode());
                Assert.isTrue((!includCompany ? 1 : 0) != 0, (String)I18nUtil.translate("i18n_alert_xGxOiFRC_4b44d29c", "\u90e8\u95e8\u4e0d\u80fd\u9009\u62e9\u516c\u53f8"));
            }
            user.setUpdateTime(new Date());
            user.setPassword(sysUser.getPassword());
            String roles = jsonObject.getString("selectedroles");
            this.elsSubAccountService.editUserWithRole(user, roles);
            result.success(I18nUtil.translate("i18n_alert_crLR_25ddaeda", "\u4fee\u6539\u6210\u529f!"));
        }
        return result;
    }

    @RequestMapping(value={"/querySubAccount"}, method={RequestMethod.GET})
    public Result<?> querySubAccount(@RequestParam(name="elsAccount") String elsAccount, @RequestParam(name="subAccount") String subAccount) {
        ElsSubAccount elsSubAccount = this.elsSubAccountService.getByAccount(elsAccount, subAccount);
        return Result.ok(elsSubAccount);
    }

    @AutoLog(value="\u7528\u6237\u8d26\u6237-\u5220\u9664", operateType=4)
    @RequiresPermissions(value={"account:delete"})
    @RequestMapping(value={"/delete"}, method={RequestMethod.GET})
    public Result<?> delete(@RequestParam(name="id") String id) {
        this.elsSubAccountService.deleteUser(id);
        return Result.ok("\u5220\u9664\u7528\u6237\u6210\u529f");
    }

    @AutoLog(value="\u7528\u6237\u8d26\u6237-\u6279\u91cf\u5220\u9664", operateType=4)
    @RequestMapping(value={"/deleteBatch"}, method={RequestMethod.GET})
    public Result<?> deleteBatch(@RequestParam(name="ids") String ids) {
        this.elsSubAccountService.deleteBatchUsers(ids);
        return Result.ok("\u6279\u91cf\u5220\u9664\u7528\u6237\u6210\u529f");
    }

    @AutoLog(value="\u7528\u6237\u8d26\u6237-\u51bb\u7ed3/\u89e3\u51bb\u7528\u6237")
    @RequestMapping(value={"/frozenBatch"}, method={RequestMethod.POST})
    @RequiresPermissions(value={"account:frozenBatch"})
    public Result<ElsSubAccount> frozenBatch(@RequestBody JSONObject jsonObject) {
        Result<ElsSubAccount> result = new Result<ElsSubAccount>();
        try {
            String[] arr;
            String ids = jsonObject.getString("ids");
            String status = jsonObject.getString("status");
            for (String id : arr = ids.split(",")) {
                if (!ConvertUtils.isNotEmpty(id)) continue;
                this.elsSubAccountService.update(new ElsSubAccount().setStatus(Integer.parseInt(status)), (Wrapper)new UpdateWrapper().lambda().eq(BaseEntity::getId, (Object)id));
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            result.error500(I18nUtil.translate("i18n_alert_tkKm_2f078e83", "\u64cd\u4f5c\u5931\u8d25:") + e.getMessage());
        }
        result.success(I18nUtil.translate("i18n_title_operationSuccess", "\u64cd\u4f5c\u6210\u529f!"));
        return result;
    }

    @RequestMapping(value={"/queryById"}, method={RequestMethod.GET})
    public Result<Object> queryById(@RequestParam(name="id") String id) {
        Result<Object> result = new Result<Object>();
        ElsSubAccount sysUser = (ElsSubAccount)this.elsSubAccountService.getById((Serializable)((Object)id));
        if (sysUser == null) {
            result.error500(I18nUtil.translate("i18n_alert_LYuIdKD_12f57c8c", "\u672a\u627e\u5230\u5bf9\u5e94\u5b9e\u4f53"));
        } else {
            List userRole = this.userRoleService.list((Wrapper)new QueryWrapper().lambda().eq(UserRole::getUserId, (Object)sysUser.getId()));
            StringBuilder str = new StringBuilder();
            if (CollectionUtils.isNotEmpty((Collection)userRole)) {
                for (UserRole sysUserRole : userRole) {
                    str.append(sysUserRole.getRoleId()).append(",");
                }
            }
            String json = JSONObject.toJSONString((Object)sysUser);
            JSONObject jo = JSON.parseObject((String)json);
            jo.put("selectedroles", (Object)(str.length() > 0 ? str.substring(0, str.length() - 1) : ""));
            jo.remove((Object)"password");
            result.setResult(jo);
            result.setSuccess(true);
        }
        return result;
    }

    @RequestMapping(value={"/queryUserRole"}, method={RequestMethod.GET})
    public Result<List<String>> queryUserRole(@RequestParam(name="userid") String userid) {
        Result<List<String>> result = new Result<List<String>>();
        ArrayList<String> list = new ArrayList<String>();
        List userRole = this.userRoleService.list((Wrapper)new QueryWrapper().lambda().eq(UserRole::getUserId, (Object)userid));
        if (userRole == null || userRole.size() <= 0) {
            result.error500(I18nUtil.translate("i18n_alert_LYujDdRKyVH_e787be74", "\u672a\u627e\u5230\u7528\u6237\u76f8\u5173\u89d2\u8272\u4fe1\u606f"));
        } else {
            for (UserRole sysUserRole : userRole) {
                list.add(sysUserRole.getRoleId());
            }
            result.setSuccess(true);
            result.setResult(list);
        }
        return result;
    }

    @RequestMapping(value={"/deliverTo"}, method={RequestMethod.GET})
    public Result<?> deliverTo(@RequestParam(name="sourceAccountId") String sourceAccountId, @RequestParam(name="targetAccountId") String targetAccountId) {
        this.elsSubAccountService.deliverTo(sourceAccountId, targetAccountId);
        return Result.ok(I18nUtil.translate("i18n_title_operationSuccess", "\u64cd\u4f5c\u6210\u529f!"));
    }

    @RequestMapping(value={"/checkOnlyUser"}, method={RequestMethod.GET})
    public Result<Boolean> checkOnlyUser(ElsSubAccount sysUser) {
        Result<Boolean> result = new Result<Boolean>();
        result.setResult(true);
        try {
            ElsSubAccount user = (ElsSubAccount)this.elsSubAccountService.getOne((Wrapper)new QueryWrapper((Object)sysUser));
            if (user != null) {
                result.setSuccess(false);
                result.setMessage("\u7528\u6237\u8d26\u53f7\u5df2\u5b58\u5728");
                return result;
            }
        }
        catch (Exception e) {
            result.setSuccess(false);
            result.setMessage(e.getMessage());
            return result;
        }
        result.setSuccess(true);
        return result;
    }

    @AutoLog(value="\u7528\u6237\u8d26\u6237-\u66f4\u6539\u7528\u6237\u5bc6\u7801", operateType=3)
    @RequestMapping(value={"/changPassword"}, method={RequestMethod.POST})
    @RequiresPermissions(value={"account:changPassword"})
    public Result<?> changPassword(@RequestBody ElsSubAccount sysUser) {
        ElsSubAccount u = (ElsSubAccount)this.elsSubAccountService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(BaseEntity::getElsAccount, (Object)sysUser.getElsAccount())).eq(ElsSubAccount::getSubAccount, (Object)sysUser.getSubAccount()));
        if (u == null) {
            return Result.error(I18nUtil.translate("i18n_alert_jDxMKW_782540b3", "\u7528\u6237\u4e0d\u5b58\u5728\uff01"));
        }
        sysUser.setId(u.getId());
        sysUser.setAccountValidityDate(u.getAccountValidityDate());
        return this.elsSubAccountService.changePassword(sysUser);
    }

    @AutoLog(value="\u7528\u6237\u8d26\u6237-\u751f\u6210\u7528\u6237ID", operateType=1)
    @RequestMapping(value={"/generateUserId"}, method={RequestMethod.GET})
    public Result<String> generateUserId() {
        Result<String> result = new Result<String>();
        System.out.println("\u6211\u6267\u884c\u4e86,\u751f\u6210\u7528\u6237ID==============================");
        String userId = UUID.randomUUID().toString().replace("-", "");
        result.setSuccess(true);
        result.setResult(userId);
        return result;
    }

    @RequestMapping(value={"/queryUserRoleMap"}, method={RequestMethod.GET})
    public Result<Map<String, String>> queryUserRole() {
        Result<Map<String, String>> result = new Result<Map<String, String>>();
        Map<String, String> map = this.userRoleService.queryUserRole();
        result.setResult(map);
        result.setSuccess(true);
        return result;
    }

    @AutoLog(value="\u7528\u6237\u8d26\u6237-\u5bfc\u51faExcel", operateType=6)
    @PostMapping(value={"/exportXls"})
    public ModelAndView exportXls(ElsSubAccount sysUser, HttpServletRequest request, @RequestBody SelectionsDto selectionsDto) {
        List<String> selectionList;
        QueryWrapper<ElsSubAccount> queryWrapper = QueryGenerator.initQueryWrapper(sysUser, request.getParameterMap());
        LoginUser user = (LoginUser)SecurityUtils.getSubject().getPrincipal();
        String[] selections = selectionsDto.getSelections();
        if (ConvertUtils.isNotEmpty(selections) && CollectionUtil.isNotEmpty(selectionList = Arrays.asList(selections))) {
            queryWrapper.clear();
            Map parameterMap = request.getParameterMap();
            QueryGenerator.doMultiFieldsOrder(queryWrapper, parameterMap, sysUser);
            queryWrapper.in((Object)"id", selectionList);
        }
        queryWrapper.lambda().eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant());
        List pageList = this.elsSubAccountService.list((Wrapper)queryWrapper);
        List result = Convert.toList(ElsSubAccountVO.class, (Object)pageList);
        List<String> codes = result.stream().filter(x -> StrUtil.isNotEmpty((CharSequence)x.getOrgCode())).flatMap(x -> Arrays.stream(x.getOrgCode().split(","))).distinct().collect(Collectors.toList());
        ElsSubAccountOrgService elsSubAccountOrgService = (ElsSubAccountOrgService)SpringContextUtils.getBean("purchaseOrganizationInfoServiceImpl");
        Map<String, String> orgMap = elsSubAccountOrgService.listDeptOrganization(codes);
        for (ElsSubAccountVO elsSubAccount : result) {
            String orgCode = elsSubAccount.getOrgCode();
            if (!StrUtil.isNotEmpty((CharSequence)orgCode)) continue;
            ArrayList ids = Lists.newArrayList((Object[])orgCode.split(","));
            String org = ids.stream().filter(orgMap::containsKey).map(orgMap::get).collect(Collectors.joining(","));
            elsSubAccount.setOrgCode_dictText(org);
        }
        ModelAndView mv = new ModelAndView((View)new ELSEntityExcelView());
        mv.addObject("fileName", (Object)"\u7528\u6237\u5217\u8868");
        mv.addObject("entity", ElsSubAccount.class);
        mv.addObject("params", (Object)new ExportParams("\u7528\u6237\u5217\u8868\u6570\u636e", "\u5bfc\u51fa\u4eba:" + user.getRealname(), "\u5bfc\u51fa\u4fe1\u606f", request.getParameter("defineColumnCode")));
        mv.addObject("data", (Object)result);
        return mv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AutoLog(value="\u7528\u6237\u8d26\u6237-\u5bfc\u5165Excel", operateType=5)
    @RequiresPermissions(value={"user:import"})
    @RequestMapping(value={"/importExcel"}, method={RequestMethod.POST})
    public Result<?> importExcel(HttpServletRequest request) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        Iterator iterator = fileMap.entrySet().iterator();
        if (iterator.hasNext()) {
            Map.Entry entity = iterator.next();
            MultipartFile file = (MultipartFile)entity.getValue();
            ImportParams params = new ImportParams();
            params.setTitleRows(2);
            params.setHeadRows(1);
            params.setNeedSave(true);
            try {
                List<ElsSubAccount> listSysUsers = ExcelImportUtil.importExcel(file.getInputStream(), ElsSubAccount.class, params);
                for (ElsSubAccount sysUserExcel : listSysUsers) {
                    if (sysUserExcel.getPassword() == null) {
                        sysUserExcel.setPassword("123456");
                    }
                    this.elsSubAccountService.save(sysUserExcel);
                }
                Result<Object> result = Result.ok(I18nUtil.translate("i18n_alert_QIuNLRWWFcW_6e8a1fc", "\u6587\u4ef6\u5bfc\u5165\u6210\u529f\uff01\u6570\u636e\u884c\u6570:${0}", String.valueOf(listSysUsers.size())));
                return result;
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                Result<Object> result = Result.error(I18nUtil.translate("i18n_alert_sPWWLuNjWFsjDRIOMK_846eca6", "\u62b1\u6b49! \u60a8\u5bfc\u5165\u7684\u6570\u636e\u4e2d\u7528\u6237\u540d\u5df2\u7ecf\u5b58\u5728."));
                return result;
            }
            finally {
                try {
                    file.getInputStream().close();
                }
                catch (IOException e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        return Result.error(I18nUtil.translate("i18n_alert_QIuNKm_c396138c", "\u6587\u4ef6\u5bfc\u5165\u5931\u8d25!"));
    }

    @RequestMapping(value={"/queryByIds"}, method={RequestMethod.GET})
    public Result<Collection<ElsSubAccount>> queryByIds(@RequestParam String userIds) {
        Result<Collection<ElsSubAccount>> result = new Result<Collection<ElsSubAccount>>();
        String[] userId = userIds.split(",");
        List<String> idList = Arrays.asList(userId);
        List userRole = this.elsSubAccountService.listByIds(idList);
        result.setSuccess(true);
        result.setResult(userRole);
        return result;
    }

    @AutoLog(value="\u7528\u6237\u8d26\u6237-\u66f4\u65b0\u5bc6\u7801", operateType=3)
    @RequestMapping(value={"/updatePassword"}, method={RequestMethod.POST})
    public Result<?> updatePassword(@RequestBody JSONObject json) {
        String elsAccount = json.getString("elsAccount");
        String subAccount = json.getString("subAccount");
        String oldpassword = json.getString("oldpassword");
        String password = json.getString("password");
        String confirmpassword = json.getString("confirmpassword");
        ElsSubAccount user = (ElsSubAccount)this.elsSubAccountService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(ElsSubAccount::getSubAccount, (Object)subAccount)).eq(BaseEntity::getElsAccount, (Object)elsAccount));
        if (user == null) {
            return Result.error(I18nUtil.translate("i18n_alert_jDxMKW_782540b3", "\u7528\u6237\u4e0d\u5b58\u5728\uff01"));
        }
        return this.elsSubAccountService.resetPassword(subAccount, oldpassword, password, confirmpassword);
    }

    @RequestMapping(value={"/userRoleList"}, method={RequestMethod.GET})
    public Result<IPage<ElsSubAccount>> userRoleList(@RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        Result<IPage<ElsSubAccount>> result = new Result<IPage<ElsSubAccount>>();
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        String roleId = req.getParameter("roleId");
        String username = req.getParameter("username");
        if (StringUtils.isEmpty((CharSequence)username)) {
            username = req.getParameter("subAccount");
        }
        IPage<ElsSubAccount> pageList = this.elsSubAccountService.getUserByRoleId((Page<ElsSubAccount>)page, roleId, username);
        result.setSuccess(true);
        result.setResult(pageList);
        return result;
    }

    @AutoLog(value="\u7528\u6237\u8d26\u6237-\u7ed9\u6307\u5b9a\u89d2\u8272\u6dfb\u52a0\u7528\u6237", operateType=2)
    @RequestMapping(value={"/addSysUserRole"}, method={RequestMethod.POST})
    public Result<String> addSysUserRole(@RequestBody UserRoleVO sysUserRoleVO) {
        Result<String> result = new Result<String>();
        try {
            String sysRoleId = sysUserRoleVO.getRoleId();
            for (String sysUserId : sysUserRoleVO.getUserIdList()) {
                UserRole sysUserRole = new UserRole(sysUserId, sysRoleId);
                QueryWrapper queryWrapper = new QueryWrapper();
                ((QueryWrapper)queryWrapper.eq((Object)"role_id", (Object)sysRoleId)).eq((Object)"user_id", (Object)sysUserId);
                UserRole one = (UserRole)this.userRoleService.getOne((Wrapper)queryWrapper);
                if (one != null) continue;
                this.userRoleService.save(sysUserRole);
            }
            result.setMessage(I18nUtil.translate("i18n_alert_SuLRW_34dd402d", "\u6dfb\u52a0\u6210\u529f\uff01"));
            result.setSuccess(true);
            return result;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            result.setSuccess(false);
            result.setMessage("\u51fa\u9519\u4e86: " + e.getMessage());
            return result;
        }
    }

    @AutoLog(value="\u7528\u6237\u8d26\u6237-\u5220\u9664\u6307\u5b9a\u89d2\u8272\u7684\u7528\u6237\u5173\u7cfb", operateType=4)
    @RequestMapping(value={"/deleteUserRole"}, method={RequestMethod.GET})
    public Result<UserRole> deleteUserRole(@RequestParam(name="roleId") String roleId, @RequestParam(name="userId") String userId) {
        Result<UserRole> result = new Result<UserRole>();
        try {
            QueryWrapper queryWrapper = new QueryWrapper();
            ((QueryWrapper)queryWrapper.eq((Object)"role_id", (Object)roleId)).eq((Object)"user_id", (Object)userId);
            this.userRoleService.remove((Wrapper)queryWrapper);
            result.success(I18nUtil.translate("i18n_alert_deleteSuccess", "\u5220\u9664\u6210\u529f!"));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            result.error500(I18nUtil.translate("i18n_alert_deleteFail", "\u5220\u9664\u5931\u8d25!"));
        }
        return result;
    }

    @GetMapping(value={"/getDocToken"})
    public Result<?> getDocToken() throws Exception {
        return Result.ok(ShowDocTokenUtil.getToken());
    }

    @AutoLog(value="\u7528\u6237\u8d26\u6237-\u6279\u91cf\u5220\u9664\u6307\u5b9a\u89d2\u8272\u7684\u7528\u6237\u5173\u7cfb", operateType=4)
    @RequestMapping(value={"/deleteUserRoleBatch"}, method={RequestMethod.GET})
    public Result<UserRole> deleteUserRoleBatch(@RequestParam(name="roleId") String roleId, @RequestParam(name="userIds") String userIds) {
        Result<UserRole> result = new Result<UserRole>();
        try {
            QueryWrapper queryWrapper = new QueryWrapper();
            ((QueryWrapper)queryWrapper.eq((Object)"role_id", (Object)roleId)).in((Object)"user_id", Arrays.asList(userIds.split(",")));
            this.userRoleService.remove((Wrapper)queryWrapper);
            result.success(I18nUtil.translate("i18n_alert_deleteSuccess", "\u5220\u9664\u6210\u529f!"));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            result.error500(I18nUtil.translate("i18n_alert_deleteFail", "\u5220\u9664\u5931\u8d25!"));
        }
        return result;
    }

    @RequestMapping(value={"/departUserList"}, method={RequestMethod.GET})
    public Result<IPage<ElsSubAccount>> departUserList(@RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        Result<IPage<ElsSubAccount>> result = new Result<IPage<ElsSubAccount>>();
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        String depId = req.getParameter("depId");
        String username = req.getParameter("username");
        IPage<ElsSubAccount> pageList = this.elsSubAccountService.getUserByDepId((Page<ElsSubAccount>)page, depId, username);
        result.setSuccess(true);
        result.setResult(pageList);
        return result;
    }

    @AutoLog(value="\u7528\u6237\u8d26\u6237-\u6ce8\u518c", operateType=2)
    @PostMapping(value={"/register"})
    public Result<JSONObject> userRegister(@RequestBody JSONObject jsonObject, ElsSubAccount user) {
        Result<JSONObject> result = new Result<JSONObject>();
        String phone = jsonObject.getString("phone");
        String smscode = jsonObject.getString("smscode");
        Object code = this.redisUtil.get(phone);
        String username = jsonObject.getString("username");
        String password = jsonObject.getString("password");
        String email = jsonObject.getString("email");
        ElsSubAccount sysUser1 = this.elsSubAccountService.getUserBySubAccount(username);
        if (sysUser1 != null) {
            result.setMessage("\u7528\u6237\u540d\u5df2\u6ce8\u518c");
            result.setSuccess(false);
            return result;
        }
        ElsSubAccount sysUser2 = this.elsSubAccountService.getUserByPhone(phone);
        if (sysUser2 != null) {
            result.setMessage("\u8be5\u624b\u673a\u53f7\u5df2\u6ce8\u518c");
            result.setSuccess(false);
            return result;
        }
        ElsSubAccount sysUser3 = this.elsSubAccountService.getUserByEmail(email);
        if (sysUser3 != null) {
            result.setMessage("\u90ae\u7bb1\u5df2\u88ab\u6ce8\u518c");
            result.setSuccess(false);
            return result;
        }
        if (!smscode.equals(code)) {
            result.setMessage("\u624b\u673a\u9a8c\u8bc1\u7801\u9519\u8bef");
            result.setSuccess(false);
            return result;
        }
        try {
            user.setCreateTime(new Date());
            String salt = ConvertUtils.randomGen(8);
            String passwordEncode = PasswordUtil.encrypt(username, password, salt);
            user.setSalt(salt);
            user.setSubAccount(username);
            user.setRealname(username);
            user.setPassword(passwordEncode);
            user.setEmail(email);
            user.setPhone(phone);
            user.setStatus(1);
            user.setDeleted(CommonConstant.DEL_FLAG_0);
            user.setActivitiSync("1");
            this.elsSubAccountService.addUserWithRole(user, "ee8626f80f7c2619917b6236f3a7f02b");
            result.success(I18nUtil.translate("i18n_alert_diLR_32bfdb33", "\u6ce8\u518c\u6210\u529f"));
        }
        catch (Exception e) {
            result.error500(I18nUtil.translate("i18n_alert_diKm_32bf02b8", "\u6ce8\u518c\u5931\u8d25"));
        }
        return result;
    }

    @GetMapping(value={"/querySysUser"})
    public Result<Map<String, Object>> querySysUser(ElsSubAccount sysUser) {
        ElsSubAccount user;
        String phone = sysUser.getPhone();
        String username = sysUser.getSubAccount();
        Result<Map<String, Object>> result = new Result<Map<String, Object>>();
        HashMap<String, String> map = new HashMap<String, String>();
        if (ConvertUtils.isNotEmpty(phone) && (user = this.elsSubAccountService.getUserByPhone(phone)) != null) {
            map.put("username", user.getSubAccount());
            map.put("phone", user.getPhone());
            result.setSuccess(true);
            result.setResult(map);
            return result;
        }
        if (ConvertUtils.isNotEmpty(username) && (user = this.elsSubAccountService.getUserBySubAccount(username)) != null) {
            map.put("username", user.getSubAccount());
            map.put("phone", user.getPhone());
            result.setSuccess(true);
            result.setResult(map);
            return result;
        }
        result.setSuccess(false);
        result.setMessage("\u9a8c\u8bc1\u5931\u8d25");
        return result;
    }

    @AutoLog(value="\u7528\u6237\u8d26\u6237-\u7528\u6237\u624b\u673a\u53f7\u9a8c\u8bc1", operateType=1)
    @PostMapping(value={"/phoneVerification"})
    public Result<String> phoneVerification(@RequestBody JSONObject jsonObject) {
        Object code;
        Result<String> result = new Result<String>();
        String phone = jsonObject.getString("phone");
        String smscode = jsonObject.getString("smscode");
        if (!smscode.equals(code = this.redisUtil.get(phone))) {
            result.setMessage("\u624b\u673a\u9a8c\u8bc1\u7801\u9519\u8bef");
            result.setSuccess(false);
            return result;
        }
        this.redisUtil.set(phone, smscode);
        result.setResult(smscode);
        result.setSuccess(true);
        return result;
    }

    @AutoLog(value="\u7528\u6237\u8d26\u6237-\u7528\u6237\u66f4\u6539\u5bc6\u7801", operateType=3)
    @GetMapping(value={"/passwordChange"})
    public Result<ElsSubAccount> passwordChange(@RequestParam(name="username") String username, @RequestParam(name="password") String password, @RequestParam(name="smscode") String smscode, @RequestParam(name="phone") String phone) {
        ElsSubAccount sysUser;
        Result<ElsSubAccount> result = new Result<ElsSubAccount>();
        Object object = this.redisUtil.get(phone);
        if (null == object) {
            result.setMessage("\u66f4\u6539\u5bc6\u7801\u5931\u8d25");
            result.setSuccess(false);
        }
        if (!smscode.equals(object)) {
            result.setMessage("\u66f4\u6539\u5bc6\u7801\u5931\u8d25");
            result.setSuccess(false);
        }
        if ((sysUser = (ElsSubAccount)this.elsSubAccountService.getOne((Wrapper)new LambdaQueryWrapper().eq(ElsSubAccount::getSubAccount, (Object)username))) == null) {
            result.setMessage(I18nUtil.translate("i18n_alert_LYuIdKD_12f57c8c", "\u672a\u627e\u5230\u5bf9\u5e94\u5b9e\u4f53"));
            result.setSuccess(false);
            return result;
        }
        String salt = ConvertUtils.randomGen(8);
        sysUser.setSalt(salt);
        String passwordEncode = PasswordUtil.encrypt(sysUser.getSubAccount(), password, salt);
        sysUser.setPassword(passwordEncode);
        this.elsSubAccountService.updateById(sysUser);
        result.setSuccess(true);
        result.setMessage("\u5bc6\u7801\u4fee\u6539\u5b8c\u6210\uff01");
        return result;
    }

    @GetMapping(value={"/getUserSectionInfoByToken"})
    public Result<?> getUserSectionInfoByToken(HttpServletRequest request, @RequestParam(name="token", required=false) String token) {
        try {
            String account = ConvertUtils.isEmpty(token) ? JwtUtil.getUserNameByToken(request) : JwtUtil.getAccount(token);
            log.info(" ------ \u901a\u8fc7\u4ee4\u724c\u83b7\u53d6\u90e8\u5206\u7528\u6237\u4fe1\u606f\uff0c\u5f53\u524d\u7528\u6237\uff1a " + account);
            ElsSubAccount sysUser = this.elsSubAccountService.getUserByAccount(account);
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("sysUserId", sysUser.getId());
            map.put("sysUserCode", sysUser.getSubAccount());
            map.put("sysUserName", sysUser.getRealname());
            map.put("sysOrgCode", sysUser.getOrgCode());
            log.info(" ------ \u901a\u8fc7\u4ee4\u724c\u83b7\u53d6\u90e8\u5206\u7528\u6237\u4fe1\u606f\uff0c\u5df2\u83b7\u53d6\u7684\u7528\u6237\u4fe1\u606f\uff1a " + map);
            return Result.ok(map);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error(500, I18nUtil.translate("i18n_field_mhKm_3152c771", "\u67e5\u8be2\u5931\u8d25:") + e.getMessage());
        }
    }

    @GetMapping(value={"/appUserList"})
    public Result<?> appUserList(@RequestParam(name="keyword", required=false) String keyword, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize) {
        try {
            LambdaQueryWrapper query = new LambdaQueryWrapper();
            query.eq(ElsSubAccount::getActivitiSync, (Object)"1");
            query.eq(BaseEntity::getDeleted, (Object)"0");
            query.and(i -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)i.like(ElsSubAccount::getSubAccount, (Object)keyword)).or()).like(ElsSubAccount::getRealname, (Object)keyword);
            });
            Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
            IPage res = this.elsSubAccountService.page((IPage)page, (Wrapper)query);
            return Result.ok(res);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error(500, I18nUtil.translate("i18n_field_mhKm_3152c771", "\u67e5\u8be2\u5931\u8d25:") + e.getMessage());
        }
    }

    @AutoLog(value="\u7528\u6237\u8d26\u6237-\u7ed1\u5b9a\u624b\u673a\u53f7/\u90ae\u7bb1", operateType=3)
    @PostMapping(value={"/bindSubAccount"})
    public Result<?> bindSubAccount(@RequestBody JSONObject jsonObject) {
        log.info("ElsSubAccountController->bindSubAccount: jsonObject: " + jsonObject.toString());
        Result result = new Result();
        LoginUser loginUser = (LoginUser)SecurityUtils.getSubject().getPrincipal();
        String bindType = jsonObject.getString("bindType");
        String elsAccount = loginUser.getElsAccount();
        String subAccount = loginUser.getSubAccount();
        String id = jsonObject.getString("id");
        ElsSubAccount user = new ElsSubAccount();
        user.setId(id);
        user.setElsAccount(elsAccount);
        user.setSubAccount(subAccount);
        if ("phoneBind".equals(bindType)) {
            String phone = jsonObject.getString("phone");
            ElsSubAccount sysUser = this.elsSubAccountService.getBindPhoneByPhoneAndAccount(elsAccount, subAccount, phone);
            if (sysUser != null) {
                result.setMessage("\u8be5\u624b\u673a\u53f7\u5df2\u88ab\u7ed1\u5b9a\uff01");
                result.setSuccess(false);
                return result;
            }
            String smsCode = jsonObject.getString("smscode");
            String key = phone + ":" + elsAccount;
            if (!this.redisUtil.hasKey(key)) {
                result.setMessage("\u624b\u673a\u9a8c\u8bc1\u7801\u4e0d\u5b58\u5728\uff01");
                result.setSuccess(false);
                return result;
            }
            Object code = this.redisUtil.get(key);
            if (!smsCode.equals(code)) {
                result.setMessage("\u624b\u673a\u9a8c\u8bc1\u7801\u9519\u8bef\uff01");
                result.setSuccess(false);
                return result;
            }
            user.setPhone(phone);
            this.redisUtil.del(key);
        } else if ("emailBind".equals(bindType)) {
            Object ecode;
            String email = jsonObject.getString("email");
            ElsSubAccount sysUser2 = this.elsSubAccountService.getBindEmailByEmailAndAccount(elsAccount, subAccount, email);
            if (sysUser2 != null) {
                result.setMessage("\u90ae\u7bb1\u5df2\u88ab\u7ed1\u5b9a\uff01");
                result.setSuccess(false);
                return result;
            }
            String emailCode = jsonObject.getString("emailcode");
            if (!emailCode.equals(ecode = this.redisUtil.get(email))) {
                result.setMessage("\u90ae\u7bb1\u9a8c\u8bc1\u7801\u9519\u8bef\uff01");
                result.setSuccess(false);
                return result;
            }
            user.setEmail(email);
        }
        user.setUpdateBy(subAccount);
        user.setUpdateTime(new Date());
        this.elsSubAccountService.updateById(user);
        String delAccountRedis = String.format("%s::%s", "sys:cache:user", elsAccount + "_" + subAccount);
        this.redisUtil.del(delAccountRedis);
        return Result.ok(user);
    }

    @AutoLog(value="\u7528\u6237\u8d26\u6237-\u53d1\u9001\u90ae\u7bb1\u9a8c\u8bc1\u7801", operateType=1)
    @PostMapping(value={"/sendEmailCode"})
    public Result<?> sendEmailCode(@RequestBody JSONObject jsonObject) {
        log.info("ElsSubAccountController->sendEmailCode: json: " + jsonObject);
        Result result = new Result();
        String receiveEmailAddress = jsonObject.getString("email");
        String subject = "\u90ae\u7bb1\u9a8c\u8bc1\u7801";
        String emailCode = RandomUtil.randomNumbers((int)6);
        String mailContent = "\u9a8c\u8bc1\u7801\u4e3a\uff1a" + emailCode;
        try {
            MailUtil.send((String)receiveEmailAddress, (String)subject, (String)mailContent, (boolean)false, (File[])new File[0]);
            this.redisUtil.set(receiveEmailAddress, emailCode, 600L);
            result.setMessage("\u90ae\u4ef6\u9a8c\u8bc1\u7801\u53d1\u9001\u6210\u529f");
            result.setSuccess(true);
        }
        catch (Exception e) {
            log.error("ElsSubAccountController->sendEmailCode error: ", (Throwable)e);
            result.setMessage("\u90ae\u4ef6\u9a8c\u8bc1\u7801\u53d1\u9001\u5931\u8d25,\u8bf7\u7a0d\u540e\u91cd\u8bd5");
            result.setSuccess(false);
            return result;
        }
        return result;
    }

    @GetMapping(value={"/getLoginUser"})
    public Result<?> getLoginUser() {
        LoginUser sysUser = (LoginUser)SecurityUtils.getSubject().getPrincipal();
        return Result.ok(sysUser);
    }

    @GetMapping(value={"/checkUserIsCustomerRole"})
    public Result<Object> checkUserIsCustomerRole() {
        LoginUser loginUser = SysUtil.getLoginUser();
        if (null == loginUser || !"100000".equals(loginUser.getElsAccount())) {
            return Result.ok(false);
        }
        if ("100000".equals(loginUser.getElsAccount()) && "admin".equals(loginUser.getSubAccount())) {
            return Result.ok(true);
        }
        Boolean customerRoleFlag = this.userRoleService.getCustomerRoleFlag(loginUser.getElsAccount(), loginUser.getSubAccount());
        return Result.ok(customerRoleFlag);
    }

    @GetMapping(value={"/getCustomerUser"})
    public Result<Object> getCustomerUser() {
        return Result.ok(this.userRoleService.getCustomerRoleUser());
    }

    @RequestMapping(value={"/getSubAccounts"}, method={RequestMethod.GET})
    public Result<IPage<ElsSubAccount>> getSubAccounts(ElsSubAccount user, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        Result<IPage<ElsSubAccount>> result = new Result<IPage<ElsSubAccount>>();
        QueryWrapper<ElsSubAccount> queryWrapper = QueryGenerator.initQueryWrapper(user, req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        queryWrapper.eq((Object)"els_account", (Object)TenantContext.getTenant());
        IPage pageList = this.elsSubAccountService.page((IPage)page, (Wrapper)queryWrapper);
        List<String> codes = pageList.getRecords().stream().filter(x -> StrUtil.isNotEmpty((CharSequence)x.getOrgCode())).flatMap(x -> Arrays.stream(x.getOrgCode().split(","))).distinct().collect(Collectors.toList());
        ElsSubAccountOrgService elsSubAccountOrgService = (ElsSubAccountOrgService)SpringContextUtils.getBean("purchaseOrganizationInfoServiceImpl");
        Map<String, String> orgMap = elsSubAccountOrgService.listDeptOrganization(codes);
        String jsonString = JSON.toJSONString((Object)pageList);
        IPage page2 = (IPage)JSON.parseObject((String)jsonString, (TypeReference)new TypeReference<Page<ElsSubAccountVO>>(){}, (Feature[])new Feature[0]);
        for (ElsSubAccountVO elsSubAccount : page2.getRecords()) {
            String orgCode = elsSubAccount.getOrgCode();
            if (!StrUtil.isNotEmpty((CharSequence)orgCode)) continue;
            ArrayList ids = Lists.newArrayList((Object[])orgCode.split(","));
            String org = ids.stream().filter(orgMap::containsKey).map(orgMap::get).collect(Collectors.joining(","));
            elsSubAccount.setOrgCode_dictText(org);
        }
        result.setSuccess(true);
        result.setResult(pageList);
        return result;
    }

    @AutoLog(value="SRM\u63a8\u9001\u6d88\u606f\u5230ERP")
    @ApiOperation(value="SRM\u63a8\u9001\u6d88\u606f\u5230ERP", notes="SRM\u63a8\u9001\u6d88\u606f\u5230ERP")
    @GetMapping(value={"/getSubAccountFormERP"})
    @RequiresPermissions(value={"user:getSubAccountFormERP"})
    public Result<?> getSubAccountFormERP() {
        this.elsSubAccountService.getSubAccountFormERP();
        return Result.ok();
    }
}

